/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.impl.resin;

import com.caucho.websocket.WebSocketListener;
import com.caucho.websocket.WebSocketServletRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kasource.web.websocket.WebSocketImpl;
import org.kasource.web.websocket.WebSocketManager;
import org.kasource.web.websocket.impl.resin.ResinWebSocketClient;
import org.kasource.web.websocket.impl.resin.ResinWebSocketManager;
import org.kasource.web.websocket.util.ClientIdGenerator;

public class ResinWebSocketImpl
extends HttpServlet {
    private static final String ATTRIBUTE_PREFIX = WebSocketImpl.class.getPackage().getName() + ".";
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CLIENT_ID_PARAMETER = "username";
    private Map<String, ResinWebSocketManager> managers = new ConcurrentHashMap<String, ResinWebSocketManager>();
    private Set<String> orginWhiteList = new HashSet<String>();
    private String clientIdParameter = "username";
    private boolean dynamicAddressing;
    private ClientIdGenerator idGeneator;

    public void init() throws ServletException {
        String clientId;
        super.init();
        String orgins = this.getInitParameter("orginWhiteList");
        if (orgins != null && !orgins.isEmpty()) {
            String[] orginArr = orgins.split(",");
            this.orginWhiteList.addAll(Arrays.asList(orginArr));
        }
        if ((clientId = this.getInitParameter("clientIdParameter")) != null && !clientId.isEmpty()) {
            this.clientIdParameter = clientId;
        }
        this.idGeneator = new ClientIdGenerator(this.clientIdParameter);
        this.setDymamicAddressing();
        if (!this.dynamicAddressing) {
            this.getWebSocketManager(this.getServletName());
        }
    }

    private void setDymamicAddressing() {
        String dynamic = this.getInitParameter("dynamicAddressing");
        this.dynamicAddressing = dynamic != null && dynamic.toLowerCase().trim().equals("true");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String origin = req.getHeader("Sec-WebSocket-Origin");
        if (!this.validOrigin(origin)) {
            res.sendError(403);
            return;
        }
        String protocols = req.getHeader("Sec-WebSocket-Protocol");
        String subProtocol = null;
        if (protocols != null) {
            subProtocol = this.selectSubProtocol(protocols.split(","));
        }
        if (subProtocol != null) {
            res.setHeader("Sec-WebSocket-Protocol", subProtocol);
        }
        WebSocketServletRequest wsReq = (WebSocketServletRequest)req;
        wsReq.startWebSocket(this.createClient(req));
    }

    private String selectSubProtocol(String[] subProtocols) {
        return null;
    }

    private boolean validOrigin(String origin) {
        if (origin == null) {
            return false;
        }
        if (!this.orginWhiteList.isEmpty()) {
            return this.orginWhiteList.contains(origin);
        }
        return true;
    }

    private WebSocketListener createClient(HttpServletRequest request) {
        String managerName = this.getServletName();
        if (this.dynamicAddressing) {
            managerName = request.getRequestURI().substring(request.getContextPath().length());
        }
        ResinWebSocketManager manager = (ResinWebSocketManager)this.getWebSocketManager(managerName);
        String id = this.idGeneator.getId(request, manager);
        return new ResinWebSocketClient(manager, id, request.getParameterMap());
    }

    public WebSocketManager getWebSocketManager(String socketName) {
        if (!this.managers.containsKey(socketName)) {
            ResinWebSocketManager manager = new ResinWebSocketManager();
            this.managers.put(socketName, manager);
            this.getServletContext().setAttribute(ATTRIBUTE_PREFIX + socketName, (Object)manager);
            return manager;
        }
        return this.managers.get(socketName);
    }
}

