/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.impl.resin;

import com.caucho.websocket.WebSocketContext;
import com.caucho.websocket.WebSocketListener;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.kasource.web.websocket.impl.WebSocketClient;
import org.kasource.web.websocket.impl.resin.ResinWebSocketManager;
import org.kasource.web.websocket.util.IoUtils;

public class ResinWebSocketClient
implements WebSocketListener,
WebSocketClient {
    private ResinWebSocketManager manager;
    private String id;
    private WebSocketContext context;
    private Map<String, String[]> connectionParameters;
    private IoUtils ioUtils = new IoUtils();

    public ResinWebSocketClient(ResinWebSocketManager manager, String clientId, Map<String, String[]> connectionParameters) {
        this.id = clientId;
        this.manager = manager;
        this.connectionParameters = connectionParameters;
    }

    public void onClose(WebSocketContext context) throws IOException {
    }

    public void onDisconnect(WebSocketContext context) throws IOException {
        this.manager.unregisterClient(this.id);
    }

    public void onReadBinary(WebSocketContext context, InputStream in) throws IOException {
        this.manager.onWebSocketMessage(this.ioUtils.toByteArray(in), this.id);
    }

    public void onReadText(WebSocketContext context, Reader reader) throws IOException {
        this.manager.onWebSocketMessage(this.ioUtils.readString(reader), this.id);
    }

    public void onStart(WebSocketContext context) throws IOException {
        this.context = context;
        this.manager.registerClient(this.id, this, this.connectionParameters);
    }

    public void onTimeout(WebSocketContext context) throws IOException {
    }

    public void sendMessage(String message) throws IOException {
        BufferedWriter out = new BufferedWriter(this.context.startTextMessage());
        out.append(message);
        out.close();
    }

    public void sendBinaryMessage(byte[] message) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(this.context.startBinaryMessage());
        out.write(message);
        out.close();
    }

    @Override
    public void sendMessageToSocket(String message) {
        try {
            this.sendMessage(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void sendMessageToSocket(byte[] message) {
        try {
            this.sendBinaryMessage(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

