/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.impl.jetty;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.websocket.WebSocket;
import org.kasource.web.websocket.impl.WebSocketClient;
import org.kasource.web.websocket.impl.jetty.JettyWebSocketManager;

public class JettyWebSocketClient
implements WebSocket,
WebSocket.OnBinaryMessage,
WebSocket.OnTextMessage,
WebSocketClient {
    private JettyWebSocketManager manager;
    private WebSocket.Connection connection;
    private String id;
    private Map<String, String[]> connectionParameters;

    public JettyWebSocketClient(JettyWebSocketManager manager, String clientId, Map<String, String[]> connectionParameters) {
        this.manager = manager;
        this.id = clientId;
        this.connectionParameters = connectionParameters;
    }

    public void onMessage(String data) {
        this.manager.onWebSocketMessage(data, data);
    }

    public void onMessage(byte[] data, int offset, int length) {
        byte[] message = new byte[length];
        System.arraycopy(message, 0, data, offset, length);
        this.manager.onWebSocketMessage(message, this.id);
    }

    public void onClose(int closeCode, String message) {
        this.manager.unregisterClient(this.id);
    }

    public void onOpen(WebSocket.Connection connection) {
        this.connection = connection;
        this.manager.registerClient(this.id, this, this.connectionParameters);
    }

    public WebSocket.Connection getConnection() {
        return this.connection;
    }

    @Override
    public void sendMessageToSocket(String message) {
        try {
            this.getConnection().sendMessage(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void sendMessageToSocket(byte[] message) {
        try {
            this.getConnection().sendMessage(message, 0, message.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

