/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.kasource.web.websocket.WebSocket;
import org.kasource.web.websocket.WebSocketEventListener;
import org.kasource.web.websocket.WebSocketManager;
import org.kasource.web.websocket.WebSocketMessageListener;
import org.kasource.web.websocket.WebsocketMessageSender;
import org.kasource.web.websocket.event.WebSocketEvent;

public class WebSocketImpl
implements WebSocket,
WebSocketMessageListener,
WebSocketEventListener {
    private WebsocketMessageSender sender;
    private Set<WebSocketMessageListener> messageListeners = new HashSet<WebSocketMessageListener>();
    private Set<WebSocketEventListener> eventListeners = new HashSet<WebSocketEventListener>();

    public WebSocketImpl() {
    }

    public WebSocketImpl(WebSocketManager sender) {
        this.initialize(sender);
    }

    public void initialize(WebSocketManager manager) {
        this.sender = manager;
        manager.addWebSocketMessageListener(this);
        manager.addWebSocketEventListener(this);
    }

    @Override
    public void broadcast(String message) {
        if (this.sender != null) {
            this.sender.broadcast(message);
        }
    }

    @Override
    public void broadcastBinary(byte[] message) {
        if (this.sender != null) {
            this.sender.broadcastBinary(message);
        }
    }

    @Override
    public void sendMessage(String clientId, String message) throws IOException {
        if (this.sender != null) {
            this.sender.sendMessage(clientId, message);
        }
    }

    @Override
    public void sendBinaryMessage(String clientId, byte[] message) throws IOException {
        if (this.sender != null) {
            this.sender.sendBinaryMessage(clientId, message);
        }
    }

    @Override
    public void onMessage(String data, String clientId) {
        for (WebSocketMessageListener listener : this.messageListeners) {
            listener.onMessage(data, clientId);
        }
    }

    @Override
    public void onBinaryMessage(byte[] data, String clientId) {
        for (WebSocketMessageListener listener : this.messageListeners) {
            listener.onBinaryMessage(data, clientId);
        }
    }

    @Override
    public void addMessageListener(WebSocketMessageListener listener) {
        this.messageListeners.add(listener);
    }

    @Override
    public void addEventListener(WebSocketEventListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public void onWebSocketEvent(WebSocketEvent event) {
        for (WebSocketEventListener listener : this.eventListeners) {
            listener.onWebSocketEvent(event);
        }
    }
}

