/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import org.kasource.web.websocket.WebSocketEventListener;
import org.kasource.web.websocket.WebSocketFactory;
import org.kasource.web.websocket.WebSocketImpl;
import org.kasource.web.websocket.WebSocketManager;
import org.kasource.web.websocket.WebSocketMessageListener;

public class WebSocketFactoryImpl
implements WebSocketFactory,
ServletContextAttributeListener {
    private static final String ATTRIBUTE_PREFIX = WebSocketImpl.class.getPackage().getName() + ".";
    private Map<String, WebSocketImpl> webSockets = new ConcurrentHashMap<String, WebSocketImpl>();
    protected ServletContext servletContext;
    private Map<String, WebSocketMessageListener> lazyMessageListeners = new ConcurrentHashMap<String, WebSocketMessageListener>();
    private Map<String, WebSocketEventListener> lazyEventListeners = new ConcurrentHashMap<String, WebSocketEventListener>();

    public void initialize(ServletContext servletContext) throws Exception {
        Enumeration attributeEnum = servletContext.getAttributeNames();
        while (attributeEnum.hasMoreElements()) {
            String attributeName = (String)attributeEnum.nextElement();
            this.addWebSocketManagerFromAttribute(attributeName, servletContext.getAttribute(attributeName));
        }
        servletContext.addListener((EventListener)((Object)this));
    }

    @Override
    public WebSocketImpl get(String socketName) {
        if (this.webSockets.containsKey(socketName)) {
            return this.webSockets.get(socketName);
        }
        WebSocketManager manager = (WebSocketManager)this.servletContext.getAttribute(socketName);
        WebSocketImpl webSocket = null;
        webSocket = manager == null ? new WebSocketImpl() : new WebSocketImpl(manager);
        this.webSockets.put(socketName, webSocket);
        return webSocket;
    }

    @Override
    public void listenTo(String socketName, WebSocketMessageListener listener) {
        if (socketName.contains("*")) {
            for (Map.Entry<String, WebSocketImpl> entry : this.webSockets.entrySet()) {
                if (!entry.getKey().matches(socketName.replace("*", ".*"))) continue;
                entry.getValue().addMessageListener(listener);
            }
            this.lazyMessageListeners.put(socketName, listener);
        } else {
            WebSocketImpl webSocket = this.get(socketName);
            webSocket.addMessageListener(listener);
        }
    }

    @Override
    public void listenTo(String socketName, WebSocketEventListener listener) {
        if (socketName.contains("*")) {
            for (Map.Entry<String, WebSocketImpl> entry : this.webSockets.entrySet()) {
                if (!entry.getKey().matches(socketName.replace("*", ".*"))) continue;
                entry.getValue().addEventListener(listener);
            }
            this.lazyEventListeners.put(socketName, listener);
        } else {
            WebSocketImpl webSocket = this.get(socketName);
            webSocket.addEventListener(listener);
        }
    }

    private void addWebSocketManagerFromAttribute(String attributeName, Object attributeValue) {
        if (attributeValue instanceof WebSocketManager) {
            String socketName = attributeName.substring(ATTRIBUTE_PREFIX.length());
            WebSocketImpl websocket = this.webSockets.get(socketName);
            if (websocket != null) {
                websocket.initialize((WebSocketManager)attributeValue);
            } else {
                WebSocketImpl webSocket = new WebSocketImpl((WebSocketManager)attributeValue);
                this.webSockets.put(socketName, webSocket);
                this.addLazyListeners(socketName, webSocket);
            }
        }
    }

    private void addLazyListeners(String name, WebSocketImpl webSocket) {
        String filter;
        for (Map.Entry<String, WebSocketMessageListener> entry : this.lazyMessageListeners.entrySet()) {
            filter = entry.getKey().replace("*", ".*");
            if (!name.matches(filter)) continue;
            webSocket.addMessageListener(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.lazyEventListeners.entrySet()) {
            filter = entry.getKey().replace("*", ".*");
            if (!name.matches(filter)) continue;
            webSocket.addEventListener((WebSocketEventListener)entry.getValue());
        }
    }

    public void attributeAdded(ServletContextAttributeEvent attributeEvent) {
        this.addWebSocketManagerFromAttribute(attributeEvent.getName(), attributeEvent.getValue());
    }

    public void attributeRemoved(ServletContextAttributeEvent scab) {
    }

    public void attributeReplaced(ServletContextAttributeEvent scab) {
    }
}

