/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.test.util;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.kaazing.test.util.MemoryAppender;

public class LoggingRule
implements TestRule {
    private List<String> expectedPatterns;
    private List<String> forbiddenPatterns;
    private String filterPattern;
    private long timeOutMillis = 2000L;
    private static final long SLEEP_TIME_MILLIS = 50L;

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                base.evaluate();
                long initialTime = System.currentTimeMillis();
                while (true) {
                    try {
                        MemoryAppender.assertMessagesLogged(LoggingRule.this.expectedPatterns, LoggingRule.this.forbiddenPatterns, LoggingRule.this.filterPattern, true);
                        return;
                    }
                    catch (AssertionError e) {
                        if (initialTime + LoggingRule.this.timeOutMillis < System.currentTimeMillis()) {
                            throw e;
                        }
                        Thread.sleep(50L);
                        continue;
                    }
                    break;
                }
            }
        };
    }

    public LoggingRule expectPatterns(List<String> expectedPatterns) {
        this.expectedPatterns = expectedPatterns;
        return this;
    }

    public LoggingRule forbidPatterns(List<String> forbiddenPatterns) {
        this.forbiddenPatterns = forbiddenPatterns;
        return this;
    }

    public LoggingRule filterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
        return this;
    }

    public LoggingRule timeOut(long timeOutMillis, TimeUnit timeUnit) {
        this.timeOutMillis = timeUnit.toMillis(timeOutMillis);
        return this;
    }
}

