/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.test.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public final class Assert {
    private Assert() {
    }

    public static <T extends Map<?, ?>> void assertEmpty(T map) {
        org.junit.Assert.assertThat(map, new IsMapEmpty());
    }

    public static <T extends Collection<?>> void assertEmpty(T collection) {
        org.junit.Assert.assertThat(collection, new IsCollectionEmpty());
    }

    public static void assertEmpty(Object array) {
        org.junit.Assert.assertThat((Object)array, (Matcher)new IsArrayEmpty());
    }

    private static final class IsArrayEmpty
    extends BaseMatcher<Object> {
        private IsArrayEmpty() {
        }

        public void describeTo(Description description) {
            description.appendText("is empty");
        }

        public boolean matches(Object that) {
            return that != null && Array.getLength(that) == 0;
        }
    }

    private static final class IsCollectionEmpty<T extends Collection<?>>
    extends BaseMatcher<T> {
        private IsCollectionEmpty() {
        }

        public void describeTo(Description description) {
            description.appendText("is empty");
        }

        public boolean matches(Object that) {
            return that != null && ((Collection)that).isEmpty();
        }
    }

    private static final class IsMapEmpty<T extends Map<?, ?>>
    extends BaseMatcher<T> {
        private IsMapEmpty() {
        }

        public void describeTo(Description description) {
            description.appendText("is empty");
        }

        public boolean matches(Object that) {
            return that != null && ((Map)that).isEmpty();
        }
    }
}

