/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.test.util;

import org.apache.log4j.PropertyConfigurator;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestWatchman;
import org.junit.runners.model.FrameworkMethod;
import org.kaazing.test.util.MemoryAppender;

public class MethodExecutionTrace
extends TestWatchman {
    private static String currentFullTestName;

    public static String getFullTestName() {
        return currentFullTestName;
    }

    public MethodExecutionTrace(String log4jConfigPropertiesFileName) {
        MemoryAppender.initialize();
        if (log4jConfigPropertiesFileName != null) {
            PropertyConfigurator.configure((String)log4jConfigPropertiesFileName);
        }
    }

    public MethodExecutionTrace() {
        this(null);
    }

    public void starting(FrameworkMethod method) {
        currentFullTestName = this.getFullMethodName(method);
        System.out.println(currentFullTestName + " starting");
    }

    public void failed(Throwable e, FrameworkMethod method) {
        if (e instanceof AssumptionViolatedException) {
            System.out.println(String.format("%s skipped programmatically with reason: %s", this.getFullMethodName(method), e.getMessage()));
        } else {
            System.out.println(this.getFullMethodName(method) + " FAILED with exception " + e);
            e.printStackTrace();
            System.out.println("=================== BEGIN STORED LOG MESSAGES ===========================");
            MemoryAppender.printAllMessages();
            System.out.println("=================== END STORED LOG MESSAGES ===========================");
        }
    }

    public void succeeded(FrameworkMethod method) {
        System.out.println(this.getFullMethodName(method) + " " + "success");
    }

    private String getFullMethodName(FrameworkMethod method) {
        return method.getMethod().getDeclaringClass().getSimpleName() + "." + method.getName();
    }
}

