/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util.ws;

public enum WebSocketWireProtocol {
    RFC_6455(13, 14, 15, 16, 17),
    HIXIE_75(false, -5),
    HIXIE_76(false, -4),
    HYBI_0(false, 0),
    HYBI_1(false, 1),
    HYBI_2(false, 2),
    HYBI_3(false, 3),
    HYBI_4(false, 4),
    HYBI_5(5),
    HYBI_6(6),
    HYBI_7(7),
    HYBI_8(8, 9, 10, 11, 12),
    HYBI_13(13, 14, 15, 16, 17);

    private int[] specificationVersions;
    private boolean nativeExtensionsSupported;

    private WebSocketWireProtocol(int ... specificationVersions) {
        this(true, specificationVersions);
    }

    private WebSocketWireProtocol(boolean nativeExtensionsSupported, int ... specificationVersions) {
        this.nativeExtensionsSupported = nativeExtensionsSupported;
        this.specificationVersions = specificationVersions;
    }

    public int[] getSpecificationVersions() {
        return this.specificationVersions;
    }

    public boolean areNativeExtensionsSupported() {
        return this.nativeExtensionsSupported;
    }

    public static WebSocketWireProtocol valueOf(int specVersion) {
        if (specVersion >= 13 && specVersion <= 17) {
            return RFC_6455;
        }
        for (WebSocketWireProtocol p : WebSocketWireProtocol.values()) {
            for (int specificationVersion : p.getSpecificationVersions()) {
                if (specVersion != specificationVersion) continue;
                return p;
            }
        }
        return null;
    }
}

