/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util.turn;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.kaazing.gateway.util.turn.TurnException;

public class TurnUtils {
    public static final String HMAC_SHA_1 = "HmacSHA1";

    private TurnUtils() {
    }

    public static Key getSharedSecret(KeyStore ks, String alias, char[] password) {
        try {
            return ks.getKey(alias, password);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new TurnException("Unable to get shared secret", e);
        }
    }

    public static char[] generatePassword(String username, Key sharedSecret, String algorithm) {
        Mac hmac;
        byte[] key = sharedSecret.getEncoded();
        try {
            hmac = Mac.getInstance(algorithm);
            SecretKeySpec signingKey = new SecretKeySpec(key, algorithm);
            hmac.init(signingKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new TurnException("Unable to generate password", e);
        }
        return Base64.getEncoder().encodeToString(hmac.doFinal(username.getBytes())).toCharArray();
    }
}

