/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util.ssl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SslCipherSuites {
    private static final Map<String, SslCipher> CIPHERS;
    private static final Map<String, SslCipher> CIPHER_NICKNAMES;
    private static final Map<String, List<SslCipher>> CIPHER_STRENGTHS;
    private static final Map<String, List<SslCipher>> CIPHER_KEY_EXCHANGES;
    private static final Map<String, List<SslCipher>> CIPHER_AUTHNS;
    private static final Map<String, List<SslCipher>> CIPHER_ENCRYPTS;
    private static final Map<String, List<SslCipher>> CIPHER_MACS;
    private static final Map<String, List<SslCipher>> CIPHER_PROTOCOLS;
    private static final List<SslCipher> CIPHER_FIPS;

    private static void initJava8SunDefaultEnabledCipherSuites(Map<String, SslCipher> ciphers, Map<String, SslCipher> ciphersByNickname) {
        SslCipher cipher = new SslCipher("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "ECDHE-ECDSA-AES256-SHA384", 256, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.ECDSA, CipherEncryption.AES256, CipherMAC.SHA384, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "ECDHE-RSA-AES256-SHA384", 256, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.RSA, CipherEncryption.AES256, CipherMAC.SHA384, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_RSA_WITH_AES_256_CBC_SHA256", "AES256-SHA256", 256, CipherStrength.HIGH, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.AES256, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "ECDH-ECDSA-AES256-SHA384", 256, CipherStrength.HIGH, CipherKeyExchange.ECDH_ECDSA, CipherAuthentication.ECDH, CipherEncryption.AES256, CipherMAC.SHA384, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "ECDH-RSA-AES256-SHA384", 256, CipherStrength.HIGH, CipherKeyExchange.ECDH_RSA, CipherAuthentication.ECDH, CipherEncryption.AES256, CipherMAC.SHA384, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "DHE-RSA-AES256-SHA256", 256, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.RSA, CipherEncryption.AES256, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "DHE-DSS-AES256-SHA256", 256, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.DSS, CipherEncryption.AES256, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "ECDHE-ECDSA-AES256-SHA", 256, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.ECDSA, CipherEncryption.AES256, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "ECDHE-RSA-AES256-SHA", 256, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.RSA, CipherEncryption.AES256, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_RSA_WITH_AES_256_CBC_SHA", "AES256-SHA", 256, CipherStrength.HIGH, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.AES256, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "ECDH-ECDSA-AES256-SHA", 256, CipherStrength.HIGH, CipherKeyExchange.ECDH_ECDSA, CipherAuthentication.ECDH, CipherEncryption.AES256, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "ECDH-RSA-AES256-SHA", 256, CipherStrength.HIGH, CipherKeyExchange.ECDH_RSA, CipherAuthentication.ECDH, CipherEncryption.AES256, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "DHE-RSA-AES256-SHA", 256, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.RSA, CipherEncryption.AES256, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "DHE-DSS-AES256-SHA", 256, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.DSS, CipherEncryption.AES256, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "ECDHE-ECDSA-AES128-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.ECDSA, CipherEncryption.AES128, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "ECDHE-RSA-AES128-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.RSA, CipherEncryption.AES128, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_RSA_WITH_AES_128_CBC_SHA256", "AES128-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.AES128, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "ECDH-ECDSA-AES128-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.ECDH_ECDSA, CipherAuthentication.ECDH, CipherEncryption.AES128, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "ECDH-RSA-AES128-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.ECDH_RSA, CipherAuthentication.ECDH, CipherEncryption.AES128, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "DHE-RSA-AES128-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.RSA, CipherEncryption.AES128, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "DHE-DSS-AES128-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.DSS, CipherEncryption.AES128, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "ECDHE-ECDSA-AES128-SHA", 128, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.ECDSA, CipherEncryption.AES128, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "ECDHE-RSA-AES128-SHA", 128, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.RSA, CipherEncryption.AES128, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_RSA_WITH_AES_128_CBC_SHA", "AES128-SHA", 128, CipherStrength.HIGH, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.AES128, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "ECDH-ECDSA-AES128-SHA", 128, CipherStrength.HIGH, CipherKeyExchange.ECDH_ECDSA, CipherAuthentication.ECDH, CipherEncryption.AES128, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "ECDH-RSA-AES128-SHA", 128, CipherStrength.HIGH, CipherKeyExchange.ECDH_RSA, CipherAuthentication.ECDH, CipherEncryption.AES128, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "DHE-RSA-AES128-SHA", 128, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.RSA, CipherEncryption.AES128, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "DHE-DSS-AES128-SHA", 128, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.DSS, CipherEncryption.AES128, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "ECDHE-ECDSA-RC4-SHA", 128, CipherStrength.MEDIUM, CipherKeyExchange.ECDHE, CipherAuthentication.ECDSA, CipherEncryption.RC4, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_RSA_WITH_RC4_128_SHA", "ECDHE-RSA-RC4-SHA", 128, CipherStrength.MEDIUM, CipherKeyExchange.ECDHE, CipherAuthentication.RSA, CipherEncryption.RC4, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_RSA_WITH_RC4_128_SHA", "RC4-SHA", 128, CipherStrength.MEDIUM, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.RC4, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "ECDH-ECDSA-RC4-SHA", 128, CipherStrength.MEDIUM, CipherKeyExchange.ECDH_ECDSA, CipherAuthentication.ECDH, CipherEncryption.RC4, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_RSA_WITH_RC4_128_SHA", "ECDH-RSA-RC4-SHA", 128, CipherStrength.MEDIUM, CipherKeyExchange.ECDH_RSA, CipherAuthentication.ECDH, CipherEncryption.RC4, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "ECDHE-ECDSA-AES256-GCM-SHA384", 256, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.ECDSA, CipherEncryption.AESGCM256, CipherMAC.AEAD, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "ECDHE-ECDSA-AES128-GCM-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.ECDSA, CipherEncryption.AESGCM128, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "ECDHE-RSA-AES256-GCM-SHA384", 256, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.RSA, CipherEncryption.AESGCM256, CipherMAC.AEAD, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_RSA_WITH_AES_256_GCM_SHA384", "AES256-GCM-SHA384", 256, CipherStrength.HIGH, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.AESGCM256, CipherMAC.AEAD, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "DHE-RSA-AES256-GCM-SHA384", 256, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.RSA, CipherEncryption.AESGCM256, CipherMAC.AEAD, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "DHE-DSS-AES256-GCM-SHA384", 256, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.DSS, CipherEncryption.AESGCM256, CipherMAC.AEAD, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "ECDHE-RSA-AES128-GCM-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.RSA, CipherEncryption.AESGCM128, CipherMAC.AEAD, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_RSA_WITH_AES_128_GCM_SHA256", "AES128-GCM-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.AESGCM128, CipherMAC.AEAD, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "DHE-RSA-AES128-GCM-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.RSA, CipherEncryption.AESGCM128, CipherMAC.AEAD, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "DHE-DSS-AES128-GCM-SHA256", 128, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.DSS, CipherEncryption.AESGCM128, CipherMAC.AEAD, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "ECDHE-ECDSA-DES-CBC3-SHA", 168, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.ECDSA, CipherEncryption.TripleDES, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "ECDHE-RSA-DES-CBC3-SHA", 168, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.RSA, CipherEncryption.TripleDES, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_RSA_WITH_3DES_EDE_CBC_SHA", "DES-CBC3-SHA", 168, CipherStrength.HIGH, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.TripleDES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "ECDH-ECDSA-DES-CBC3-SHA", 168, CipherStrength.HIGH, CipherKeyExchange.ECDH_ECDSA, CipherAuthentication.ECDH, CipherEncryption.TripleDES, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "ECDH-RSA-DES-CBC3-SHA", 168, CipherStrength.HIGH, CipherKeyExchange.ECDH_RSA, CipherAuthentication.ECDH, CipherEncryption.TripleDES, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "EDH-RSA-DES-CBC3-SHA", 168, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.RSA, CipherEncryption.TripleDES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "EDH-DSS-DES-CBC3-SHA", 168, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.DSS, CipherEncryption.TripleDES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_RSA_WITH_RC4_128_MD5", "RC4-MD5", 128, CipherStrength.MEDIUM, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.RC4, CipherMAC.MD5, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
    }

    private static void initJava8SunDefaultDisabledCipherSuites(Map<String, SslCipher> ciphers, Map<String, SslCipher> ciphersByNickname) {
        SslCipher cipher = new SslCipher("TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "AECDH-AES256-SHA", 256, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.NULL, CipherEncryption.AES256, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DH_anon_WITH_AES_256_CBC_SHA", "ADH-AES256-SHA", 256, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.NULL, CipherEncryption.AES256, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "AECDH-AES128-SHA", 128, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.NULL, CipherEncryption.AES128, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_DH_anon_WITH_AES_128_CBC_SHA", "ADH-AES128-SHA", 128, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.NULL, CipherEncryption.AES128, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_anon_WITH_RC4_128_SHA", "AECDH-RC4-SHA", 128, CipherStrength.MEDIUM, CipherKeyExchange.ECDHE, CipherAuthentication.NULL, CipherEncryption.RC4, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_DH_anon_WITH_RC4_128_MD5", "ADH-RC4-MD5", 128, CipherStrength.MEDIUM, CipherKeyExchange.DHE, CipherAuthentication.NULL, CipherEncryption.RC4, CipherMAC.MD5, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", "AECDH-DES-CBC3-SHA", 168, CipherStrength.HIGH, CipherKeyExchange.ECDHE, CipherAuthentication.NULL, CipherEncryption.TripleDES, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "ADH-DES-CBC3-SHA", 168, CipherStrength.HIGH, CipherKeyExchange.DHE, CipherAuthentication.NULL, CipherEncryption.TripleDES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_RSA_WITH_NULL_SHA256", "NULL-SHA256", 0, CipherStrength.NONE, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.NULL, CipherMAC.SHA256, CipherProtocolVersion.TLSV1_2, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_ECDSA_WITH_NULL_SHA", "ECDHE-ECDSA-NULL-SHA", 0, CipherStrength.NONE, CipherKeyExchange.ECDHE, CipherAuthentication.ECDH, CipherEncryption.NULL, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDHE_RSA_WITH_NULL_SHA", "ECDHE-RSA-NULL-SHA", 0, CipherStrength.NONE, CipherKeyExchange.ECDHE, CipherAuthentication.ECDH, CipherEncryption.NULL, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_RSA_WITH_NULL_SHA", "NULL-SHA", 0, CipherStrength.NONE, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.NULL, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_ECDSA_WITH_NULL_SHA", "ECDH-ECDSA-NULL-SHA", 0, CipherStrength.NONE, CipherKeyExchange.ECDH_ECDSA, CipherAuthentication.ECDH, CipherEncryption.NULL, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_RSA_WITH_NULL_SHA", "ECDH-RSA-NULL-SHA", 0, CipherStrength.NONE, CipherKeyExchange.ECDH_RSA, CipherAuthentication.ECDH, CipherEncryption.NULL, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_ECDH_anon_WITH_NULL_SHA", "AECDH-NULL-SHA", 0, CipherStrength.NONE, CipherKeyExchange.ECDHE, CipherAuthentication.NULL, CipherEncryption.NULL, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_RSA_WITH_NULL_MD5", "NULL-MD5", 0, CipherStrength.NONE, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.NULL, CipherMAC.MD5, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_RSA_WITH_DES_CBC_SHA", "DES-CBC-SHA", 56, CipherStrength.LOW, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.DES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_DHE_RSA_WITH_DES_CBC_SHA", "EDH-RSA-DES-CBC-SHA", 56, CipherStrength.LOW, CipherKeyExchange.DHE, CipherAuthentication.RSA, CipherEncryption.DES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_DHE_DSS_WITH_DES_CBC_SHA", "EDH-DSS-DES-CBC-SHA", 56, CipherStrength.LOW, CipherKeyExchange.DHE, CipherAuthentication.DSS, CipherEncryption.DES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_DH_anon_WITH_DES_CBC_SHA", "ADH-DES-CBC-SHA", 56, CipherStrength.LOW, CipherKeyExchange.DHE, CipherAuthentication.NULL, CipherEncryption.DES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_RSA_EXPORT_WITH_RC4_40_MD5", "EXP-RC4-MD5", 40, CipherStrength.EXPORT40, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.RC4, CipherMAC.MD5, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "EXP-ADH-RC4-MD5", 40, CipherStrength.EXPORT40, CipherKeyExchange.DHE, CipherAuthentication.NULL, CipherEncryption.RC4, CipherMAC.MD5, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "EXP-DES-CBC-SHA", 40, CipherStrength.EXPORT40, CipherKeyExchange.RSA, CipherAuthentication.RSA, CipherEncryption.DES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "EXP-EDH-RSA-DES-CBC-SHA", 40, CipherStrength.EXPORT40, CipherKeyExchange.DHE, CipherAuthentication.RSA, CipherEncryption.DES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "EXP-EDH-DSS-DES-CBC-SHA", 40, CipherStrength.EXPORT40, CipherKeyExchange.DHE, CipherAuthentication.DSS, CipherEncryption.DES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "EXP-ADH-DES-CBC-SHA", 40, CipherStrength.EXPORT40, CipherKeyExchange.DHE, CipherAuthentication.NULL, CipherEncryption.DES, CipherMAC.SHA1, CipherProtocolVersion.SSLV3, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_KRB5_WITH_RC4_128_SHA", "KRB5-RC4-SHA", 128, CipherStrength.MEDIUM, CipherKeyExchange.KRB5, CipherAuthentication.KRB5, CipherEncryption.RC4, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_KRB5_WITH_RC4_128_MD5", "KRB5-RC4-MD5", 128, CipherStrength.MEDIUM, CipherKeyExchange.KRB5, CipherAuthentication.KRB5, CipherEncryption.RC4, CipherMAC.MD5, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_KRB5_WITH_3DES_EDE_CBC_SHA", "KRB5-DES-CBC3-SHA", 168, CipherStrength.HIGH, CipherKeyExchange.KRB5, CipherAuthentication.KRB5, CipherEncryption.TripleDES, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_KRB5_WITH_3DES_EDE_CBC_MD5", "KRB5-DES-CBC3-MD5", 168, CipherStrength.HIGH, CipherKeyExchange.KRB5, CipherAuthentication.KRB5, CipherEncryption.TripleDES, CipherMAC.MD5, CipherProtocolVersion.TLSV1, true);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_KRB5_WITH_DES_CBC_SHA", "KRB5-DES-CBC-SHA", 56, CipherStrength.LOW, CipherKeyExchange.KRB5, CipherAuthentication.KRB5, CipherEncryption.DES, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_KRB5_WITH_DES_CBC_MD5", "KRB5-DES-CBC-MD5", 56, CipherStrength.LOW, CipherKeyExchange.KRB5, CipherAuthentication.KRB5, CipherEncryption.DES, CipherMAC.MD5, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "EXP-KRB5-RC4-SHA", 40, CipherStrength.EXPORT40, CipherKeyExchange.KRB5, CipherAuthentication.KRB5, CipherEncryption.RC4, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_KRB5_EXPORT_WITH_RC4_40_MD5", "EXP-KRB5-RC4-MD5", 40, CipherStrength.EXPORT40, CipherKeyExchange.KRB5, CipherAuthentication.KRB5, CipherEncryption.RC4, CipherMAC.MD5, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", "EXP-KRB5-DES-CBC-SHA", 40, CipherStrength.EXPORT40, CipherKeyExchange.KRB5, CipherAuthentication.KRB5, CipherEncryption.DES, CipherMAC.SHA1, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
        cipher = new SslCipher("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", "EXP-KRB5-DES-CBC-MD5", 40, CipherStrength.EXPORT40, CipherKeyExchange.KRB5, CipherAuthentication.KRB5, CipherEncryption.DES, CipherMAC.MD5, CipherProtocolVersion.TLSV1, false);
        ciphers.putIfAbsent(cipher.name, cipher);
        ciphersByNickname.putIfAbsent(cipher.nickname, cipher);
    }

    private static List<SslCipher> getCiphers(String token) {
        SslCipher cipher = CIPHERS.get(token);
        if (cipher != null) {
            ArrayList<SslCipher> ciphers = new ArrayList<SslCipher>(1);
            ciphers.add(cipher);
            return ciphers;
        }
        cipher = CIPHER_NICKNAMES.get(token);
        if (cipher != null) {
            ArrayList<SslCipher> ciphers = new ArrayList<SslCipher>(1);
            ciphers.add(cipher);
            return ciphers;
        }
        List<SslCipher> ciphers = CIPHER_STRENGTHS.get(token);
        if (ciphers != null) {
            return ciphers;
        }
        ciphers = CIPHER_KEY_EXCHANGES.get(token);
        if (ciphers != null) {
            return ciphers;
        }
        ciphers = CIPHER_AUTHNS.get(token);
        if (ciphers != null) {
            return ciphers;
        }
        ciphers = CIPHER_ENCRYPTS.get(token);
        if (ciphers != null) {
            return ciphers;
        }
        ciphers = CIPHER_MACS.get(token);
        if (ciphers != null) {
            return ciphers;
        }
        ciphers = CIPHER_PROTOCOLS.get(token);
        if (ciphers != null) {
            return ciphers;
        }
        if (token.equals("FIPS")) {
            return CIPHER_FIPS;
        }
        cipher = new OtherSslCipher(token);
        ciphers = new ArrayList<SslCipher>(1);
        ciphers.add(cipher);
        return ciphers;
    }

    private static List<SslCipher> resolveCiphers(List<String> tokens) {
        LinkedList<SslCipher> resolvedCiphers = new LinkedList<SslCipher>();
        LinkedList killedCiphers = new LinkedList();
        block6: for (String token : tokens) {
            List<String> resolvedTokens;
            CipherOp op = CipherOp.ADD;
            Object ciphers = new LinkedList<SslCipher>();
            if (token.startsWith("!")) {
                if (resolvedCiphers.isEmpty()) {
                    throw new IllegalArgumentException("No matching ciphersuites found");
                }
                token = token.substring(1);
                op = CipherOp.KILL;
            } else if (token.startsWith("-")) {
                if (resolvedCiphers.isEmpty()) {
                    throw new IllegalArgumentException("No matching ciphersuites found");
                }
                token = token.substring(1);
                op = CipherOp.REMOVE;
            } else if (token.startsWith("+")) {
                if (resolvedCiphers.isEmpty()) {
                    throw new IllegalArgumentException("No matching ciphersuites found");
                }
                token = token.substring(1);
                op = CipherOp.RIGHT_SHIFT;
            } else if (token.startsWith("@")) {
                if (resolvedCiphers.isEmpty()) {
                    throw new IllegalArgumentException("No matching ciphersuites found");
                }
                if ((token = token.substring(1)).equals("STRENGTH")) {
                    Collections.sort(resolvedCiphers);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Unknown control cipher string '%s'", token));
            }
            String[] subtokens = token.split("\\+");
            if (subtokens.length > 1) {
                resolvedTokens = SslCipherSuites.resolveAlias(subtokens[0]);
                List<SslCipher> baseCiphers = SslCipherSuites.resolveCiphers(resolvedTokens);
                for (int i = 1; i < subtokens.length; ++i) {
                    resolvedTokens = SslCipherSuites.resolveAlias(subtokens[i]);
                    baseCiphers.retainAll(SslCipherSuites.resolveCiphers(resolvedTokens));
                }
                ciphers = baseCiphers;
            } else {
                resolvedTokens = SslCipherSuites.resolveAlias(token);
                for (String resolvedToken : resolvedTokens) {
                    ciphers.addAll(SslCipherSuites.getCiphers(resolvedToken));
                }
            }
            switch (op) {
                case ADD: {
                    resolvedTokens = ciphers.iterator();
                    while (resolvedTokens.hasNext()) {
                        SslCipher c = (SslCipher)resolvedTokens.next();
                        resolvedCiphers.add(c);
                    }
                    continue block6;
                }
                case KILL: {
                    killedCiphers.addAll(ciphers);
                    break;
                }
                case REMOVE: {
                    resolvedCiphers.removeAll((Collection<?>)ciphers);
                    break;
                }
                case RIGHT_SHIFT: {
                    LinkedList<SslCipher> removedCiphers = new LinkedList<SslCipher>();
                    ListIterator iter = resolvedCiphers.listIterator();
                    while (iter.hasNext()) {
                        SslCipher c = (SslCipher)iter.next();
                        if (!ciphers.contains(c)) continue;
                        removedCiphers.add(c);
                        iter.remove();
                    }
                    int idx = resolvedCiphers.size() - 1;
                    if (idx < 0) {
                        idx = 0;
                    }
                    resolvedCiphers.addAll(idx, removedCiphers);
                }
            }
        }
        resolvedCiphers.removeAll(killedCiphers);
        if (!resolvedCiphers.isEmpty()) {
            Collections.sort(resolvedCiphers);
        }
        return resolvedCiphers;
    }

    private static List<String> resolveAlias(List<String> aliases) {
        boolean firstElement = true;
        ListIterator<String> iter = aliases.listIterator();
        while (iter.hasNext()) {
            String token;
            switch (token = iter.next()) {
                case "DH": {
                    iter.remove();
                    iter.add(CipherKeyExchange.DH.tokenName);
                    break;
                }
                case "ADH": {
                    iter.remove();
                    iter.add(CipherKeyExchange.DHE.tokenName);
                    iter.add(CipherKeyExchange.ECDHE.tokenName);
                    iter.add(CipherAuthentication.NULL.tokenName);
                    break;
                }
                case "EDH": {
                    iter.remove();
                    iter.add(CipherKeyExchange.DHE.tokenName);
                    iter.add("!" + CipherKeyExchange.ECDHE.tokenName);
                    iter.add("!" + CipherAuthentication.NULL.tokenName);
                    break;
                }
                case "kECDH": {
                    iter.remove();
                    iter.add(CipherKeyExchange.ECDH_RSA.tokenName);
                    iter.add(CipherKeyExchange.ECDH_ECDSA.tokenName);
                    iter.add(CipherKeyExchange.ECDHE.tokenName);
                    break;
                }
                case "ECDH": {
                    iter.remove();
                    iter.add(CipherKeyExchange.ECDH_RSA.tokenName);
                    iter.add(CipherKeyExchange.ECDH_ECDSA.tokenName);
                    iter.add(CipherKeyExchange.ECDHE.tokenName);
                    break;
                }
                case "DSS": {
                    iter.remove();
                    iter.add(CipherAuthentication.DSS.tokenName);
                    break;
                }
                case "ECDSA": {
                    iter.remove();
                    iter.add(CipherAuthentication.ECDSA.tokenName);
                    break;
                }
                case "NULL": {
                    iter.remove();
                    iter.add(CipherEncryption.NULL.tokenName);
                    break;
                }
                case "KRB5": {
                    iter.remove();
                    iter.add(CipherKeyExchange.KRB5.tokenName);
                    iter.add(CipherAuthentication.KRB5.tokenName);
                    break;
                }
                case "RSA": {
                    iter.remove();
                    iter.add(CipherKeyExchange.RSA.tokenName);
                    iter.add(CipherAuthentication.RSA.tokenName);
                    break;
                }
                case "AES": {
                    iter.remove();
                    iter.add(CipherEncryption.AES128.tokenName);
                    iter.add(CipherEncryption.AES256.tokenName);
                    iter.add(CipherEncryption.AESGCM128.tokenName);
                    iter.add(CipherEncryption.AESGCM256.tokenName);
                    break;
                }
                case "AES128": {
                    iter.remove();
                    iter.add(CipherEncryption.AES128.tokenName);
                    iter.add(CipherEncryption.AESGCM128.tokenName);
                    break;
                }
                case "AES256": {
                    iter.remove();
                    iter.add(CipherEncryption.AES256.tokenName);
                    iter.add(CipherEncryption.AESGCM256.tokenName);
                    break;
                }
                case "AESGCM": {
                    iter.remove();
                    iter.add(CipherEncryption.AESGCM128.tokenName);
                    iter.add(CipherEncryption.AESGCM256.tokenName);
                    break;
                }
                case "EXP": 
                case "EXPORT": {
                    iter.remove();
                    iter.add("EXPORT40");
                    iter.add("EXPORT56");
                    break;
                }
                case "SHA": {
                    iter.remove();
                    iter.add(CipherMAC.SHA1.tokenName);
                    break;
                }
                case "AECDH": {
                    iter.remove();
                    iter.add(CipherKeyExchange.ECDHE.tokenName + "+" + CipherAuthentication.NULL.tokenName);
                    break;
                }
                case "EECDH": {
                    iter.remove();
                    iter.add(CipherKeyExchange.ECDH_ECDSA.tokenName);
                    break;
                }
                case "DEFAULT": 
                case "DEFAULTS": {
                    if (!firstElement) {
                        throw new IllegalArgumentException("DEFAULT must be the first cipher string specified");
                    }
                    iter.remove();
                    iter.add("HIGH");
                    iter.add("MEDIUM");
                    iter.add("!ADH");
                    iter.add("!KRB5");
                    break;
                }
                case "COMPLEMENTOFDEFAULT": {
                    iter.remove();
                    iter.add(CipherKeyExchange.DHE.tokenName);
                    iter.add("!" + CipherEncryption.NULL.tokenName);
                    break;
                }
                case "COMPLEMENTOFALL": {
                    iter.remove();
                    iter.add(CipherEncryption.NULL.tokenName);
                    break;
                }
                case "ALL": {
                    iter.remove();
                    iter.add("HIGH");
                    iter.add("MEDIUM");
                    iter.add("LOW");
                    iter.add("EXPORT56");
                    iter.add("EXPORT40");
                    iter.add("NONE");
                    iter.add("!eNULL");
                }
            }
            firstElement = false;
        }
        return aliases;
    }

    private static List<String> resolveAlias(String alias) {
        ArrayList<String> aliases = new ArrayList<String>(1);
        aliases.add(alias);
        return SslCipherSuites.resolveAlias(aliases);
    }

    public static List<String> resolve(List<String> tokens) {
        if (tokens == null || tokens.isEmpty()) {
            ArrayList<String> defaults = new ArrayList<String>(2);
            defaults.add("HIGH");
            defaults.add("MEDIUM");
            defaults.add("!ADH");
            defaults.add("!KRB5");
            return SslCipherSuites.resolve(defaults);
        }
        List<String> resolvedTokens = SslCipherSuites.resolveAlias(tokens);
        List<SslCipher> resolvedCiphers = SslCipherSuites.resolveCiphers(resolvedTokens);
        if (resolvedCiphers.isEmpty()) {
            throw new IllegalArgumentException("No ciphersuites matching configured <ssl.ciphers> found");
        }
        ArrayList<String> resolvedNames = new ArrayList<String>(resolvedCiphers.size());
        for (SslCipher c : resolvedCiphers) {
            resolvedNames.add(c.name);
        }
        return resolvedNames;
    }

    public static String[] resolveCSV(String csv) {
        List<String> resolved;
        if (csv != null && !csv.equals("")) {
            String[] elts = csv.split(",");
            ArrayList<String> tokens = new ArrayList<String>(elts.length);
            for (String elt : elts) {
                tokens.add(elt.trim());
            }
            resolved = SslCipherSuites.resolve(tokens);
        } else {
            resolved = SslCipherSuites.resolve(null);
        }
        return resolved.toArray(new String[resolved.size()]);
    }

    static {
        HashMap<String, SslCipher> ciphers = new HashMap<String, SslCipher>();
        HashMap<String, SslCipher> cipherNicknames = new HashMap<String, SslCipher>();
        SslCipherSuites.initJava8SunDefaultEnabledCipherSuites(ciphers, cipherNicknames);
        SslCipherSuites.initJava8SunDefaultDisabledCipherSuites(ciphers, cipherNicknames);
        CIPHERS = Collections.unmodifiableMap(ciphers);
        CIPHER_NICKNAMES = Collections.unmodifiableMap(cipherNicknames);
        Map<String, List<SslCipher>> cipherStrengths = CIPHERS.values().stream().collect(Collectors.groupingBy(s -> ((SslCipher)s).strength.tokenName));
        Stream.of(CipherStrength.values()).forEach(s -> cipherStrengths.putIfAbsent(((CipherStrength)s).tokenName, Collections.emptyList()));
        CIPHER_STRENGTHS = Collections.unmodifiableMap(cipherStrengths);
        Map<String, List<SslCipher>> cipherKeyExchanges = CIPHERS.values().stream().collect(Collectors.groupingBy(s -> ((SslCipher)s).keyExchange.tokenName));
        Stream.of(CipherKeyExchange.values()).forEach(s -> cipherKeyExchanges.putIfAbsent(((CipherKeyExchange)s).tokenName, Collections.emptyList()));
        CIPHER_KEY_EXCHANGES = Collections.unmodifiableMap(cipherKeyExchanges);
        Map<String, List<SslCipher>> cipherAuthns = CIPHERS.values().stream().collect(Collectors.groupingBy(s -> ((SslCipher)s).authentication.tokenName));
        Stream.of(CipherAuthentication.values()).forEach(s -> cipherAuthns.putIfAbsent(((CipherAuthentication)s).tokenName, Collections.emptyList()));
        CIPHER_AUTHNS = Collections.unmodifiableMap(cipherAuthns);
        Map<String, List<SslCipher>> cipherEncrypts = CIPHERS.values().stream().collect(Collectors.groupingBy(s -> ((SslCipher)s).encryption.tokenName));
        Stream.of(CipherEncryption.values()).forEach(s -> cipherEncrypts.putIfAbsent(((CipherEncryption)s).tokenName, Collections.emptyList()));
        CIPHER_ENCRYPTS = Collections.unmodifiableMap(cipherEncrypts);
        Map<String, List<SslCipher>> cipherMacs = CIPHERS.values().stream().collect(Collectors.groupingBy(s -> ((SslCipher)s).mac.tokenName));
        Stream.of(CipherMAC.values()).forEach(s -> cipherMacs.putIfAbsent(((CipherMAC)s).tokenName, Collections.emptyList()));
        CIPHER_MACS = Collections.unmodifiableMap(cipherMacs);
        Map<String, List<SslCipher>> cipherProtocols = CIPHERS.values().stream().collect(Collectors.groupingBy(s -> ((SslCipher)s).protocolVersion.tokenName));
        Stream.of(CipherProtocolVersion.values()).forEach(s -> cipherProtocols.putIfAbsent(((CipherProtocolVersion)s).tokenName, Collections.emptyList()));
        CIPHER_PROTOCOLS = Collections.unmodifiableMap(cipherProtocols);
        List fips = CIPHERS.values().stream().filter(s -> ((SslCipher)s).fips).collect(Collectors.toList());
        CIPHER_FIPS = Collections.unmodifiableList(fips);
    }

    private static enum CipherOp {
        ADD,
        KILL,
        RIGHT_SHIFT,
        REMOVE;

    }

    private static class OtherSslCipher
    extends SslCipher {
        OtherSslCipher(String name) {
            super(name, null, 0, null, null, null, null, null, null, false);
        }

        @Override
        public int compareTo(SslCipher o) {
            return 0;
        }
    }

    private static class SslCipher
    implements Comparable<SslCipher> {
        final String name;
        private final String nickname;
        private final Integer strengthBits;
        private final CipherStrength strength;
        private final CipherKeyExchange keyExchange;
        private final CipherAuthentication authentication;
        private final CipherEncryption encryption;
        private final CipherMAC mac;
        private final CipherProtocolVersion protocolVersion;
        private final boolean fips;

        SslCipher(String name, String nickname, int strengthBits, CipherStrength strength, CipherKeyExchange keyExchange, CipherAuthentication authentication, CipherEncryption encryption, CipherMAC mac, CipherProtocolVersion protocolVersion, boolean fips) {
            this.name = name;
            this.nickname = nickname;
            this.strengthBits = strengthBits;
            this.strength = strength;
            this.keyExchange = keyExchange;
            this.authentication = authentication;
            this.encryption = encryption;
            this.mac = mac;
            this.protocolVersion = protocolVersion;
            this.fips = fips;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof SslCipher) {
                SslCipher c = (SslCipher)o;
                return this.name.equals(c.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(SslCipher o) {
            return this.strengthBits.compareTo(o.strengthBits) * -1;
        }

        public String toString() {
            return String.format("%s:[%s/%s/%s/%s/%s/%s(%d)%s]", new Object[]{this.name, this.keyExchange, this.authentication, this.encryption, this.mac, this.protocolVersion, this.strength, this.strengthBits, this.fips ? "/FIPS" : ""});
        }
    }

    private static enum CipherProtocolVersion {
        SSLV3("SSLv3"),
        TLSV1("TLSv1"),
        TLSV1_1("TLSv1.1"),
        TLSV1_2("TLSv1.2");

        private final String tokenName;

        private CipherProtocolVersion(String tokenName) {
            this.tokenName = tokenName;
        }
    }

    private static enum CipherMAC {
        MD5("MD5"),
        SHA1("SHA1"),
        SHA256("SHA256"),
        SHA384("SHA384"),
        AEAD("AEAD");

        private final String tokenName;

        private CipherMAC(String tokenName) {
            this.tokenName = tokenName;
        }
    }

    private static enum CipherEncryption {
        RC4("RC4"),
        AES128("AES128"),
        AES256("AES256"),
        AESGCM128("AESGCM128"),
        AESGCM256("AESGCM256"),
        TripleDES("3DES"),
        DES("DES"),
        NULL("eNULL");

        private final String tokenName;

        private CipherEncryption(String tokenName) {
            this.tokenName = tokenName;
        }
    }

    private static enum CipherAuthentication {
        RSA("aRSA"),
        DSS("aDSS"),
        ECDH("aECDH"),
        ECDSA("aECDSA"),
        KRB5("aKRB5"),
        NULL("aNULL");

        private final String tokenName;

        private CipherAuthentication(String tokenName) {
            this.tokenName = tokenName;
        }
    }

    private static enum CipherKeyExchange {
        RSA("kRSA"),
        DH("kDH"),
        DHE("kEDH"),
        ECDH_ECDSA("kECDHe"),
        ECDH_RSA("kECDHr"),
        ECDHE("kEECDHe"),
        KRB5("kKRB5");

        private final String tokenName;

        private CipherKeyExchange(String tokenName) {
            this.tokenName = tokenName;
        }
    }

    private static enum CipherStrength {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW"),
        EXPORT40("EXPORT40"),
        EXPORT56("EXPORT56"),
        NONE("NONE");

        private final String tokenName;

        private CipherStrength(String tokenName) {
            this.tokenName = tokenName;
        }
    }
}

