/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util.scheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.kaazing.gateway.util.InternalSystemProperty;

public class SchedulerProvider {
    private final List<ManagedScheduledExecutorService> schedulers = new ArrayList<ManagedScheduledExecutorService>(10);
    private final ManagedScheduledExecutorService sharedScheduler;

    public SchedulerProvider() {
        this(new Properties());
    }

    public SchedulerProvider(Properties configuration) {
        int corePoolSize = InternalSystemProperty.BACKGROUND_TASK_THREADS.getIntProperty(configuration);
        this.sharedScheduler = new ManagedScheduledExecutorService(corePoolSize, "gtwy_bg_tasks", true);
    }

    public synchronized ScheduledExecutorService getScheduler(String purpose, boolean needDedicatedThread) {
        return needDedicatedThread ? new ManagedScheduledExecutorService(1, purpose, false) : this.sharedScheduler;
    }

    public synchronized void shutdownNow() {
        for (ManagedScheduledExecutorService scheduler : this.schedulers) {
            scheduler.shutdownImmediate();
        }
        this.schedulers.clear();
        this.sharedScheduler.shutdownImmediate();
    }

    private class ManagedScheduledExecutorService
    extends ScheduledThreadPoolExecutor {
        private final boolean shared;

        ManagedScheduledExecutorService(int corePoolSize, final String purpose, boolean shared) {
            super(corePoolSize, new ThreadFactory(){
                final AtomicInteger poolNumber = new AtomicInteger(1);
                final String namePrefix = purpose + "-";

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, this.namePrefix + this.poolNumber.getAndIncrement());
                }
            });
            this.shared = shared;
            SchedulerProvider.this.schedulers.add(this);
        }

        @Override
        public void shutdown() {
            if (!this.shared) {
                SchedulerProvider.this.schedulers.remove(this);
                super.shutdown();
            }
        }

        @Override
        public List<Runnable> shutdownNow() {
            if (!this.shared) {
                SchedulerProvider.this.schedulers.remove(this);
                return super.shutdownNow();
            }
            return null;
        }

        void shutdownImmediate() {
            super.shutdownNow();
        }
    }
}

