/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util.parse;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.CharBuffer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kaazing.gateway.util.http.DefaultUtilityHttpClient;
import org.kaazing.gateway.util.http.UtilityHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigParameter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigParameter.class);
    private static final Pattern PARAM_REGEX = Pattern.compile("([\\$]?)([\\$]+\\{)([^\\{\\}]*)(\\})");
    public static String cachedCloudHost;
    public static String cachedCloudInstanceId;

    public static String resolveAndReplace(char[] chars, int offset, int length, Map<String, String> parameterValuePairs, Properties configuration, List<String> errors) {
        int lastMatchCharIndex = 0;
        StringBuffer string = new StringBuffer();
        Matcher matcher = PARAM_REGEX.matcher(CharBuffer.wrap(chars, offset, length));
        while (matcher.find()) {
            String name = matcher.group(ParameterRegex.PARAM.index);
            String value = null;
            ParameterResolutionStrategy strategy = ParameterResolutionStrategy.PARAMETER_DEFINITION_DEFAULT;
            string.append(chars, offset + lastMatchCharIndex, matcher.start() - lastMatchCharIndex);
            lastMatchCharIndex = matcher.end(ParameterRegex.CLOSE.index);
            if (matcher.start(ParameterRegex.ESCAPE.index) != matcher.end(ParameterRegex.ESCAPE.index)) {
                value = new String(chars, offset + matcher.start(ParameterRegex.OPEN.index), matcher.end(ParameterRegex.CLOSE.index) - matcher.start(ParameterRegex.OPEN.index));
                strategy = ParameterResolutionStrategy.ESCAPED_PARAMETER_DEFINITION;
            } else if (!"".equals(name)) {
                value = configuration.getProperty(name);
                if (value != null && !"".equals(value)) {
                    strategy = ParameterResolutionStrategy.SYSTEM_PROPERTIES;
                } else {
                    value = parameterValuePairs.get(name);
                    if (value != null && !"".equals(value)) {
                        strategy = ParameterResolutionStrategy.PARAMETER_DEFINITION_DEFAULT;
                    }
                }
            }
            if (value == null && "cloud.host".equals(matcher.group(3))) {
                LOGGER.info("${cloud.host} found in config, attempting resolution by searching cloud provider");
                strategy = ParameterResolutionStrategy.CLOUD_RESOLUTION_STRATEGY;
                value = ConfigParameter.resolveCloudHost(new DefaultUtilityHttpClient());
                if (value == null) {
                    LOGGER.warn("${cloud.host} detected in config but could not determine cloud enviroment and find valid replacement for it");
                }
            }
            if (value == null && "hostname".equals(matcher.group(3))) {
                LOGGER.debug("${hostname} found in config, using box hostname");
                strategy = ParameterResolutionStrategy.HOSTNAME;
                value = ConfigParameter.resolveHostname();
                if (value == null) {
                    LOGGER.warn("${hostname} detected in config but could not determine cloud enviroment and find valid replacement for it");
                }
            }
            if (value == null && "cloud.instanceId".equals(matcher.group(3))) {
                LOGGER.info("${cloud.instanceId} found in config, attempting resolution by searching cloud provider");
                strategy = ParameterResolutionStrategy.CLOUD_RESOLUTION_STRATEGY;
                value = ConfigParameter.resolveCloudInstanceId(new DefaultUtilityHttpClient());
                if (value == null) {
                    LOGGER.warn("${cloud.instanceId} detected in config but could not determine cloud enviroment and find valid replacement for it");
                }
            }
            if (value == null || "".equals(value)) {
                value = matcher.group();
                strategy = ParameterResolutionStrategy.UNRESOLVED_PARAMETER_DEFINITION;
                errors.add("Could not determine non-null value for parameter definition " + matcher.group());
            }
            string.append(value);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Detected configuration parameter [" + matcher.group() + "], replaced with [" + value + "], as a result of resolution strategy [" + (Object)((Object)strategy) + "]");
        }
        string.append(chars, offset + lastMatchCharIndex, length - lastMatchCharIndex);
        return string.toString();
    }

    public static String resolveCloudHost(UtilityHttpClient httpClient) {
        if (cachedCloudHost == null) {
            String value = null;
            LOGGER.debug("Attempting to get AWS host information");
            try {
                String response = httpClient.performGetRequest("http://169.254.169.254/2014-02-25/meta-data/public-hostname");
                if (response != null && response.contains("amazonaws.com")) {
                    value = response;
                    LOGGER.debug(String.format("Found AWS hostname: %s", value));
                } else if (response != null && "".equals(response) && (response = httpClient.performGetRequest("http://169.254.169.254/2014-02-25/meta-data/public-ipv4")) != null) {
                    value = response;
                    LOGGER.debug(String.format("Couldn't find AWS hostname, but did find AWS public ip: %s", value));
                }
            }
            catch (Exception e) {
                LOGGER.debug(String.format("failed to get value due to exception with message: %s ", e.getMessage()));
            }
            cachedCloudHost = value;
        }
        return cachedCloudHost;
    }

    public static String resolveHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static String resolveCloudInstanceId(UtilityHttpClient httpClient) {
        if (cachedCloudInstanceId == null) {
            String value = null;
            LOGGER.debug("Attempting to get AWS instanceId information");
            try {
                String response = httpClient.performGetRequest("http://169.254.169.254/2014-02-25/meta-data/instance-id");
                if (response != null) {
                    value = response;
                    LOGGER.debug(String.format("Found AWS instanceId: %s", value));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            cachedCloudInstanceId = value;
        }
        return cachedCloudInstanceId;
    }

    private static enum ParameterResolutionStrategy {
        PARAMETER_DEFINITION_DEFAULT,
        PARAMETER_PROPERTIES_FILE,
        SYSTEM_PROPERTIES,
        ENVIRONMENT_VARIABLES,
        ESCAPED_PARAMETER_DEFINITION,
        UNRESOLVED_PARAMETER_DEFINITION,
        CLOUD_RESOLUTION_STRATEGY,
        HOSTNAME;

    }

    private static enum ParameterRegex {
        ESCAPE(1),
        OPEN(2),
        PARAM(3),
        CLOSE(4);

        public final int index;

        private ParameterRegex(int index) {
            this.index = index;
        }
    }
}

