/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util.feature;

import java.util.Properties;
import org.slf4j.Logger;

public class EarlyAccessFeature {
    private final boolean enabledByDefault;
    private final String name;
    private final String description;
    private final EarlyAccessFeature[] impliedBy;

    public EarlyAccessFeature(String name, String description, boolean enabledByDefault, EarlyAccessFeature ... impliedBy) {
        this.name = name;
        this.description = description;
        this.enabledByDefault = enabledByDefault;
        this.impliedBy = impliedBy;
    }

    public void assertEnabled(Properties configuration, Logger logger) {
        if (!this.isEnabled(configuration)) {
            String message = "Early access feature {} is disabled. To use it you must set system property \"feature.{}\", or include {} in environment variable GATEWAY_FEATURES (a comma separated list) if you are using the standard Gateway startup script";
            logger.error(message, new Object[]{this.toString(), this.name, this.name});
            throw new UnsupportedOperationException(String.format("Feature %s not enabled", this.toString()));
        }
    }

    public boolean isEnabled(Properties configuration) {
        Boolean explicit = this.getExplicitSetting(configuration);
        return explicit != null ? explicit : this.enabledByDefault || this.implied(configuration);
    }

    private Boolean getExplicitSetting(Properties configuration) {
        String value = configuration.getProperty(this.getPropertyName());
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public String getPropertyName() {
        return "feature." + this.name;
    }

    private boolean implied(Properties configuration) {
        for (EarlyAccessFeature feature : this.impliedBy) {
            if (!feature.isEnabled(configuration)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.name, this.description);
    }
}

