/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util.der;

import java.nio.ByteBuffer;
import org.kaazing.gateway.util.der.DerId;

public final class DerUtils {
    private DerUtils() {
    }

    public static int decodeLength(ByteBuffer buf) {
        if (buf == null || buf.remaining() == 0) {
            throw new IllegalArgumentException("Null or empty buffer");
        }
        int len = 0;
        byte first = buf.get();
        if (first >> 7 == 0) {
            len = first & 0x7F;
        } else {
            int numOctets = first & 0x7F;
            if (buf.remaining() < numOctets) {
                throw new IllegalArgumentException("Insufficient data to decode long-form DER length");
            }
            for (int i = 0; i < numOctets; ++i) {
                len = (len << 8) + (0xFF & buf.get());
            }
        }
        return len;
    }

    public static DerId decodeIdAndLength(ByteBuffer buf) {
        DerId id = DerId.decode(buf);
        DerUtils.decodeLength(buf);
        return id;
    }

    public static int encodeIdAndLength(DerId.TagClass tagClass, DerId.EncodingType encodingType, int tagNumber, int contentLength, ByteBuffer buf) {
        int origPos = buf.position();
        int pos = buf.position();
        if (contentLength < 0) {
            throw new IllegalArgumentException("Invalid content length " + contentLength);
        }
        if (contentLength <= 127) {
            buf.put(--pos, (byte)contentLength);
        } else {
            int lenOctetCount = 0;
            while (contentLength != 0) {
                buf.put(--pos, (byte)(contentLength & 0xFF));
                contentLength >>>= 8;
                ++lenOctetCount;
            }
            buf.put(--pos, (byte)(0x80 | lenOctetCount));
        }
        if (tagNumber < 0) {
            throw new IllegalArgumentException("Invalid tag number " + tagNumber);
        }
        byte firstOctet = 0;
        switch (tagClass) {
            case UNIVERSAL: {
                break;
            }
            case APPLICATION: {
                firstOctet = 64;
                break;
            }
            case CONTEXT_SPECIFIC: {
                firstOctet = -128;
                break;
            }
            case PRIVATE: {
                firstOctet = -64;
            }
        }
        switch (encodingType) {
            case PRIMITIVE: {
                break;
            }
            case CONSTRUCTED: {
                firstOctet = (byte)(firstOctet | 0x20);
            }
        }
        if (tagNumber <= 30) {
            firstOctet = (byte)(firstOctet | tagNumber);
            buf.put(--pos, firstOctet);
        } else {
            boolean last = true;
            while (tagNumber != 0) {
                byte octet = (byte)(tagNumber & 0x7F);
                --pos;
                if (last) {
                    buf.put(pos, octet);
                    last = false;
                } else {
                    buf.put(pos, (byte)(octet | 0x80));
                }
                tagNumber >>>= 8;
            }
            firstOctet = (byte)(firstOctet | 0x1F);
            buf.put(--pos, firstOctet);
        }
        buf.position(pos);
        return origPos - pos;
    }

    public static int sizeOf(int tagNumber, int contentLength) {
        if (tagNumber < 0 || contentLength < 0) {
            throw new IllegalArgumentException("Invalid tagNumber/contentLength: " + tagNumber + ", " + contentLength);
        }
        int len = 0;
        len = tagNumber <= 30 ? ++len : len + 1 + (int)Math.ceil((double)(1 + Integer.numberOfTrailingZeros(Integer.highestOneBit(tagNumber))) / 7.0);
        len = contentLength <= 127 ? ++len : len + 1 + (int)Math.ceil((double)(1 + Integer.numberOfTrailingZeros(Integer.highestOneBit(contentLength))) / 8.0);
        return len += contentLength;
    }
}

