/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util.der;

import java.nio.ByteBuffer;

public class DerId {
    private TagClass tagClass;
    private EncodingType encodingType;
    private int tagNumber;

    DerId() {
    }

    public TagClass getTagClass() {
        return this.tagClass;
    }

    public EncodingType getEncodingType() {
        return this.encodingType;
    }

    public int getTagNumber() {
        return this.tagNumber;
    }

    public String toString() {
        return "DerId [tagClass=" + (Object)((Object)this.getTagClass()) + ", encodingType=" + (Object)((Object)this.getEncodingType()) + ", tagNumber=" + this.getTagNumber() + "]";
    }

    public static DerId decode(ByteBuffer buf) {
        if (buf == null || buf.remaining() == 0) {
            throw new IllegalArgumentException("Null or empty buffer");
        }
        DerId id = new DerId();
        byte first = buf.get();
        id.tagClass = TagClass.values()[(first & 0xC0) >> 6];
        id.encodingType = EncodingType.values()[(first & 0x20) >> 5];
        int tagNum = first & 0x1F;
        if (tagNum == 31) {
            if (buf.remaining() == 0) {
                throw new IllegalArgumentException("Insufficient data to decode tag number greater than 30");
            }
            tagNum = 0;
            while (buf.hasRemaining()) {
                byte octet = buf.get();
                tagNum = (tagNum << 7) + (octet & 0x7F);
                if (octet >> 7 != 0) continue;
                break;
            }
        }
        id.tagNumber = tagNum;
        return id;
    }

    public boolean matches(TagClass tagClass, EncodingType encodingType, int tagNumber) {
        return this.tagClass == tagClass && this.encodingType == encodingType && this.tagNumber == tagNumber;
    }

    public boolean matches(TagClass tagClass, int tagNumber) {
        return this.tagClass == tagClass && this.tagNumber == tagNumber;
    }

    public static enum EncodingType {
        PRIMITIVE,
        CONSTRUCTED;

    }

    public static enum TagClass {
        UNIVERSAL,
        APPLICATION,
        CONTEXT_SPECIFIC,
        PRIVATE;

    }
}

