/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util.aws;

import java.nio.ByteBuffer;

public class Codec {
    private static final byte[] TO_HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final byte[] TO_BASE64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();
    private static final byte BASE64_PADDING_BYTE = 61;

    protected Codec() {
    }

    public static String encodeHexString(byte[] data) {
        byte[] out = Codec.encodeHex(data);
        return new String(out);
    }

    public static byte[] encodeHex(byte[] data) {
        int len = data.length;
        byte[] out = new byte[len << 1];
        for (int i = 0; i < len; ++i) {
            byte cur = data[i];
            int idx = i << 1;
            out[idx] = TO_HEX[cur >> 4 & 0xF];
            out[idx + 1] = TO_HEX[cur & 0xF];
        }
        return out;
    }

    public static String base64Decode(String data) {
        if (data == null) {
            return null;
        }
        return Codec.decodeBase64(data).asCharBuffer().toString();
    }

    public static String base64Encode(byte[] data) {
        if (data == null) {
            return null;
        }
        return Codec.encodeBase64String(ByteBuffer.wrap(data));
    }

    public static String encodeBase64String(ByteBuffer in) {
        int length = in.remaining();
        ByteBuffer buf = ByteBuffer.allocate((int)Math.ceil((double)length / 3.0) * 4);
        int remaining = in.remaining();
        block4: while (remaining > 0) {
            short byte1;
            short byte0;
            switch (remaining) {
                case 1: {
                    byte0 = in.get();
                    --remaining;
                    buf.put(TO_BASE64[byte0 >> 2 & 0x3F]);
                    buf.put(TO_BASE64[byte0 << 4 & 0x30]);
                    buf.put((byte)61);
                    buf.put((byte)61);
                    continue block4;
                }
                case 2: {
                    byte0 = in.get();
                    byte1 = in.get();
                    remaining -= 2;
                    buf.put(TO_BASE64[byte0 >> 2 & 0x3F]);
                    buf.put(TO_BASE64[byte0 << 4 & 0x30 | byte1 >> 4 & 0xF]);
                    buf.put(TO_BASE64[byte1 << 2 & 0x3C]);
                    buf.put((byte)61);
                    continue block4;
                }
            }
            byte0 = in.get();
            byte1 = in.get();
            short byte2 = in.get();
            remaining -= 3;
            buf.put(TO_BASE64[byte0 >> 2 & 0x3F]);
            buf.put(TO_BASE64[byte0 << 4 & 0x30 | byte1 >> 4 & 0xF]);
            buf.put(TO_BASE64[byte1 << 2 & 0x3C | byte2 >> 6 & 3]);
            buf.put(TO_BASE64[byte2 & 0x3F]);
        }
        buf.flip();
        buf = buf.slice();
        return new String(buf.array());
    }

    public static ByteBuffer decodeBase64(String input) {
        if (input == null) {
            return null;
        }
        ByteBuffer in = ByteBuffer.wrap(input.getBytes());
        int length = in.remaining();
        if (length % 4 != 0) {
            throw new IllegalArgumentException("base64");
        }
        ByteBuffer buf = ByteBuffer.allocate(length / 4 * 3);
        for (int remaining = in.remaining(); remaining > 0; remaining -= 4) {
            byte char0 = in.get();
            byte char1 = in.get();
            byte char2 = in.get();
            byte char3 = in.get();
            byte index0 = Codec.mapped(char0);
            byte index1 = Codec.mapped(char1);
            byte index2 = Codec.mapped(char2);
            byte index3 = Codec.mapped(char3);
            buf.put((byte)(index0 << 2 & 0xFC | index1 >> 4 & 3));
            if (char2 == 61) continue;
            buf.put((byte)(index1 << 4 & 0xF0 | index2 >> 2 & 0xF));
            if (char3 == 61) continue;
            buf.put((byte)(index2 << 6 & 0xC0 | index3 & 0x3F));
        }
        buf.flip();
        return buf.slice();
    }

    private static byte mapped(int index) {
        switch (index) {
            case 61: 
            case 65: {
                return 0;
            }
            case 66: {
                return 1;
            }
            case 67: {
                return 2;
            }
            case 68: {
                return 3;
            }
            case 69: {
                return 4;
            }
            case 70: {
                return 5;
            }
            case 71: {
                return 6;
            }
            case 72: {
                return 7;
            }
            case 73: {
                return 8;
            }
            case 74: {
                return 9;
            }
            case 75: {
                return 10;
            }
            case 76: {
                return 11;
            }
            case 77: {
                return 12;
            }
            case 78: {
                return 13;
            }
            case 79: {
                return 14;
            }
            case 80: {
                return 15;
            }
            case 81: {
                return 16;
            }
            case 82: {
                return 17;
            }
            case 83: {
                return 18;
            }
            case 84: {
                return 19;
            }
            case 85: {
                return 20;
            }
            case 86: {
                return 21;
            }
            case 87: {
                return 22;
            }
            case 88: {
                return 23;
            }
            case 89: {
                return 24;
            }
            case 90: {
                return 25;
            }
            case 97: {
                return 26;
            }
            case 98: {
                return 27;
            }
            case 99: {
                return 28;
            }
            case 100: {
                return 29;
            }
            case 101: {
                return 30;
            }
            case 102: {
                return 31;
            }
            case 103: {
                return 32;
            }
            case 104: {
                return 33;
            }
            case 105: {
                return 34;
            }
            case 106: {
                return 35;
            }
            case 107: {
                return 36;
            }
            case 108: {
                return 37;
            }
            case 109: {
                return 38;
            }
            case 110: {
                return 39;
            }
            case 111: {
                return 40;
            }
            case 112: {
                return 41;
            }
            case 113: {
                return 42;
            }
            case 114: {
                return 43;
            }
            case 115: {
                return 44;
            }
            case 116: {
                return 45;
            }
            case 117: {
                return 46;
            }
            case 118: {
                return 47;
            }
            case 119: {
                return 48;
            }
            case 120: {
                return 49;
            }
            case 121: {
                return 50;
            }
            case 122: {
                return 51;
            }
            case 48: {
                return 52;
            }
            case 49: {
                return 53;
            }
            case 50: {
                return 54;
            }
            case 51: {
                return 55;
            }
            case 52: {
                return 56;
            }
            case 53: {
                return 57;
            }
            case 54: {
                return 58;
            }
            case 55: {
                return 59;
            }
            case 56: {
                return 60;
            }
            case 57: {
                return 61;
            }
            case 43: {
                return 62;
            }
            case 47: {
                return 63;
            }
        }
        throw new IllegalArgumentException("Invalid base64 string");
    }
}

