/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util.aws;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.kaazing.gateway.util.aws.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class AwsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AwsUtils.class);
    private static final String UTF8_CHARSET = "UTF-8";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";

    private AwsUtils() {
    }

    public static String getAccountId() throws IOException {
        String macUrl = AwsUtils.getMetadataUrl() + "/network/interfaces/macs/";
        String mac = AwsUtils.invokeUrl(macUrl).trim();
        String idUrl = macUrl + mac + "owner-id";
        String acctId = AwsUtils.invokeUrl(idUrl).trim();
        assert (acctId != null);
        return acctId;
    }

    public static String getMetadataUrl() {
        return "http://169.254.169.254/latest/meta-data";
    }

    public static String getRegion() throws IOException {
        String url = AwsUtils.getMetadataUrl() + "/placement/availability-zone";
        String zone = AwsUtils.invokeUrl(url);
        zone = zone.trim();
        String region = zone.substring(0, zone.length() - 1);
        assert (region != null);
        return region;
    }

    public static String getSecurityGroupName() throws IOException {
        String url = AwsUtils.getMetadataUrl() + "/security-groups";
        String groups = AwsUtils.invokeUrl(url);
        if (groups == null || groups.trim().length() == 0) {
            String msg = "No security-group assigned to the instance";
            throw new IllegalStateException(msg);
        }
        StringTokenizer tokenizer = new StringTokenizer(groups, "\n");
        return tokenizer.nextToken();
    }

    public static String getLocalIPv4() throws IOException {
        String url = AwsUtils.getMetadataUrl() + "/local-ipv4";
        String localIPv4 = AwsUtils.invokeUrl(url);
        if (localIPv4 == null || localIPv4.trim().length() == 0) {
            String msg = "No local IPv4 assigned to the instance";
            throw new IllegalStateException(msg);
        }
        return localIPv4.trim();
    }

    public static String getUserdataUrl() {
        return "http://169.254.169.254/latest/user-data";
    }

    public static String getVersion1SignedRequest(String uri, Map<String, String> params, String awsAccessKeyId, String awsSecretKey) throws SignatureException {
        if (params == null || awsAccessKeyId == null || awsSecretKey == null || uri == null) {
            throw new IllegalArgumentException("Null parameter passed in");
        }
        params.put("AWSAccessKeyId", awsAccessKeyId);
        params.put("SignatureVersion", "1");
        params.put("Timestamp", AwsUtils.getTimestamp());
        String stringToSign = AwsUtils.getV1StringToSign(params);
        String signature = AwsUtils.createV1Signature(stringToSign, awsSecretKey, HMAC_SHA1_ALGORITHM);
        params.put("Signature", signature);
        StringBuffer queryString = new StringBuffer();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String encValue;
            String value = entry.getValue();
            try {
                encValue = URLEncoder.encode(value, UTF8_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                encValue = value;
            }
            String separator = queryString.length() == 0 ? "?" : "&";
            queryString.append(separator);
            queryString.append(entry.getKey() + "=" + encValue);
        }
        return uri + queryString.toString();
    }

    public static String getVersion2SignedRequest(String requestMethod, String protocol, String endpoint, String requestURI, Map<String, String> params, String awsAccessKeyId, String awsSecretKey) throws SignatureException {
        if (requestMethod == null || protocol == null || endpoint == null || requestURI == null || params == null || awsAccessKeyId == null || awsSecretKey == null) {
            throw new IllegalArgumentException("Null parameter passed in");
        }
        params.put("AWSAccessKeyId", awsAccessKeyId);
        params.put("SignatureMethod", HMAC_SHA256_ALGORITHM);
        params.put("SignatureVersion", "2");
        params.put("Timestamp", AwsUtils.getTimestamp());
        String canonicalQS = AwsUtils.getV2CanonicalizedQueryString(params);
        String stringToSign = requestMethod + "\n" + endpoint + "\n" + requestURI + "\n" + canonicalQS;
        String signature = AwsUtils.createSignature(stringToSign, awsSecretKey, HMAC_SHA256_ALGORITHM);
        String request = protocol + "://" + endpoint + requestURI + "?" + canonicalQS + "&Signature=" + signature;
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String invokeUrl(String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null parameter passed in");
        }
        InputStream inStream = null;
        String response = null;
        HttpURLConnection connection = null;
        try {
            URL urlObj = new URL(url);
            connection = (HttpURLConnection)urlObj.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            connection.connect();
            try {
                inStream = connection.getInputStream();
            }
            catch (IOException ex) {
                inStream = connection.getErrorStream();
                if (inStream == null) {
                    response = ex.getMessage();
                } else {
                    response = AwsUtils.getResponse(inStream);
                    inStream.close();
                    inStream = null;
                }
                throw new IOException(url + "\n" + response, ex);
            }
            response = AwsUtils.getResponse(inStream);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    public static boolean isDeployedToAWS() {
        try {
            AwsUtils.invokeUrl("http://169.254.169.254/latest/meta-data");
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static Document parseXMLResponse(String xmlStr) {
        if (xmlStr == null || xmlStr.length() == 0) {
            return null;
        }
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return db.parse(new ByteArrayInputStream(xmlStr.getBytes()));
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            return null;
        }
    }

    private static String createSignature(String stringToSign, String awsSecretKey, String algorithm) throws SignatureException {
        String signature;
        assert (stringToSign != null);
        assert (awsSecretKey != null);
        assert (algorithm != null);
        try {
            byte[] secretyKeyBytes = awsSecretKey.getBytes(UTF8_CHARSET);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretyKeyBytes, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(secretKeySpec);
            byte[] data = stringToSign.getBytes(UTF8_CHARSET);
            byte[] rawHmac = mac.doFinal(data);
            signature = AwsUtils.rfc3986Conformance(new String(Codec.base64Encode(rawHmac)));
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResponse(InputStream in) {
        if (in == null) {
            return null;
        }
        InputStreamReader inReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inReader);
        StringBuilder strBuilder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                strBuilder.append(line + "\n");
            }
        }
        catch (Exception ex) {
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        String response = strBuilder.length() > 0 ? strBuilder.toString() : null;
        return response;
    }

    private static String createV1Signature(String stringToSign, String awsSecretKey, String algorithm) throws SignatureException {
        String signature;
        if (stringToSign == null || awsSecretKey == null || algorithm == null) {
            return null;
        }
        try {
            byte[] secretyKeyBytes = awsSecretKey.getBytes();
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretyKeyBytes, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(secretKeySpec);
            byte[] data = stringToSign.getBytes();
            byte[] rawHmac = mac.doFinal(data);
            signature = Codec.base64Encode(rawHmac);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return signature;
    }

    private static String getTimestamp() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dfm.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dfm.format(cal.getTime());
    }

    private static String getV1StringToSign(Map<String, String> paramMap) {
        assert (paramMap != null);
        TreeSet<String> sortedKeys = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        sortedKeys.addAll(paramMap.keySet());
        sortedKeys.remove("Signature");
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : sortedKeys) {
            stringBuilder.append(key);
            stringBuilder.append(paramMap.get(key));
        }
        return stringBuilder.toString();
    }

    private static String getV2CanonicalizedQueryString(Map<String, String> params) {
        assert (params != null && !params.isEmpty());
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(params);
        sortedMap.remove("Signature");
        StringBuffer buffer = new StringBuffer();
        Iterator iter = sortedMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry kvpair = iter.next();
            buffer.append(AwsUtils.rfc3986Conformance((String)kvpair.getKey()));
            buffer.append("=");
            buffer.append(AwsUtils.rfc3986Conformance((String)kvpair.getValue()));
            if (!iter.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    private static String rfc3986Conformance(String s) {
        String out;
        assert (s != null);
        if (s == null) {
            return null;
        }
        try {
            out = URLEncoder.encode(s, UTF8_CHARSET).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            out = s;
        }
        return out;
    }
}

