/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.mina.filter.logging.LogLevel;
import org.slf4j.Logger;

public final class Utils {
    private static final int NO_OF_DAYS_IN_A_YEAR = 365;
    private static final int NO_OF_DAYS_IN_A_WEEK = 7;
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final byte[] LONG_MIN_VALUE_BYTES = "-9223372036854775808".getBytes(UTF_8);
    private static final int LONG_MIN_VALUE_BYTES_LENGTH = LONG_MIN_VALUE_BYTES.length;
    private static final byte[] INTEGER_MIN_VALUE_BYTES = "-2147483648".getBytes(UTF_8);
    private static final int INTEGER_MIN_VALUE_BYTES_LENGTH = INTEGER_MIN_VALUE_BYTES.length;
    private static final String TIME_UNIT_REGEX_STRING = "(?i:(ms|milli|millis|millisecond|milliseconds|s|sec|secs|second|seconds|m|min|mins|minute|minutes|h|hour|hours|d|day|days|w|week|weeks|y|year|years)?)";
    private static final String TIME_INTERVAL_REGEX_STRING = "([0-9\\.]+)\\s*(?i:(ms|milli|millis|millisecond|milliseconds|s|sec|secs|second|seconds|m|min|mins|minute|minutes|h|hour|hours|d|day|days|w|week|weeks|y|year|years)?)";
    private static final Pattern TIME_INTERVAL_PATTERN = Pattern.compile("([0-9\\.]+)\\s*(?i:(ms|milli|millis|millisecond|milliseconds|s|sec|secs|second|seconds|m|min|mins|minute|minutes|h|hour|hours|d|day|days|w|week|weeks|y|year|years)?)");
    public static final Set<String> SECONDS_UNITS = new HashSet<String>(Arrays.asList("s", "sec", "secs", "second", "seconds"));
    public static final Set<String> MILLISECONDS_UNITS = new HashSet<String>(Arrays.asList("ms", "milli", "millis", "millisecond", "milliseconds"));
    public static final Set<String> MINUTES_UNITS = new HashSet<String>(Arrays.asList("m", "min", "mins", "minute", "minutes"));
    public static final Set<String> HOURS_UNITS = new HashSet<String>(Arrays.asList("h", "hour", "hours"));
    static final Set<String> DAYS_UNITS = new HashSet<String>(Arrays.asList("d", "day", "days"));
    static final Set<String> WEEKS_UNITS = new HashSet<String>(Arrays.asList("w", "week", "weeks"));
    static final Set<String> YEARS_UNITS = new HashSet<String>(Arrays.asList("y", "year", "years"));
    private static final String[] PERMITTED_DATA_RATE_UNITS = new String[]{"MiB/s", "KiB/s", "MB/s", "kB/s", "B/s"};
    private static final long[] DATA_RATE_MULTIPLIERS = new long[]{0x100000L, 1024L, 1000000L, 1000L, 1L};
    private static final byte[] TO_HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final byte[] FROM_HEX = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    public static int ENCODED_BOOLEAN_CAPACITY = 4;
    public static int ENCODED_INT_CAPACITY = INTEGER_MIN_VALUE_BYTES_LENGTH;
    public static int ENCODED_LONG_CAPACITY = LONG_MIN_VALUE_BYTES_LENGTH;
    private static final String TIME_INTERVAL_INFORMATION = "Time intervals can be specified as numeric amounts of the following units: millisecond, second, minute, hour.\nFor example, \"1800 second\" or \"30 minutes\" or \"0.5 hour\".";
    private static final byte[] TRUE_BYTES = "true".getBytes(UTF_8);
    private static final byte[] FALSE_BYTES = "false".getBytes(UTF_8);
    static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final Random rand = new SecureRandom();

    private Utils() {
    }

    public static String join(String[] array, String separator) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        if (separator == null) {
            throw new NullPointerException("separator");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String fill(char c, int size) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append(c);
        }
        return builder.toString();
    }

    public static String toHex(byte[] data) {
        int len = data.length;
        byte[] out = new byte[len << 1];
        for (int i = 0; i < len; ++i) {
            byte cur = data[i];
            out[(i << 1) + 1] = TO_HEX[cur & 0xF];
            out[i << 1] = TO_HEX[cur >> 4 & 0xF];
        }
        return new String(out);
    }

    private static byte hexCharToByte(char c) {
        switch (c) {
            case '0': {
                return FROM_HEX[0];
            }
            case '1': {
                return FROM_HEX[1];
            }
            case '2': {
                return FROM_HEX[2];
            }
            case '3': {
                return FROM_HEX[3];
            }
            case '4': {
                return FROM_HEX[4];
            }
            case '5': {
                return FROM_HEX[5];
            }
            case '6': {
                return FROM_HEX[6];
            }
            case '7': {
                return FROM_HEX[7];
            }
            case '8': {
                return FROM_HEX[8];
            }
            case '9': {
                return FROM_HEX[9];
            }
            case 'A': {
                return FROM_HEX[10];
            }
            case 'B': {
                return FROM_HEX[11];
            }
            case 'C': {
                return FROM_HEX[12];
            }
            case 'D': {
                return FROM_HEX[13];
            }
            case 'E': {
                return FROM_HEX[14];
            }
            case 'F': {
                return FROM_HEX[15];
            }
        }
        return 0;
    }

    public static byte[] fromHex(String hex) {
        int len = hex.length();
        byte[] out = new byte[len >> 1];
        char[] chars = hex.toCharArray();
        for (int i = 0; i < out.length; ++i) {
            byte i1 = Utils.hexCharToByte(chars[i << 1]);
            byte i2 = Utils.hexCharToByte(chars[(i << 1) + 1]);
            out[i] = (byte)((i1 << 4) + i2);
        }
        return out;
    }

    public static void encodeBoolean(boolean b, ByteBuffer buf) {
        buf.put(b ? TRUE_BYTES : FALSE_BYTES);
    }

    public static void encodeInt(int i, ByteBuffer buf) {
        int r;
        int q;
        int size;
        if (i == Integer.MIN_VALUE) {
            buf.put(INTEGER_MIN_VALUE_BYTES);
        }
        int n = size = i < 0 ? Utils.stringSize(-i) + 1 : Utils.stringSize(i);
        if (buf.remaining() < size) {
            throw new BufferUnderflowException();
        }
        int position = buf.position();
        int offset = position + size;
        byte sign = 0;
        int positive = i;
        if (positive < 0) {
            sign = 45;
            positive = -positive;
        }
        while (positive >= 65536) {
            q = positive / 100;
            r = positive - ((q << 6) + (q << 5) + (q << 2));
            positive = q;
            buf.put(--offset, DigitOnes[r]);
            buf.put(--offset, DigitTens[r]);
        }
        do {
            q = positive * 52429 >>> 19;
            r = positive - ((q << 3) + (q << 1));
            buf.put(--offset, digits[r]);
        } while ((positive = q) != 0);
        if (sign != 0) {
            buf.put(--offset, sign);
        }
        buf.position(position + size);
    }

    public static void encodeLong(long i, ByteBuffer buf) {
        int q2;
        int r;
        int size;
        if (i == Long.MIN_VALUE) {
            buf.put(LONG_MIN_VALUE_BYTES);
        }
        int n = size = i < 0L ? Utils.stringSize(-i) + 1 : Utils.stringSize(i);
        if (buf.remaining() < size) {
            throw new BufferUnderflowException();
        }
        int position = buf.position();
        int offset = position + size;
        byte sign = 0;
        long positive = i;
        if (positive < 0L) {
            sign = 45;
            positive = -positive;
        }
        while (positive > Integer.MAX_VALUE) {
            long q = positive / 100L;
            r = (int)(positive - ((q << 6) + (q << 5) + (q << 2)));
            positive = q;
            buf.put(--offset, DigitOnes[r]);
            buf.put(--offset, DigitTens[r]);
        }
        int i2 = (int)positive;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf.put(--offset, DigitOnes[r]);
            buf.put(--offset, DigitTens[r]);
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf.put(--offset, digits[r]);
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf.put(--offset, sign);
        }
        buf.position(position + size);
    }

    public static String asString(Map<ByteBuffer, ByteBuffer> headers) {
        if (headers == null) {
            return null;
        }
        Iterator<Map.Entry<ByteBuffer, ByteBuffer>> i = headers.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<ByteBuffer, ByteBuffer> e = i.next();
            ByteBuffer key = e.getKey();
            ByteBuffer value = e.getValue();
            sb.append(key == headers ? "(this Map)" : Utils.asString(key));
            sb.append('=');
            sb.append(value == headers ? "(this Map)" : Utils.asString(value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    public static String asString(ByteBuffer buf) {
        if (buf == null) {
            return null;
        }
        if (buf.hasArray()) {
            return new String(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), UTF_8);
        }
        try {
            CharsetDecoder decoder = UTF_8.newDecoder();
            CharBuffer charBuf = decoder.decode(buf.duplicate());
            return charBuf.toString();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] asByteArray(ByteBuffer buf) {
        byte[] result;
        if (buf.hasArray() && buf.arrayOffset() == 0 && buf.capacity() == buf.remaining()) {
            result = buf.array();
        } else {
            result = new byte[buf.remaining()];
            if (buf.hasArray()) {
                System.arraycopy(buf.array(), buf.arrayOffset() + buf.position(), result, 0, result.length);
            } else {
                ByteBuffer duplicate = buf.duplicate();
                duplicate.mark();
                duplicate.get(result);
                duplicate.reset();
            }
        }
        return result;
    }

    @Deprecated
    public static String asStringUTF8(ByteBuffer buf) {
        return Utils.asString(buf);
    }

    public static ByteBuffer asByteBuffer(String s) {
        if (null == s) {
            return null;
        }
        if (s.length() < 1024) {
            return Utils.isASCII(s) ? US_ASCII.encode(s) : UTF_8.encode(s);
        }
        return UTF_8.encode(s);
    }

    public static boolean isASCII(String s) {
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static ByteBuffer asByteBuffer(byte[] bytes) {
        return bytes != null ? ByteBuffer.wrap(bytes) : null;
    }

    public static int getInt(ByteBuffer buf, int index) {
        return buf.order() == ByteOrder.BIG_ENDIAN ? Utils.getIntB(buf, index) : Utils.getIntL(buf, index);
    }

    public static long getLong(ByteBuffer buf, int index) {
        return buf.order() == ByteOrder.BIG_ENDIAN ? Utils.getLongB(buf, index) : Utils.getLongL(buf, index);
    }

    public static short getShort(ByteBuffer buf, int index) {
        return buf.order() == ByteOrder.BIG_ENDIAN ? Utils.getShortB(buf, index) : Utils.getShortL(buf, index);
    }

    public static String initCaps(String in) {
        return in.length() < 2 ? in.toUpperCase() : in.substring(0, 1).toUpperCase() + in.substring(1);
    }

    public static void putByteBuffer(ByteBuffer source, ByteBuffer target) {
        if (source.hasArray()) {
            byte[] array = source.array();
            int arrayOffset = source.arrayOffset();
            target.put(array, arrayOffset + source.position(), source.remaining());
        } else {
            target.put(source.duplicate());
        }
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.loadClass(className);
    }

    public static int loadStaticInt(String fullyQualifiedFieldName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        int lastDotPos = fullyQualifiedFieldName.lastIndexOf(46);
        if (lastDotPos <= 0 || lastDotPos + 1 >= fullyQualifiedFieldName.length()) {
            throw new IllegalArgumentException(fullyQualifiedFieldName);
        }
        String className = fullyQualifiedFieldName.substring(0, lastDotPos);
        String fieldName = fullyQualifiedFieldName.substring(lastDotPos + 1);
        Class<?> clazz = Utils.loadClass(className);
        Field field = clazz.getField(fieldName);
        int mode = field.getInt(clazz);
        return mode;
    }

    public static boolean parseBoolean(String valueName, String value, boolean defaultValue) {
        boolean result = defaultValue;
        if (value != null) {
            boolean valid = true;
            result = Boolean.parseBoolean(value);
            if (!result && !Boolean.FALSE.toString().equalsIgnoreCase(value)) {
                valid = false;
            }
            if (!valid) {
                String message = String.format("Invalid value \"%s\" for %s, must be \"%s\" or \"%s\"", value, valueName, Boolean.TRUE.toString(), Boolean.FALSE.toString());
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public static long parsePositiveInteger(String valueName, String value, long defaultValue) {
        long result = defaultValue;
        if (value != null) {
            boolean valid = true;
            try {
                result = Long.parseLong(value);
                if (result <= 0L) {
                    valid = false;
                }
            }
            catch (NumberFormatException e) {
                valid = false;
            }
            if (!valid) {
                String message = String.format("Invalid value \"%s\" for %s, must be a positive integer", value, valueName);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public static long parseTimeInterval(String timeIntervalValue, TimeUnit outputUnit) {
        return Utils.parseTimeInterval(timeIntervalValue, outputUnit, 0L);
    }

    public static long parseTimeInterval(String timeIntervalValue, TimeUnit outputUnit, long defaultValue) {
        return Utils.parseTimeInterval(timeIntervalValue, outputUnit, String.valueOf(defaultValue) + "seconds");
    }

    public static long parseTimeInterval(String timeIntervalValue, TimeUnit outputUnit, String defaultValue) {
        TimeUnit timeUnit = outputUnit = outputUnit == null ? TimeUnit.SECONDS : outputUnit;
        if (timeIntervalValue == null) {
            return Utils.parseTimeInterval(defaultValue, outputUnit, 0L);
        }
        if (outputUnit == null) {
            return Utils.parseTimeInterval(String.valueOf(timeIntervalValue), TimeUnit.SECONDS, 0L);
        }
        int length = timeIntervalValue.length();
        if (length < 1) {
            throw new NumberFormatException("Illegal timeInterval value, empty string not allowed.\nTime intervals can be specified as numeric amounts of the following units: millisecond, second, minute, hour.\nFor example, \"1800 second\" or \"30 minutes\" or \"0.5 hour\".");
        }
        Matcher matcher = TIME_INTERVAL_PATTERN.matcher(timeIntervalValue);
        if (matcher.matches()) {
            String unit = "seconds";
            double providedMultiplier = Double.parseDouble(matcher.group(1));
            if (providedMultiplier < 0.0) {
                throw new NumberFormatException("Illegal timeInterval value, negative intervals not allowed.\nTime intervals can be specified as numeric amounts of the following units: millisecond, second, minute, hour.\nFor example, \"1800 second\" or \"30 minutes\" or \"0.5 hour\".");
            }
            if (matcher.group(2) != null) {
                unit = matcher.group(2);
            }
            long result = 1L;
            try {
                if (SECONDS_UNITS.contains(unit.toLowerCase())) {
                    result = (long)(providedMultiplier * (double)outputUnit.convert(result, TimeUnit.SECONDS));
                } else if (MILLISECONDS_UNITS.contains(unit.toLowerCase())) {
                    result = (long)(providedMultiplier * (double)outputUnit.convert(result, TimeUnit.MILLISECONDS));
                } else if (MINUTES_UNITS.contains(unit.toLowerCase())) {
                    result = (long)(providedMultiplier * (double)outputUnit.convert(result, TimeUnit.MINUTES));
                } else if (HOURS_UNITS.contains(unit.toLowerCase())) {
                    result = (long)(providedMultiplier * (double)outputUnit.convert(result, TimeUnit.HOURS));
                } else if (DAYS_UNITS.contains(unit.toLowerCase())) {
                    result = (long)(providedMultiplier * (double)outputUnit.convert(result, TimeUnit.DAYS));
                } else if (WEEKS_UNITS.contains(unit.toLowerCase())) {
                    result = (long)(providedMultiplier * (double)outputUnit.convert(7L * result, TimeUnit.DAYS));
                } else if (YEARS_UNITS.contains(unit.toLowerCase())) {
                    result = (long)(providedMultiplier * (double)outputUnit.convert(365L * result, TimeUnit.DAYS));
                }
                if (result < 0L) {
                    throw new NumberFormatException("Expected a non-negative time interval, received \"" + timeIntervalValue + "\"");
                }
                return result;
            }
            catch (Exception e) {
                throw (NumberFormatException)new NumberFormatException("Illegal timeIntervalValue value \"" + timeIntervalValue + "\".\n" + TIME_INTERVAL_INFORMATION).initCause(e);
            }
        }
        throw new NumberFormatException("Illegal timeIntervalValue value \"" + timeIntervalValue + "\".\n" + TIME_INTERVAL_INFORMATION);
    }

    public static int parseDataSize(String dataSizeValue) {
        return Utils.parseDataSize(dataSizeValue, "dataSize");
    }

    public static long parseDataRate(String dataRateValue) {
        long result;
        int length = dataRateValue.length();
        if (length < 1) {
            throw new NumberFormatException("Illegal dataRate value, empty string not allowed");
        }
        char last = dataRateValue.charAt(length - 1);
        long multiplier = 1L;
        String numberPart = dataRateValue;
        if (!Character.isDigit(last)) {
            for (int i = 0; i < PERMITTED_DATA_RATE_UNITS.length; ++i) {
                if (!dataRateValue.endsWith(PERMITTED_DATA_RATE_UNITS[i])) continue;
                multiplier = DATA_RATE_MULTIPLIERS[i];
                int unitLength = PERMITTED_DATA_RATE_UNITS[i].length();
                if (length < unitLength + 1) {
                    throw new NumberFormatException("Invalid dataRate value \"" + dataRateValue + "\", number part missing");
                }
                numberPart = dataRateValue.substring(0, length - unitLength);
                break;
            }
        }
        if ((result = Long.parseLong(numberPart) * multiplier) <= 0L) {
            throw new NumberFormatException("Illegal dataRate value \"" + dataRateValue + "\", must be a positive number or overflow occurred");
        }
        return result;
    }

    private static int parseDataSize(String dataSizeValue, String specifier) {
        int length = dataSizeValue.length();
        if (length < 1) {
            throw new NumberFormatException("Illegal " + specifier + " value, empty string not allowed");
        }
        char last = dataSizeValue.charAt(length - 1);
        int multiplier = 1;
        String numberPart = dataSizeValue;
        switch (last) {
            case 'K': 
            case 'k': {
                multiplier = 1024;
                break;
            }
            case 'M': 
            case 'm': {
                multiplier = 0x100000;
            }
        }
        if (multiplier > 1) {
            if (length < 2) {
                throw new NumberFormatException("Illegal " + specifier + " value \"" + dataSizeValue + "\", number part missing");
            }
            numberPart = dataSizeValue.substring(0, length - 1);
        }
        int result = Integer.parseInt(numberPart) * multiplier;
        return result;
    }

    public static boolean sameOrEquals(Object this_, Object that) {
        return this_ == that || this_ != null && this_.equals(that);
    }

    public static <K, V> boolean sameOrEquals(Map<K, V> this_, Map<K, V> that) {
        return this_ == that || this_ == null && that.isEmpty() || that == null && this_.isEmpty() || this_ != null && this_.equals(that);
    }

    public static <T> boolean sameOrEquals(Collection<T> this_, Collection<T> that) {
        return this_ == that || this_ == null && that.isEmpty() || that == null && this_.isEmpty() || this_ != null && this_.equals(that);
    }

    static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static String randomHexString(int len) {
        byte[] out = Utils.randomHexBytes(len);
        return new String(out);
    }

    public static byte[] randomHexBytes(int len) {
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            int randomInt = Math.abs(rand.nextInt());
            out[i] = TO_HEX[randomInt % TO_HEX.length];
        }
        return out;
    }

    public static int randomInt() {
        return rand.nextInt();
    }

    public static void log(Logger logger, LogLevel eventLevel, String message) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message);
                return;
            }
            case DEBUG: {
                logger.debug(message);
                return;
            }
            case INFO: {
                logger.info(message);
                return;
            }
            case WARN: {
                logger.warn(message);
                return;
            }
            case ERROR: {
                logger.error(message);
                return;
            }
        }
    }

    public static void log(Logger logger, LogLevel eventLevel, String message, Throwable cause) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, cause);
                return;
            }
            case DEBUG: {
                logger.debug(message, cause);
                return;
            }
            case INFO: {
                logger.info(message, cause);
                return;
            }
            case WARN: {
                logger.warn(message, cause);
                return;
            }
            case ERROR: {
                logger.error(message, cause);
                return;
            }
        }
    }

    public static void log(Logger logger, LogLevel eventLevel, String message, Object param) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, param);
                return;
            }
            case DEBUG: {
                logger.debug(message, param);
                return;
            }
            case INFO: {
                logger.info(message, param);
                return;
            }
            case WARN: {
                logger.warn(message, param);
                return;
            }
            case ERROR: {
                logger.error(message, param);
                return;
            }
        }
    }

    public static void log(Logger logger, LogLevel eventLevel, String message, Object param1, Object param2) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, param1, param2);
                return;
            }
            case DEBUG: {
                logger.debug(message, param1, param2);
                return;
            }
            case INFO: {
                logger.info(message, param1, param2);
                return;
            }
            case WARN: {
                logger.warn(message, param1, param2);
                return;
            }
            case ERROR: {
                logger.error(message, param1, param2);
                return;
            }
        }
    }

    public static void log(Logger logger, LogLevel eventLevel, String message, Object param1, Object param2, Object param3) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, new Object[]{param1, param2, param3});
                return;
            }
            case DEBUG: {
                logger.debug(message, new Object[]{param1, param2, param3});
                return;
            }
            case INFO: {
                logger.info(message, new Object[]{param1, param2, param3});
                return;
            }
            case WARN: {
                logger.warn(message, new Object[]{param1, param2, param3});
                return;
            }
            case ERROR: {
                logger.error(message, new Object[]{param1, param2, param3});
                return;
            }
        }
    }

    public static <T> void inject(Object target, Class<T> injectableType, T injectableInstance) {
        Utils.inject0(target, injectableType, injectableInstance);
    }

    private static void inject0(Object target, Class<?> injectableType, Object injectableInstance) {
        Method[] methods;
        Class<?> targetClass = target.getClass();
        for (Method method : methods = targetClass.getMethods()) {
            Resource annotation;
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!methodName.startsWith("set") || methodName.length() <= "set".length() || parameterTypes.length != 1 || (annotation = method.getAnnotation(Resource.class)) == null) continue;
            Class<?> resourceType = annotation.type();
            if (resourceType == Object.class) {
                resourceType = parameterTypes[0];
            }
            if (resourceType != injectableType) continue;
            try {
                method.invoke(target, injectableInstance);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static void injectAll(Object target, Map<Class<?>, Object> injectables) {
        for (Map.Entry<Class<?>, Object> entry : injectables.entrySet()) {
            Class<?> injectableType = entry.getKey();
            Object injectableInstance = entry.getValue();
            Utils.inject0(target, injectableType, injectableInstance);
        }
    }

    public static String join(Object[] data, String separator) {
        int len = data.length;
        if (len == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(data[0].toString());
        for (int i = 1; i < data.length; ++i) {
            buf.append(separator);
            buf.append(data[i].toString());
        }
        return buf.toString();
    }

    public static String asCommaSeparatedString(Collection<String> strings) {
        return Utils.asSeparatedString(strings, ",");
    }

    public static String asSeparatedString(Collection<String> strings, String separator) {
        StringBuilder b = new StringBuilder();
        if (strings != null) {
            for (String protocol : strings) {
                b.append(protocol).append(separator);
            }
            if (strings.size() > 0) {
                b.deleteCharAt(b.length() - 1);
            }
        }
        return b.toString();
    }

    public static Map<String, Object> rewriteKeys(Map<String, Object> options, String prefix, String newPrefix) {
        String separator = ".";
        String startWith = prefix + ".";
        int startWithLength = startWith.length();
        if (options == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(options);
        for (Map.Entry<String, Object> e : options.entrySet()) {
            if (!e.getKey().startsWith(startWith)) continue;
            String newKey = newPrefix + ".";
            String suffix = e.getKey().substring(startWithLength);
            result.put(newKey + suffix, result.remove(e.getKey()));
        }
        return result;
    }

    public static String getHostStringWithoutNameLookup(InetSocketAddress inetSocketAddress) {
        String newHost = inetSocketAddress.isUnresolved() ? inetSocketAddress.getHostName() : inetSocketAddress.getAddress().getHostAddress();
        return newHost;
    }

    public static String stackTrace(Throwable cause) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        PrintStream printStream = new PrintStream(bufferedOutputStream);
        cause.printStackTrace(printStream);
        printStream.flush();
        return byteArrayOutputStream.toString();
    }

    private static short makeShort(byte b1, byte b0) {
        return (short)(b1 << 8 | b0 & 0xFF);
    }

    static short getShortL(ByteBuffer bb, int bi) {
        return Utils.makeShort(bb.get(bi + 1), bb.get(bi));
    }

    static short getShortB(ByteBuffer bb, int bi) {
        return Utils.makeShort(bb.get(bi), bb.get(bi + 1));
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    private static int getIntB(ByteBuffer bb, int index) {
        return Utils.makeInt(bb.get(index), bb.get(index + 1), bb.get(index + 2), bb.get(index + 3));
    }

    private static int getIntL(ByteBuffer bb, int index) {
        return Utils.makeInt(bb.get(index + 3), bb.get(index + 2), bb.get(index + 1), bb.get(index));
    }

    private static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return (long)b7 << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
    }

    private static long getLongL(ByteBuffer bb, int index) {
        return Utils.makeLong(bb.get(index + 7), bb.get(index + 6), bb.get(index + 5), bb.get(index + 4), bb.get(index + 3), bb.get(index + 2), bb.get(index + 1), bb.get(index));
    }

    private static long getLongB(ByteBuffer bb, int index) {
        return Utils.makeLong(bb.get(index), bb.get(index + 1), bb.get(index + 2), bb.get(index + 3), bb.get(index + 4), bb.get(index + 5), bb.get(index + 6), bb.get(index + 7));
    }

    public static String[] removeStringArrayElement(String[] option, String remove) {
        if (option == null) {
            return option;
        }
        int index = -1;
        for (int i = 0; i < option.length; ++i) {
            String element = option[i];
            if (remove == null) {
                if (element != null) continue;
                index = i;
                break;
            }
            if (!remove.equals(element)) continue;
            index = i;
        }
        if (index != -1) {
            String[] result = new String[option.length - 1];
            System.arraycopy(option, 0, result, 0, index);
            System.arraycopy(option, index + 1, result, index, option.length - (index + 1));
            return result;
        }
        return option;
    }
}

