/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.kaazing.gateway.util.ErrorHandler;

public final class Utf8Util {
    public static final int INVALID_UTF8 = -1;
    private static final String MSG_INVALID_CODEPOINT = "Invalid UTF-16 codepoint %c";

    private Utf8Util() {
    }

    public static int byteCountUTF8(char[] cbuf, int offset, int length) throws IOException {
        int count = 0;
        while (offset < length) {
            int codePoint = Character.codePointAt(cbuf, offset);
            count += Utf8Util.byteCountUTF8(codePoint);
            offset += Character.charCount(codePoint);
        }
        return count;
    }

    public static int byteCountUTF8(int codePoint) throws IOException {
        if ((codePoint | 0x7F) == 127) {
            return 1;
        }
        if ((codePoint | 0x7FF) == 2047) {
            return 2;
        }
        if ((codePoint | 0xFFFF) == 65535) {
            return 3;
        }
        if ((codePoint | 0x1FFFFF) == 0x1FFFFF) {
            return 4;
        }
        throw new IOException("Invalid UTF-8 code point. UTF-8 code point cannot span for more than 4 bytes.");
    }

    public static int initialDecodeUTF8(int remainingWidth, int encodedByte) throws IOException {
        switch (remainingWidth) {
            case 0: {
                return encodedByte & 0x7F;
            }
            case 1: {
                return encodedByte & 0x1F;
            }
            case 2: {
                return encodedByte & 0xF;
            }
            case 3: {
                return encodedByte & 7;
            }
        }
        throw new IOException("Invalid UTF-8 byte sequence. UTF-8 char cannot span for more than 4 bytes.");
    }

    public static int remainingDecodeUTF8(int decodedBytes, int remainingWidth, int encodedByte) throws IOException {
        switch (remainingWidth) {
            case 1: 
            case 2: 
            case 3: {
                return decodedBytes << 6 | encodedByte & 0x3F;
            }
            case 0: {
                return decodedBytes;
            }
        }
        throw new IOException("Invalid UTF-8 byte sequence. UTF-8 char cannot span for more than 4 bytes.");
    }

    public static int remainingBytesUTF8(int leadingByte) {
        if ((leadingByte & 0x80) == 0) {
            return 0;
        }
        for (int i = 0; i < 7; i = (int)((byte)(i + 1))) {
            int bitMask = 1 << 7 - i;
            if ((leadingByte & bitMask) != 0) continue;
            switch (i) {
                case 0: 
                case 7: {
                    throw new IllegalStateException(String.format("Invalid UTF-8 sequence leader byte: 0x%02x", leadingByte));
                }
            }
            return i - 1;
        }
        throw new IllegalStateException(String.format("Invalid UTF-8 sequence leader byte: 0x%02x", leadingByte));
    }

    public static boolean validBytesUTF8(byte[] input) {
        int index = 0;
        block3: while (index < input.length) {
            byte leadingByte;
            if (((leadingByte = input[index++]) & 0xC0) == 128) {
                return false;
            }
            int remaining = Utf8Util.remainingBytesUTF8(leadingByte);
            switch (remaining) {
                case 0: {
                    continue block3;
                }
            }
            while (remaining-- > 0) {
                if ((input[index++] & 0xC0) == 128) continue;
                return false;
            }
        }
        return true;
    }

    public static int validateUTF8(ByteBuffer buffer, int offset, int length, ErrorHandler errorHandler) {
        for (int index = 0; index < length; ++index) {
            int codePoint;
            int expectedLen;
            byte leadingByte = buffer.get(offset + index);
            if ((leadingByte & 0x80) == 0) continue;
            if ((leadingByte & 0xFF) > 244) {
                errorHandler.handleError(String.format("Invalid leading byte: %x", leadingByte));
                return -1;
            }
            if ((leadingByte & 0xE0) == 192) {
                expectedLen = 2;
                codePoint = leadingByte & 0x1F;
                if (codePoint < 2) {
                    errorHandler.handleError(String.format("Overlong encoding: %x%x", leadingByte, buffer.get(offset + index + 1)));
                    return -1;
                }
            } else if ((leadingByte & 0xF0) == 224) {
                expectedLen = 3;
                codePoint = leadingByte & 0xF;
            } else if ((leadingByte & 0xF8) == 240) {
                expectedLen = 4;
                codePoint = leadingByte & 7;
            } else {
                errorHandler.handleError(String.format("Value exceeds Unicode limit: %x", leadingByte));
                return -1;
            }
            int characterStartIndex = index;
            int remainingLen = expectedLen;
            while (--remainingLen > 0) {
                if (++index >= length) {
                    return length - characterStartIndex;
                }
                byte nextByte = buffer.get(offset + index);
                if ((nextByte & 0xC0) != 128) {
                    errorHandler.handleError(String.format("Invalid continuation byte: %x", nextByte));
                    return -1;
                }
                if ((codePoint = codePoint << 6 | nextByte & 0x3F) <= 0x10FFFF) continue;
                return -1;
            }
            try {
                if (expectedLen <= Utf8Util.byteCountUTF8(codePoint)) continue;
                errorHandler.handleError(String.format("Overlong encoding starting at byte %x postion %d", leadingByte, characterStartIndex));
                return -1;
            }
            catch (IOException e) {
                errorHandler.handleError(e.getMessage());
                return -1;
            }
        }
        return 0;
    }

    public static boolean validBytesUTF8(ByteBuffer buf, int offset, int limit) {
        int index = offset;
        block3: while (index < limit) {
            byte leadingByte;
            if (((leadingByte = buf.get(index++)) & 0xC0) == 128) {
                return false;
            }
            int remaining = Utf8Util.remainingBytesUTF8(leadingByte);
            switch (remaining) {
                case 0: {
                    continue block3;
                }
            }
            while (remaining-- > 0) {
                if ((buf.get(index++) & 0xC0) == 128) continue;
                return false;
            }
        }
        return true;
    }

    public static int charstoUTF8Bytes(char[] srcBuf, int srcOffset, int srcLength, ByteBuffer dest, int destOffset) {
        int destMark = destOffset;
        for (int i = srcOffset; i < srcLength; ++i) {
            char ch = srcBuf[i];
            if (ch < '\u0080') {
                dest.put(destOffset++, (byte)ch);
                continue;
            }
            if (ch < '\u0800') {
                dest.put(destOffset++, (byte)(0xC0 | ch >> 6));
                dest.put(destOffset++, (byte)(0x80 | ch >> 0 & 0x3F));
                continue;
            }
            if (ch >= '\u0800' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\uffff') {
                dest.put(destOffset++, (byte)(0xE0 | ch >> 12));
                dest.put(destOffset++, (byte)(0x80 | ch >> 6 & 0x3F));
                dest.put(destOffset++, (byte)(0x80 | ch >> 0 & 0x3F));
                continue;
            }
            if (ch >= '\ud800' && ch <= '\udfff') {
                if (i == srcBuf.length) {
                    throw new IllegalStateException(String.format(MSG_INVALID_CODEPOINT, Character.valueOf(ch)));
                }
                char ch1 = ch;
                char ch2 = srcBuf[++i];
                if (ch1 > '\udbff') {
                    throw new IllegalStateException(String.format(MSG_INVALID_CODEPOINT, Character.valueOf(ch1)));
                }
                int codePoint = Character.toCodePoint(ch1, ch2);
                dest.put(destOffset++, (byte)(0xF0 | codePoint >> 18));
                dest.put(destOffset++, (byte)(0x80 | codePoint >> 12 & 0x3F));
                dest.put(destOffset++, (byte)(0x80 | codePoint >> 6 & 0x3F));
                dest.put(destOffset++, (byte)(0x80 | codePoint >> 0 & 0x3F));
                continue;
            }
            throw new IllegalStateException(String.format(MSG_INVALID_CODEPOINT, Character.valueOf(ch)));
        }
        return destOffset - destMark;
    }
}

