/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util;

import java.util.Properties;

public enum InternalSystemProperty {
    DEBUG_NIOWORKER_POOL("NioWorkerPool.DEBUG"),
    WS_ENABLED_TRANSPORTS("org.kaazing.gateway.server.transport.ws.ENABLED_TRANSPORTS"),
    WS_CLOSE_TIMEOUT("org.kaazing.gateway.transport.ws.CLOSE_TIMEOUT", "5sec"),
    WSE_IDLE_TIMEOUT("org.kaazing.gateway.server.transport.wse.IDLE_TIMEOUT", "60"),
    WSE_SPECIFICATION("com.kaazing.gateway.server.transport.wse.SPECIFICATION", "false"),
    HTTPXE_SPECIFICATION("com.kaazing.gateway.server.transport.httpxe.SPECIFICATION", "false"),
    TCP_PROCESSOR_COUNT("org.kaazing.gateway.server.transport.tcp.PROCESSOR_COUNT", Integer.toString(Runtime.getRuntime().availableProcessors())),
    BACKGROUND_TASK_THREADS("org.kaazing.gateway.server.util.scheduler.BACKGROUND_TASK_THREADS", Integer.toString(Runtime.getRuntime().availableProcessors())),
    TCP_READ_BUFFER_SIZE("org.kaazing.gateway.server.transport.tcp.READ_BUFFER_SIZE"),
    TCP_MINIMUM_READ_BUFFER_SIZE("org.kaazing.gateway.server.transport.tcp.MINIMUM_READ_BUFFER_SIZE"),
    TCP_MAXIMUM_READ_BUFFER_SIZE("org.kaazing.gateway.server.transport.tcp.MAXIMUM_READ_BUFFER_SIZE"),
    TCP_WRITE_TIMEOUT("org.kaazing.gateway.server.transport.tcp.WRITE_TIMEOUT"),
    TCP_REUSE_ADDRESS("org.kaazing.gateway.server.transport.tcp.REUSE_ADDRESS", "true"),
    TCP_NO_DELAY("org.kaazing.gateway.server.transport.tcp.TCP_NO_DELAY"),
    TCP_BACKLOG("org.kaazing.gateway.server.transport.tcp.BACKLOG"),
    TCP_KEEP_ALIVE("org.kaazing.gateway.server.transport.tcp.KEEP_ALIVE"),
    TCP_RECEIVE_BUFFER_SIZE("org.kaazing.gateway.server.transport.tcp.RECEIVE_BUFFER_SIZE"),
    TCP_SEND_BUFFER_SIZE("org.kaazing.gateway.server.transport.tcp.SEND_BUFFER_SIZE"),
    TCP_SO_LINGER("org.kaazing.gateway.server.transport.tcp.SO_LINGER"),
    TCP_IP_TOS("org.kaazing.gateway.server.transport.tcp.IP_TOS"),
    BROADCAST_SERVICE_MAXIMUM_PENDING_BYTES("org.kaazing.gateway.server.service.broadcast.MAXIMUM_PENDING_BYTES"),
    BROADCAST_SERVICE_DISCONNECT_CLIENTS_ON_RECONNECT("org.kaazing.gateway.server.service.broadcast.DISCONNECT_CLIENTS_ON_RECONNECT"),
    MANAGEMENT_SESSION_THRESHOLD("org.kaazing.gateway.management.SESSION_THRESHOLD", "500"),
    MANAGEMENT_MESSAGE_COUNT_DISABLED("com.kaazing.gateway.management.MESSAGE_COUNT_DISABLED"),
    MANAGEMENT_SUMMARY_DATA_LIMIT("com.kaazing.gateway.management.SUMMARY_DATA_LIMIT", "100"),
    AGRONA_ENABLED("org.kaazing.gateway.management.AGRONA_ENABLED", "false"),
    GATEWAY_IDENTIFIER("org.kaazing.gateway.server.GATEWAY_IDENTIFIER", "");

    private final String name;
    private final String defaultValue;

    private InternalSystemProperty(String propertyName) {
        this(propertyName, null);
    }

    private InternalSystemProperty(String name, String defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public String getProperty(Properties configuration) {
        return configuration.getProperty(this.name, this.defaultValue);
    }

    public boolean getBooleanProperty(Properties configuration) {
        String value = this.getProperty(configuration);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public Integer getIntProperty(Properties configuration) {
        String value = this.getProperty(configuration);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public String getPropertyName() {
        return this.name;
    }

    public boolean isSet(Properties configuration) {
        return configuration.containsKey(this.name);
    }
}

