/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.util;

import java.nio.ByteBuffer;
import org.kaazing.gateway.util.DecodingState;

public abstract class Encoding
extends Enum<Encoding> {
    public static final /* enum */ Encoding TEXT = new Encoding(){

        @Override
        public ByteBuffer encode(ByteBuffer buf) {
            return buf;
        }

        @Override
        public ByteBuffer decode(ByteBuffer buf, DecodingState state) {
            return buf;
        }
    };
    public static final /* enum */ Encoding BINARY = new Encoding(){

        @Override
        public ByteBuffer encode(ByteBuffer buf) {
            return buf;
        }

        @Override
        public ByteBuffer decode(ByteBuffer buf, DecodingState state) {
            return buf;
        }
    };
    public static final /* enum */ Encoding BASE64 = new Encoding(){

        @Override
        public ByteBuffer encode(ByteBuffer decoded) {
            if (decoded.hasArray()) {
                return this.encodeWithHeap(decoded);
            }
            return this.encodeWithDirect(decoded);
        }

        private ByteBuffer encodeWithDirect(ByteBuffer decoded) {
            int byte1;
            int byte0;
            int decodedSize = decoded.remaining();
            int effectiveDecodedSize = (int)Math.ceil((float)decodedSize / 3.0f) * 3;
            int decodedFragmentSize = (3 - (effectiveDecodedSize - decodedSize)) % 3;
            int encodedArraySize = effectiveDecodedSize / 3 * 4;
            byte[] encodedArray = new byte[encodedArraySize];
            int encodedArrayPosition = 0;
            int decodedArrayPosition = decoded.position();
            int decodedArrayLimit = decoded.limit() - decodedFragmentSize;
            while (decodedArrayPosition < decodedArrayLimit) {
                byte0 = decoded.get(decodedArrayPosition++) & 0xFF;
                byte1 = decoded.get(decodedArrayPosition++) & 0xFF;
                int byte2 = decoded.get(decodedArrayPosition++) & 0xFF;
                encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
                encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30 | byte1 >> 4 & 0xF];
                encodedArray[encodedArrayPosition++] = INDEXED[byte1 << 2 & 0x3C | byte2 >> 6 & 3];
                encodedArray[encodedArrayPosition++] = INDEXED[byte2 & 0x3F];
            }
            switch (decodedFragmentSize) {
                case 0: {
                    break;
                }
                case 1: {
                    byte0 = decoded.get(decodedArrayPosition++) & 0xFF;
                    encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
                    encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30];
                    encodedArray[encodedArrayPosition++] = 61;
                    encodedArray[encodedArrayPosition++] = 61;
                    break;
                }
                case 2: {
                    byte0 = decoded.get(decodedArrayPosition++) & 0xFF;
                    byte1 = decoded.get(decodedArrayPosition++) & 0xFF;
                    encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
                    encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30 | byte1 >> 4 & 0xF];
                    encodedArray[encodedArrayPosition++] = INDEXED[byte1 << 2 & 0x3C];
                    encodedArray[encodedArrayPosition++] = 61;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid base64 encoding");
                }
            }
            return ByteBuffer.wrap(encodedArray);
        }

        private ByteBuffer encodeWithHeap(ByteBuffer decoded) {
            int byte1;
            int byte0;
            int decodedSize = decoded.remaining();
            int effectiveDecodedSize = (int)Math.ceil((float)decodedSize / 3.0f) * 3;
            int decodedFragmentSize = (3 - (effectiveDecodedSize - decodedSize)) % 3;
            int encodedArraySize = effectiveDecodedSize / 3 * 4;
            byte[] encodedArray = new byte[encodedArraySize];
            int encodedArrayPosition = 0;
            byte[] decodedArray = decoded.array();
            int decodedArrayOffset = decoded.arrayOffset();
            int decodedArrayPosition = decodedArrayOffset + decoded.position();
            int decodedArrayLimit = decodedArrayOffset + decoded.limit() - decodedFragmentSize;
            while (decodedArrayPosition < decodedArrayLimit) {
                byte0 = decodedArray[decodedArrayPosition++] & 0xFF;
                byte1 = decodedArray[decodedArrayPosition++] & 0xFF;
                int byte2 = decodedArray[decodedArrayPosition++] & 0xFF;
                encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
                encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30 | byte1 >> 4 & 0xF];
                encodedArray[encodedArrayPosition++] = INDEXED[byte1 << 2 & 0x3C | byte2 >> 6 & 3];
                encodedArray[encodedArrayPosition++] = INDEXED[byte2 & 0x3F];
            }
            switch (decodedFragmentSize) {
                case 0: {
                    break;
                }
                case 1: {
                    byte0 = decodedArray[decodedArrayPosition++] & 0xFF;
                    encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
                    encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30];
                    encodedArray[encodedArrayPosition++] = 61;
                    encodedArray[encodedArrayPosition++] = 61;
                    break;
                }
                case 2: {
                    byte0 = decodedArray[decodedArrayPosition++] & 0xFF;
                    byte1 = decodedArray[decodedArrayPosition++] & 0xFF;
                    encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
                    encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30 | byte1 >> 4 & 0xF];
                    encodedArray[encodedArrayPosition++] = INDEXED[byte1 << 2 & 0x3C];
                    encodedArray[encodedArrayPosition++] = 61;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid base64 encoding");
                }
            }
            return ByteBuffer.wrap(encodedArray);
        }

        @Override
        public ByteBuffer decode(ByteBuffer encoded, DecodingState state) {
            if (encoded.hasArray()) {
                return this.decodeWithHeap(encoded, state);
            }
            return this.decodeWithDirect(encoded, state);
        }

        private ByteBuffer decodeWithDirect(ByteBuffer encoded, DecodingState state) {
            int length = encoded.remaining();
            if (length % 4 != 0) {
                throw new IllegalArgumentException("base64");
            }
            byte[] decodedArray = new byte[length / 4 * 3];
            int decodedArrayOffset = 0;
            int encodedArrayLimit = encoded.limit();
            int i = encoded.position();
            while (i < encodedArrayLimit) {
                byte char0 = encoded.get(i++);
                byte char1 = encoded.get(i++);
                byte char2 = encoded.get(i++);
                byte char3 = encoded.get(i++);
                int byte0 = Encoding.mapped(char0);
                int byte1 = Encoding.mapped(char1);
                int byte2 = Encoding.mapped(char2);
                int byte3 = Encoding.mapped(char3);
                decodedArray[decodedArrayOffset++] = (byte)(byte0 << 2 & 0xFC | byte1 >> 4 & 3);
                if (char2 == 61) continue;
                decodedArray[decodedArrayOffset++] = (byte)(byte1 << 4 & 0xF0 | byte2 >> 2 & 0xF);
                if (char3 == 61) continue;
                decodedArray[decodedArrayOffset++] = (byte)(byte2 << 6 & 0xC0 | byte3 & 0x3F);
            }
            return ByteBuffer.wrap(decodedArray, 0, decodedArrayOffset);
        }

        private ByteBuffer decodeWithHeap(ByteBuffer encoded, DecodingState state) {
            int length = encoded.remaining();
            if (length % 4 != 0) {
                throw new IllegalArgumentException("base64");
            }
            byte[] decodedArray = new byte[length / 4 * 3];
            int decodedArrayOffset = 0;
            byte[] encodedArray = encoded.array();
            int encodedArrayOffset = encoded.arrayOffset();
            int encodedArrayLimit = encodedArrayOffset + encoded.limit();
            int i = encodedArrayOffset + encoded.position();
            while (i < encodedArrayLimit) {
                byte char0 = encodedArray[i++];
                byte char1 = encodedArray[i++];
                byte char2 = encodedArray[i++];
                byte char3 = encodedArray[i++];
                int byte0 = Encoding.mapped(char0);
                int byte1 = Encoding.mapped(char1);
                int byte2 = Encoding.mapped(char2);
                int byte3 = Encoding.mapped(char3);
                decodedArray[decodedArrayOffset++] = (byte)(byte0 << 2 & 0xFC | byte1 >> 4 & 3);
                if (char2 == 61) continue;
                decodedArray[decodedArrayOffset++] = (byte)(byte1 << 4 & 0xF0 | byte2 >> 2 & 0xF);
                if (char3 == 61) continue;
                decodedArray[decodedArrayOffset++] = (byte)(byte2 << 6 & 0xC0 | byte3 & 0x3F);
            }
            return ByteBuffer.wrap(decodedArray, 0, decodedArrayOffset);
        }
    };
    public static final /* enum */ Encoding UTF8 = new Encoding(){

        @Override
        public ByteBuffer encode(ByteBuffer decoded) {
            return Encoding.encodeBinaryAsText(decoded, true, false);
        }

        @Override
        public ByteBuffer decode(ByteBuffer encoded, DecodingState state) {
            return Encoding.decodeTextAsBinary(encoded, state, true, false);
        }
    };
    public static final /* enum */ Encoding UTF8_ESCAPE_ZERO_AND_NEWLINE = new Encoding(){

        @Override
        public ByteBuffer encode(ByteBuffer decoded) {
            return Encoding.encodeBinaryAsText(decoded, true, true);
        }

        @Override
        public ByteBuffer decode(ByteBuffer encoded, DecodingState state) {
            return Encoding.decodeTextAsBinary(encoded, state, true, true);
        }
    };
    public static final /* enum */ Encoding ESCAPE_ZERO_AND_NEWLINE = new Encoding(){

        @Override
        public ByteBuffer encode(ByteBuffer decoded) {
            return Encoding.encodeBinaryAsText(decoded, false, true);
        }

        @Override
        public ByteBuffer decode(ByteBuffer encoded, DecodingState state) {
            return Encoding.decodeTextAsBinary(encoded, state, false, true);
        }
    };
    private static final byte[] INDEXED;
    private static final int PADDING_BYTE = 61;
    private static final /* synthetic */ Encoding[] $VALUES;

    public static Encoding[] values() {
        return (Encoding[])$VALUES.clone();
    }

    public static Encoding valueOf(String name) {
        return Enum.valueOf(Encoding.class, name);
    }

    public abstract ByteBuffer encode(ByteBuffer var1);

    public abstract ByteBuffer decode(ByteBuffer var1, DecodingState var2);

    public ByteBuffer decode(ByteBuffer buf) {
        return this.decode(buf, DecodingState.NONE);
    }

    private static int mapped(int ch) {
        if ((ch & 0x40) != 0) {
            if ((ch & 0x20) != 0) {
                assert (ch >= 97);
                assert (ch <= 122);
                return ch - 71;
            }
            assert (ch >= 65);
            assert (ch <= 90);
            return ch - 65;
        }
        if ((ch & 0x20) != 0) {
            if ((ch & 0x10) != 0) {
                if ((ch & 8) != 0 && (ch & 4) != 0) {
                    assert (ch == 61);
                    return 0;
                }
                assert (ch >= 48);
                assert (ch <= 57);
                return ch + 4;
            }
            if ((ch & 4) != 0) {
                assert (ch == 47);
                return 63;
            }
            assert (ch == 43);
            return 62;
        }
        throw new IllegalArgumentException("Invalid BASE64 string");
    }

    private static ByteBuffer encodeBinaryAsText(ByteBuffer decoded, boolean encodeAsUTF8, boolean escapeZeroAndNewline) {
        if (decoded.hasArray()) {
            return Encoding.encodeBinaryAsTextWithHeap(decoded, encodeAsUTF8, escapeZeroAndNewline);
        }
        return Encoding.encodeBinaryAsTextWithDirect(decoded, encodeAsUTF8, escapeZeroAndNewline);
    }

    /*
     * Unable to fully structure code
     */
    private static ByteBuffer encodeBinaryAsTextWithDirect(ByteBuffer decoded, boolean encodeAsUTF8, boolean escapeZeroAndNewline) {
        decodedInitialPosition = decodedPosition = decoded.position();
        decodedLimit = decoded.limit();
        encodedArray = null;
        encodedArrayInsertionCount = 0;
        while (decodedPosition < decodedLimit) {
            decodedValue = decoded.get(decodedPosition);
            if (!escapeZeroAndNewline) ** GOTO lbl-1000
            switch (decodedValue) {
                case 0: {
                    encodedArray = Encoding.supplyEncodedArray(decoded, decodedPosition, decodedLimit, encodedArray);
                    encodedArrayInsertionCount = Encoding.updateEncodedArray(decodedPosition, encodedArray, encodedArrayInsertionCount, (byte)127, (byte)48);
                    break;
                }
                case 10: {
                    encodedArray = Encoding.supplyEncodedArray(decoded, decodedPosition, decodedLimit, encodedArray);
                    encodedArrayInsertionCount = Encoding.updateEncodedArray(decodedPosition, encodedArray, encodedArrayInsertionCount, (byte)127, (byte)110);
                    break;
                }
                case 13: {
                    encodedArray = Encoding.supplyEncodedArray(decoded, decodedPosition, decodedLimit, encodedArray);
                    encodedArrayInsertionCount = Encoding.updateEncodedArray(decodedPosition, encodedArray, encodedArrayInsertionCount, (byte)127, (byte)114);
                    break;
                }
                case 127: {
                    encodedArray = Encoding.supplyEncodedArray(decoded, decodedPosition, decodedLimit, encodedArray);
                    encodedArrayInsertionCount = Encoding.updateEncodedArray(decodedPosition, encodedArray, encodedArrayInsertionCount, (byte)127, (byte)127);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (encodeAsUTF8 && (decodedValue & 128) != 0) {
                        encodedArray = Encoding.supplyEncodedArray(decoded, decodedPosition, decodedLimit, encodedArray);
                        encodedByte0 = (byte)((decodedValue & 255) >> 6 & 3 | 192);
                        encodedByte1 = (byte)(decodedValue & 191);
                        encodedArrayInsertionCount = Encoding.updateEncodedArray(decodedPosition, encodedArray, encodedArrayInsertionCount, encodedByte0, encodedByte1);
                        break;
                    }
                    if (encodedArray == null) break;
                    Encoding.updateEncodedArray(decodedPosition, encodedArray, encodedArrayInsertionCount, decodedValue);
                }
            }
            ++decodedPosition;
        }
        return encodedArray != null ? ByteBuffer.wrap(encodedArray, decodedInitialPosition, decoded.remaining() + encodedArrayInsertionCount) : decoded;
    }

    /*
     * Unable to fully structure code
     */
    private static ByteBuffer encodeBinaryAsTextWithHeap(ByteBuffer decoded, boolean encodeAsUTF8, boolean escapeZeroAndNewline) {
        decodedArray = decoded.array();
        decodedArrayOffset = decoded.arrayOffset();
        decodedArrayInitialPosition = decodedArrayPosition = decodedArrayOffset + decoded.position();
        decodedArrayLimit = decodedArrayOffset + decoded.limit();
        encodedArray = null;
        encodedArrayInsertionCount = 0;
        while (decodedArrayPosition < decodedArrayLimit) {
            decodedValue = decodedArray[decodedArrayPosition];
            if (!escapeZeroAndNewline) ** GOTO lbl-1000
            switch (decodedValue) {
                case 0: {
                    encodedArray = Encoding.supplyEncodedArray(decodedArray, decodedArrayOffset, decodedArrayPosition, decodedArrayLimit, encodedArray);
                    encodedArrayInsertionCount = Encoding.updateEncodedArray(decodedArrayPosition, encodedArray, encodedArrayInsertionCount, (byte)127, (byte)48);
                    break;
                }
                case 10: {
                    encodedArray = Encoding.supplyEncodedArray(decodedArray, decodedArrayOffset, decodedArrayPosition, decodedArrayLimit, encodedArray);
                    encodedArrayInsertionCount = Encoding.updateEncodedArray(decodedArrayPosition, encodedArray, encodedArrayInsertionCount, (byte)127, (byte)110);
                    break;
                }
                case 13: {
                    encodedArray = Encoding.supplyEncodedArray(decodedArray, decodedArrayOffset, decodedArrayPosition, decodedArrayLimit, encodedArray);
                    encodedArrayInsertionCount = Encoding.updateEncodedArray(decodedArrayPosition, encodedArray, encodedArrayInsertionCount, (byte)127, (byte)114);
                    break;
                }
                case 127: {
                    encodedArray = Encoding.supplyEncodedArray(decodedArray, decodedArrayOffset, decodedArrayPosition, decodedArrayLimit, encodedArray);
                    encodedArrayInsertionCount = Encoding.updateEncodedArray(decodedArrayPosition, encodedArray, encodedArrayInsertionCount, (byte)127, (byte)127);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (encodeAsUTF8 && (decodedValue & 128) != 0) {
                        encodedArray = Encoding.supplyEncodedArray(decodedArray, decodedArrayOffset, decodedArrayPosition, decodedArrayLimit, encodedArray);
                        encodedByte0 = (byte)((decodedValue & 255) >> 6 & 3 | 192);
                        encodedByte1 = (byte)(decodedValue & 191);
                        encodedArrayInsertionCount = Encoding.updateEncodedArray(decodedArrayPosition, encodedArray, encodedArrayInsertionCount, encodedByte0, encodedByte1);
                        break;
                    }
                    if (encodedArray == null) break;
                    Encoding.updateEncodedArray(decodedArrayPosition, encodedArray, encodedArrayInsertionCount, decodedValue);
                }
            }
            ++decodedArrayPosition;
        }
        return encodedArray != null ? ByteBuffer.wrap(encodedArray, decodedArrayInitialPosition, decoded.remaining() + encodedArrayInsertionCount) : decoded;
    }

    private static byte[] supplyEncodedArray(byte[] decodedArray, int decodedArrayOffset, int decodedArrayPosition, int decodedArrayLimit, byte[] encodedArray) {
        if (encodedArray == null) {
            int decodedPosition = decodedArrayPosition - decodedArrayOffset;
            int decodedRemaining = decodedArrayLimit - decodedArrayPosition;
            encodedArray = new byte[decodedPosition + decodedRemaining * 2];
            System.arraycopy(decodedArray, decodedArrayOffset, encodedArray, 0, decodedPosition);
        }
        return encodedArray;
    }

    private static byte[] supplyEncodedArray(ByteBuffer decoded, int decodedPosition, int decodedLimit, byte[] encodedArray) {
        if (encodedArray == null) {
            int decodedRemaining = decodedLimit - decodedPosition;
            encodedArray = new byte[decodedPosition + decodedRemaining * 2];
            int originalPosition = decoded.position();
            decoded.position(0);
            decoded.get(encodedArray, 0, decodedPosition);
            decoded.position(originalPosition);
        }
        return encodedArray;
    }

    private static int updateEncodedArray(int decodedArrayPosition, byte[] encodedArray, int encodedArrayInsertionCount, byte byte0, byte byte1) {
        Encoding.updateEncodedArray(decodedArrayPosition, encodedArray, encodedArrayInsertionCount, byte0);
        Encoding.updateEncodedArray(decodedArrayPosition, encodedArray, ++encodedArrayInsertionCount, byte1);
        return encodedArrayInsertionCount;
    }

    private static void updateEncodedArray(int decodedArrayPosition, byte[] encodedArray, int encodedArrayInsertionCount, byte encodedByte) {
        encodedArray[decodedArrayPosition + encodedArrayInsertionCount] = encodedByte;
    }

    private static ByteBuffer decodeTextAsBinary(ByteBuffer encoded, DecodingState state, boolean decodeAsUTF8, boolean unescapeZeroAndNewline) {
        if (encoded.hasArray()) {
            return Encoding.decodeTextAsBinaryWithHeap(encoded, state, decodeAsUTF8, unescapeZeroAndNewline);
        }
        return Encoding.decodeTextAsBinaryWithDirect(encoded, state, decodeAsUTF8, unescapeZeroAndNewline);
    }

    private static ByteBuffer decodeTextAsBinaryWithHeap(ByteBuffer encoded, DecodingState state, boolean decodeAsUTF8, boolean unescapeZeroAndNewline) {
        int encodedArrayOffset;
        byte[] encodedArray = encoded.array();
        int encodedArrayPosition = encodedArrayOffset = encoded.arrayOffset() + encoded.position();
        int encodedArrayLimit = encoded.arrayOffset() + encoded.limit();
        byte[] decodedArray = null;
        int encodedArrayInsertionCount = 0;
        Byte previousRemainingByte = (Byte)state.get();
        if (previousRemainingByte != null) {
            decodedArray = new byte[encoded.remaining()];
            --encodedArrayPosition;
            --encodedArrayOffset;
        }
        Byte remainingByte = null;
        while (encodedArrayPosition < encodedArrayLimit) {
            byte encodedByte2;
            byte encodedByte1;
            byte by = encodedByte1 = encodedArrayPosition == -1 ? previousRemainingByte : encodedArray[encodedArrayPosition];
            if (decodeAsUTF8 && (encodedByte1 & 0x80) != 0) {
                decodedArray = Encoding.supplyDecodedArray(encodedArray, encodedArrayOffset, encodedArrayPosition, encodedArrayLimit, decodedArray);
                if (++encodedArrayPosition >= encodedArrayLimit) {
                    remainingByte = encodedByte1;
                    ++encodedArrayInsertionCount;
                    break;
                }
                encodedByte2 = encodedArray[encodedArrayPosition];
                byte decodedByte = (byte)(encodedByte1 << 6 | encodedByte2 & 0x3F);
                encodedArrayInsertionCount = Encoding.updateDecodedArray(encodedArrayOffset, encodedArrayPosition, decodedArray, encodedArrayInsertionCount, decodedByte);
            } else if (unescapeZeroAndNewline && encodedByte1 == 127) {
                decodedArray = Encoding.supplyDecodedArray(encodedArray, encodedArrayOffset, encodedArrayPosition, encodedArrayLimit, decodedArray);
                if (++encodedArrayPosition >= encodedArrayLimit) {
                    remainingByte = encodedByte1;
                    ++encodedArrayInsertionCount;
                    break;
                }
                encodedByte2 = encodedArray[encodedArrayPosition];
                switch (encodedByte2) {
                    case 48: {
                        encodedArrayInsertionCount = Encoding.updateDecodedArray(encodedArrayOffset, encodedArrayPosition, decodedArray, encodedArrayInsertionCount, (byte)0);
                        break;
                    }
                    case 110: {
                        encodedArrayInsertionCount = Encoding.updateDecodedArray(encodedArrayOffset, encodedArrayPosition, decodedArray, encodedArrayInsertionCount, (byte)10);
                        break;
                    }
                    case 114: {
                        encodedArrayInsertionCount = Encoding.updateDecodedArray(encodedArrayOffset, encodedArrayPosition, decodedArray, encodedArrayInsertionCount, (byte)13);
                        break;
                    }
                    default: {
                        encodedArrayInsertionCount = Encoding.updateDecodedArray(encodedArrayOffset, encodedArrayPosition, decodedArray, encodedArrayInsertionCount, encodedByte2);
                        break;
                    }
                }
            } else if (decodedArray != null) {
                decodedArray[encodedArrayPosition - encodedArrayInsertionCount - encodedArrayOffset] = encodedByte1;
            }
            ++encodedArrayPosition;
        }
        state.set(remainingByte);
        int decodedLength = encoded.remaining() + (previousRemainingByte != null ? 1 : 0) - encodedArrayInsertionCount;
        return decodedArray != null ? ByteBuffer.wrap(decodedArray, 0, decodedLength) : encoded;
    }

    private static ByteBuffer decodeTextAsBinaryWithDirect(ByteBuffer encoded, DecodingState state, boolean decodeAsUTF8, boolean unescapeZeroAndNewline) {
        int encodedArrayOffset;
        int encodedArrayPosition = encodedArrayOffset = encoded.position();
        int encodedArrayLimit = encoded.limit();
        byte[] decodedArray = null;
        int encodedArrayInsertionCount = 0;
        Byte previousRemainingByte = (Byte)state.get();
        if (previousRemainingByte != null) {
            decodedArray = new byte[encoded.remaining()];
            --encodedArrayPosition;
            --encodedArrayOffset;
        }
        Byte remainingByte = null;
        while (encodedArrayPosition < encodedArrayLimit) {
            byte encodedByte2;
            byte encodedByte1;
            byte by = encodedByte1 = encodedArrayPosition == -1 ? previousRemainingByte.byteValue() : encoded.get(encodedArrayPosition);
            if (decodeAsUTF8 && (encodedByte1 & 0x80) != 0) {
                decodedArray = Encoding.supplyDecodedArray(encoded, encodedArrayOffset, encodedArrayPosition, encodedArrayLimit, decodedArray);
                if (++encodedArrayPosition >= encodedArrayLimit) {
                    remainingByte = encodedByte1;
                    ++encodedArrayInsertionCount;
                    break;
                }
                encodedByte2 = encoded.get(encodedArrayPosition);
                byte decodedByte = (byte)(encodedByte1 << 6 | encodedByte2 & 0x3F);
                encodedArrayInsertionCount = Encoding.updateDecodedArray(encodedArrayOffset, encodedArrayPosition, decodedArray, encodedArrayInsertionCount, decodedByte);
            } else if (unescapeZeroAndNewline && encodedByte1 == 127) {
                decodedArray = Encoding.supplyDecodedArray(encoded, encodedArrayOffset, encodedArrayPosition, encodedArrayLimit, decodedArray);
                if (++encodedArrayPosition >= encodedArrayLimit) {
                    remainingByte = encodedByte1;
                    ++encodedArrayInsertionCount;
                    break;
                }
                encodedByte2 = encoded.get(encodedArrayPosition);
                switch (encodedByte2) {
                    case 48: {
                        encodedArrayInsertionCount = Encoding.updateDecodedArray(encodedArrayOffset, encodedArrayPosition, decodedArray, encodedArrayInsertionCount, (byte)0);
                        break;
                    }
                    case 110: {
                        encodedArrayInsertionCount = Encoding.updateDecodedArray(encodedArrayOffset, encodedArrayPosition, decodedArray, encodedArrayInsertionCount, (byte)10);
                        break;
                    }
                    case 114: {
                        encodedArrayInsertionCount = Encoding.updateDecodedArray(encodedArrayOffset, encodedArrayPosition, decodedArray, encodedArrayInsertionCount, (byte)13);
                        break;
                    }
                    default: {
                        encodedArrayInsertionCount = Encoding.updateDecodedArray(encodedArrayOffset, encodedArrayPosition, decodedArray, encodedArrayInsertionCount, encodedByte2);
                        break;
                    }
                }
            } else if (decodedArray != null) {
                decodedArray[encodedArrayPosition - encodedArrayInsertionCount - encodedArrayOffset] = encodedByte1;
            }
            ++encodedArrayPosition;
        }
        state.set(remainingByte);
        int decodedLength = encoded.remaining() + (previousRemainingByte != null ? 1 : 0) - encodedArrayInsertionCount;
        return decodedArray != null ? ByteBuffer.wrap(decodedArray, 0, decodedLength) : encoded;
    }

    private static int updateDecodedArray(int encodedArrayOffset, int encodedArrayPosition, byte[] decodedArray, int encodedArrayInsertionCount, byte decodedByte) {
        decodedArray[encodedArrayPosition - ++encodedArrayInsertionCount - encodedArrayOffset] = decodedByte;
        return encodedArrayInsertionCount;
    }

    private static byte[] supplyDecodedArray(byte[] encodedArray, int encodedArrayOffset, int encodedArrayPosition, int encodedArrayLimit, byte[] decodedArray) {
        if (decodedArray == null) {
            int encodedPosition = encodedArrayPosition - encodedArrayOffset;
            int encodedRemaining = encodedArrayLimit - encodedArrayPosition;
            decodedArray = new byte[encodedPosition + encodedRemaining];
            System.arraycopy(encodedArray, encodedArrayOffset, decodedArray, 0, encodedPosition);
        }
        return decodedArray;
    }

    private static byte[] supplyDecodedArray(ByteBuffer encoded, int encodedArrayOffset, int encodedArrayPosition, int encodedArrayLimit, byte[] decodedArray) {
        if (decodedArray == null) {
            int encodedPosition = encodedArrayPosition - encodedArrayOffset;
            int encodedRemaining = encodedArrayLimit - encodedArrayPosition;
            decodedArray = new byte[encodedPosition + encodedRemaining];
            encoded.get(decodedArray, 0, encodedPosition);
            encoded.position(encoded.position() - encodedPosition);
        }
        return decodedArray;
    }

    static {
        $VALUES = new Encoding[]{TEXT, BINARY, BASE64, UTF8, UTF8_ESCAPE_ZERO_AND_NEWLINE, ESCAPE_ZERO_AND_NEWLINE};
        INDEXED = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();
    }
}

