/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.proxy;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.filter.util.WriteRequestFilterEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyHandler
extends IoHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProxyHandler.class);
    private static final AttributeKey ATTACHED_SESSION_KEY = new AttributeKey(AbstractProxyHandler.class, "attachedSession");
    private static final AttributeKey QUEUED_MESSAGES_KEY = new AttributeKey(AbstractProxyHandler.class, "queuedMessages");
    private ServiceContext serviceContext;
    private int maximumPendingBytes;
    private int maximumTransferredBytes = -1;
    private int thresholdPendingBytes;
    private int maximumRecoveryInterval = 0;
    private int preparedConnectionCount = 0;

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Closing session %s due to exception:", session), cause);
        } else {
            LOGGER.info(String.format("Closing session %s due to exception: %s", session, cause));
        }
        boolean connectionClosing = session.isClosing() || cause instanceof IOException;
        session.close(connectionClosing);
    }

    public void sessionCreated(IoSession session) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[" + session.getId() + "] session created (" + session + ")");
        }
        ConcurrentLinkedQueue messageQueue = new ConcurrentLinkedQueue();
        session.setAttribute((Object)QUEUED_MESSAGES_KEY, messageQueue);
    }

    public void sessionClosed(IoSession session) {
        IoSession detachedSession;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[" + session.getId() + "] session closed");
        }
        if ((detachedSession = AbstractProxyHandler.detachSessions(session)) != null) {
            detachedSession.close(false);
        }
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void messageReceived(IoSession session, Object message) {
        Queue<Object> messageQueue = this.getMessageQueue(session);
        AttachedSessionManager attachedSessionManager = AbstractProxyHandler.getAttachedSessionManager(session);
        if (attachedSessionManager != null) {
            if (messageQueue != null) {
                this.flushQueuedMessages(messageQueue, session, attachedSessionManager);
                session.removeAttribute((Object)QUEUED_MESSAGES_KEY);
            }
            attachedSessionManager.writeMessage(session, message);
        } else if (messageQueue != null && !session.isClosing()) {
            messageQueue.add(message);
        }
    }

    void setMaximumPendingBytes(int maximumPendingBytes) {
        this.maximumPendingBytes = maximumPendingBytes;
        this.thresholdPendingBytes = maximumPendingBytes / 2;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Proxy handler %s: maximum.pending.bytes=%d, using resume threshold %d", new Object[]{this, maximumPendingBytes, this.thresholdPendingBytes}));
        }
    }

    void setMaximumTransferredBytes(int maximumTransferredBytes) {
        this.maximumTransferredBytes = maximumTransferredBytes;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Proxy handler " + (Object)((Object)this) + ": maximum.transferred.bytes=" + maximumTransferredBytes + ".");
        }
    }

    public void setMaximumRecoveryInterval(int maximumRecoveryInterval) {
        this.maximumRecoveryInterval = maximumRecoveryInterval;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Proxy handler " + (Object)((Object)this) + ": maximum.recovery.interval=" + maximumRecoveryInterval + ".");
        }
    }

    public int getMaximumRecoveryInterval() {
        return this.maximumRecoveryInterval;
    }

    public void setPreparedConnectionCount(int preparedConnectionCount) {
        this.preparedConnectionCount = preparedConnectionCount;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Proxy handler " + (Object)((Object)this) + ": prepared.connection.count=" + preparedConnectionCount + ".");
        }
    }

    public int getPreparedConnectionCount() {
        return this.preparedConnectionCount;
    }

    protected void flushQueuedMessages(IoSession session, AttachedSessionManager attachedSessionManager) {
        Queue<Object> messageQueue = this.getMessageQueue(session);
        if (messageQueue != null) {
            this.flushQueuedMessages(messageQueue, session, attachedSessionManager);
        }
    }

    protected ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    private void flushQueuedMessages(Queue<Object> messageQueue, IoSession session, AttachedSessionManager attachedSessionManager) {
        while (messageQueue != null && !messageQueue.isEmpty()) {
            Object queuedMessage = messageQueue.poll();
            attachedSessionManager.writeMessage(session, queuedMessage);
        }
    }

    private Queue<Object> getMessageQueue(IoSession session) {
        return (Queue)session.getAttribute((Object)QUEUED_MESSAGES_KEY);
    }

    protected static AttachedSessionManager getAttachedSessionManager(IoSession session) {
        return (AttachedSessionManager)session.getAttribute((Object)ATTACHED_SESSION_KEY);
    }

    protected AttachedSessionManager attachSessions(IoSession session, IoSession attachedSession) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[" + session.getId() + "->" + attachedSession.getId() + "] attaching sessions");
        }
        AttachedSessionManager attachedSessionManager = new AttachedSessionManager(attachedSession);
        session.setAttribute((Object)ATTACHED_SESSION_KEY, (Object)attachedSessionManager);
        attachedSession.setAttribute((Object)ATTACHED_SESSION_KEY, (Object)new AttachedSessionManager(session));
        return attachedSessionManager;
    }

    static IoSession detachSessions(IoSession session) {
        AttachedSessionManager detached = (AttachedSessionManager)session.removeAttribute((Object)ATTACHED_SESSION_KEY);
        IoSession detachedSession = null;
        if (detached != null) {
            detachedSession = detached.getAttachedSession();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[" + session.getId() + "->" + detachedSession.getId() + "] detaching sessions");
            }
            detachedSession.removeAttribute((Object)ATTACHED_SESSION_KEY);
        }
        return detachedSession;
    }

    static /* synthetic */ int access$000(AbstractProxyHandler x0) {
        return x0.maximumTransferredBytes;
    }

    protected static class DuplicateBufferFilter
    extends WriteRequestFilterEx {
        private final IoBufferAllocatorEx<?> allocator;

        public DuplicateBufferFilter(IoBufferAllocatorEx<?> allocator) {
            this.allocator = allocator;
        }

        protected Object doFilterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest, Object message) throws Exception {
            if (message instanceof IoBufferEx) {
                IoBufferEx buf = (IoBufferEx)message;
                message = this.allocator.wrap(buf.buf(), buf.flags());
            }
            return message;
        }
    }

    protected class AttachedSessionManager {
        private final IoSession attachedSession;
        private final AtomicInteger scheduledWriteBytes = new AtomicInteger(0);
        private final AtomicBoolean readSuspended = new AtomicBoolean(false);
        private final AtomicInteger totalTransferredBytes = new AtomicInteger(0);
        private int sessionMaximumTransferredBytes = AbstractProxyHandler.access$000(AbstractProxyHandler.this);

        AttachedSessionManager(IoSession attachedSession) {
            this.attachedSession = attachedSession;
        }

        public IoSession getAttachedSession() {
            return this.attachedSession;
        }

        void writeMessage(final IoSession sourceSession, Object message) {
            int bytesWritten;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("[" + sourceSession.getId() + "->" + this.attachedSession.getId() + "] proxying message: " + message);
            }
            if (message instanceof IoBuffer) {
                IoBuffer b = (IoBuffer)message;
                bytesWritten = b.remaining();
            } else {
                bytesWritten = 0;
            }
            switch (this.sessionMaximumTransferredBytes) {
                case -1: {
                    break;
                }
                case 0: {
                    return;
                }
                default: {
                    int newTotalTransferredBytes = this.totalTransferredBytes.addAndGet(bytesWritten);
                    if (newTotalTransferredBytes <= this.sessionMaximumTransferredBytes) break;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("[" + sourceSession.getId() + "->" + this.attachedSession.getId() + ", " + Thread.currentThread().getName() + "] writeMessage (maximum bytes transferred, draining only)");
                    }
                    this.sessionMaximumTransferredBytes = 0;
                }
            }
            int newScheduledWriteBytes = this.scheduledWriteBytes.addAndGet(bytesWritten);
            if (newScheduledWriteBytes > AbstractProxyHandler.this.maximumPendingBytes) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[" + sourceSession.getId() + "->" + this.attachedSession.getId() + ", " + Thread.currentThread().getName() + "] scheduledWriteBytes " + newScheduledWriteBytes + " exceeds " + AbstractProxyHandler.this.maximumPendingBytes + ", suspending reads on " + sourceSession);
                }
                while (this.readSuspended.compareAndSet(false, true)) {
                    sourceSession.suspendRead();
                }
            }
            WriteFuture future = this.attachedSession.write(message);
            future.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                public void operationComplete(WriteFuture future) {
                    int newScheduledWriteBytes = AttachedSessionManager.this.scheduledWriteBytes.addAndGet(-bytesWritten);
                    if (AttachedSessionManager.this.readSuspended.get() && newScheduledWriteBytes <= AbstractProxyHandler.this.thresholdPendingBytes) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("[" + sourceSession.getId() + "->" + AttachedSessionManager.this.attachedSession.getId() + ", " + Thread.currentThread().getName() + "] scheduledWriteBytes " + newScheduledWriteBytes + " <= " + AbstractProxyHandler.this.thresholdPendingBytes + ", resuming reads on " + sourceSession);
                        }
                        while (AttachedSessionManager.this.readSuspended.compareAndSet(true, false)) {
                            sourceSession.resumeRead();
                        }
                    }
                }
            });
        }
    }
}

