/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kaazing.gateway.server.config.june2016.ServiceConnectOptionsType;
import org.kaazing.gateway.server.context.resolve.DefaultOptionsContext;
import org.kaazing.gateway.service.ConnectOptionsContext;
import org.kaazing.gateway.util.ws.WebSocketWireProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectOptionsContext
extends DefaultOptionsContext
implements ConnectOptionsContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConnectOptionsContext.class);
    private final Map<String, String> options;

    public DefaultConnectOptionsContext() {
        this.options = Collections.emptyMap();
    }

    public DefaultConnectOptionsContext(ServiceConnectOptionsType connectOptions, ServiceConnectOptionsType defaultOptions) {
        Map<String, String> options = this.parseConnectOptionsType(connectOptions);
        this.parseConnectOptionsType(defaultOptions).entrySet().stream().forEach(e -> {
            String cfr_ignored_0 = (String)options.putIfAbsent((String)e.getKey(), (String)e.getValue());
        });
        this.options = Collections.unmodifiableMap(options);
    }

    public Map<String, Object> asOptionsMap() {
        String udpAlign;
        String httpTransport;
        String sslTransport;
        String tcpTransport;
        String[] socksSslProtocols;
        String[] sslProtocols;
        String[] sslCiphers;
        HashMap<String, String> optionsCopy = new HashMap<String, String>(this.options);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        WebSocketWireProtocol wsVersion = DefaultConnectOptionsContext.getWebSocketWireProtocol((String)optionsCopy.remove("ws.version"));
        result.put("protocolVersion", wsVersion);
        String wsInactivityTimeoutStr = (String)optionsCopy.remove("ws.inactivity.timeout");
        String httpKeepaliveTimeoutStr = (String)optionsCopy.remove("http.keepalive.timeout");
        if (wsInactivityTimeoutStr != null && httpKeepaliveTimeoutStr == null) {
            httpKeepaliveTimeoutStr = wsInactivityTimeoutStr;
        }
        long wsInactivityTimeout = DefaultConnectOptionsContext.getWsInactivityTimeout(wsInactivityTimeoutStr);
        result.put("ws.inactivityTimeout", wsInactivityTimeout);
        int httpKeepaliveTimeout = DefaultConnectOptionsContext.getHttpKeepaliveTimeout(httpKeepaliveTimeoutStr);
        result.put("http[http/1.1].keepAliveTimeout", httpKeepaliveTimeout);
        if (wsInactivityTimeoutStr != null && TimeUnit.MILLISECONDS.convert(httpKeepaliveTimeout, TimeUnit.SECONDS) < wsInactivityTimeout) {
            LOGGER.warn("http.keepalive.timeout={} should be greater-than-or-equal-to ws.inactivity.timeout={} in connect-options", (Object)httpKeepaliveTimeoutStr, (Object)wsInactivityTimeoutStr);
        }
        boolean keepAlive = DefaultConnectOptionsContext.isHttpKeepaliveEnabled((String)optionsCopy.remove("http.keepalive"));
        result.put("http[http/1.1].keepAlive", keepAlive);
        Integer keepaliveConnections = DefaultConnectOptionsContext.getHttpKeepaliveConnections((String)optionsCopy.remove("http.keepalive.connections"));
        if (keepaliveConnections != null) {
            result.put("http[http/1.1].keepalive.connections", keepaliveConnections);
        }
        if ((sslCiphers = DefaultConnectOptionsContext.getSslCiphers((String)optionsCopy.remove("ssl.ciphers"))) != null) {
            result.put("ssl.ciphers", sslCiphers);
        }
        if ((sslProtocols = DefaultConnectOptionsContext.getSslProtocols((String)optionsCopy.remove("ssl.protocols"))) != null) {
            result.put("ssl.protocols", sslProtocols);
        }
        boolean sslEncryptionEnabled = DefaultConnectOptionsContext.isSslEncryptionEnabled((String)optionsCopy.remove("ssl.encryption"));
        result.put("ssl.encryptionEnabled", sslEncryptionEnabled);
        String sslVerifyClientValue = (String)optionsCopy.remove("ssl.verify-client");
        boolean[] clientAuth = DefaultConnectOptionsContext.getVerifyClientProperties(sslVerifyClientValue);
        result.put("ssl.wantClientAuth", clientAuth[0]);
        result.put("ssl.needClientAuth", clientAuth[1]);
        String[] socksSslCiphers = DefaultConnectOptionsContext.getSslCiphers((String)optionsCopy.remove("socks.ssl.ciphers"));
        if (socksSslCiphers != null) {
            result.put("socks.ssl.ciphers", socksSslCiphers);
        }
        if ((socksSslProtocols = DefaultConnectOptionsContext.getSslProtocols((String)optionsCopy.remove("socks.ssl.protocols"))) != null) {
            result.put("socks.ssl.protocols", socksSslProtocols);
        }
        String socksSslVerifyClientValue = (String)optionsCopy.remove("socks.ssl.verify-client");
        boolean[] socksSslClientAuth = DefaultConnectOptionsContext.getVerifyClientProperties(socksSslVerifyClientValue);
        result.put("socks.ssl.wantClientAuth", socksSslClientAuth[0]);
        result.put("socks.ssl.needClientAuth", socksSslClientAuth[1]);
        String pipeTransport = DefaultConnectOptionsContext.getTransportURI("pipe.transport", (String)optionsCopy.remove("pipe.transport"));
        if (pipeTransport != null) {
            result.put("pipe.transport", pipeTransport);
        }
        if ((tcpTransport = DefaultConnectOptionsContext.getTransportURI("tcp.transport", (String)optionsCopy.remove("tcp.transport"))) != null) {
            result.put("tcp.transport", tcpTransport);
        }
        if ((sslTransport = DefaultConnectOptionsContext.getTransportURI("ssl.transport", (String)optionsCopy.remove("ssl.transport"))) != null) {
            result.put("ssl.transport", sslTransport);
        }
        if ((httpTransport = DefaultConnectOptionsContext.getTransportURI("http.transport", (String)optionsCopy.remove("http.transport"))) != null) {
            result.put("http[http/1.1].transport", httpTransport);
        }
        if ((udpAlign = (String)optionsCopy.remove("udp.padding.alignment")) != null) {
            result.put("udp.padding.alignment", Integer.valueOf(udpAlign));
        }
        result.putAll(optionsCopy);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Connect options map = %s", result));
        }
        return result;
    }

    private Map<String, String> parseConnectOptionsType(ServiceConnectOptionsType connectOptionsType) {
        return connectOptionsType != null ? DefaultConnectOptionsContext.parseOptions(connectOptionsType.getDomNode()) : new HashMap();
    }
}

