/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.config.parse.translate;

import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.kaazing.gateway.server.config.parse.GatewayConfigNamespace;
import org.kaazing.gateway.server.config.parse.translate.AbstractVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceVisitor
extends AbstractVisitor {
    private static final Logger logger = LoggerFactory.getLogger(NamespaceVisitor.class);
    private GatewayConfigNamespace ns;

    public NamespaceVisitor(GatewayConfigNamespace ns) {
        this.ns = ns;
    }

    @Override
    public void visit(Element current) {
        current.setNamespace(Namespace.getNamespace((String)"", (String)this.ns.toURI()));
        List kids = current.getChildren();
        if (kids.size() > 0) {
            for (Element kid : kids) {
                this.visit(kid);
            }
        }
    }

    @Override
    public void translate(Document dom) throws Exception {
        super.translate(dom);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Set XML namespace to URI '%s'", this.ns.toURI()));
        }
    }
}

