/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Resource;
import org.kaazing.gateway.server.GatewayObserverApi;
import org.kaazing.gateway.server.GatewayObserverFactorySpi;
import org.kaazing.gateway.server.context.GatewayContext;
import org.kaazing.gateway.service.ServiceContext;

public final class GatewayObserver
implements GatewayObserverApi {
    private final List<GatewayObserverFactorySpi> gatewayListenerSpi;

    private GatewayObserver(Set<GatewayObserverFactorySpi> gatewayListenerSpis) {
        ArrayList<GatewayObserverFactorySpi> list = new ArrayList<GatewayObserverFactorySpi>(gatewayListenerSpis);
        this.gatewayListenerSpi = Collections.unmodifiableList(list);
    }

    public static GatewayObserver newInstance() {
        return GatewayObserver.newInstance(ServiceLoader.load(GatewayObserverFactorySpi.class));
    }

    public static GatewayObserver newInstance(ClassLoader loader) {
        return GatewayObserver.newInstance(ServiceLoader.load(GatewayObserverFactorySpi.class, loader));
    }

    private static GatewayObserver newInstance(ServiceLoader<GatewayObserverFactorySpi> gatewayListenerSpis) {
        Set<GatewayObserverFactorySpi> gatewayListenerSpiList = Collections.synchronizedSet(new HashSet());
        for (GatewayObserverFactorySpi gatewayListenerSpi : gatewayListenerSpis) {
            gatewayListenerSpiList.add(gatewayListenerSpi);
        }
        return new GatewayObserver(gatewayListenerSpiList);
    }

    private static void injectResources(Object target, Map<String, Object> values) {
        if (target == null) {
            return;
        }
        Class<?> clazz = target.getClass();
        for (Method method : clazz.getMethods()) {
            Resource resource = method.getAnnotation(Resource.class);
            if (resource == null) continue;
            String name = resource.name();
            Object val = values.get(name);
            try {
                method.invoke(target, val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void initingService(ServiceContext serviceContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.initingService(serviceContext);
        }
    }

    @Override
    public void initedService(ServiceContext serviceContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.initedService(serviceContext);
        }
    }

    @Override
    public void startingService(ServiceContext serviceContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.startingService(serviceContext);
        }
    }

    @Override
    public void startedService(ServiceContext serviceContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.startedService(serviceContext);
        }
    }

    @Override
    public void stopingService(ServiceContext serviceContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.stopingService(serviceContext);
        }
    }

    @Override
    public void stoppedService(ServiceContext serviceContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.stoppedService(serviceContext);
        }
    }

    @Override
    public void quiesceingService(ServiceContext serviceContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.quiesceingService(serviceContext);
        }
    }

    @Override
    public void quiescedService(ServiceContext serviceContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.quiescedService(serviceContext);
        }
    }

    @Override
    public void destroyingService(ServiceContext serviceContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.destroyingService(serviceContext);
        }
    }

    @Override
    public void destroyedService(ServiceContext serviceContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.destroyedService(serviceContext);
        }
    }

    @Override
    public void startingGateway(GatewayContext gatewayContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            GatewayObserver.injectResources(gatewayListener, gatewayContext.getInjectables());
        }
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.startingGateway(gatewayContext);
        }
    }

    @Override
    public void initingGateway(Properties configuration, Map<String, Object> injectables) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.initingGateway(configuration, injectables);
        }
    }

    @Override
    public void stoppedGateway(GatewayContext gatewayContext) {
        for (GatewayObserverFactorySpi gatewayListener : this.gatewayListenerSpi) {
            gatewayListener.stoppedGateway(gatewayContext);
        }
    }
}

