/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.kaazing.gateway.server.ConfigurationExtensionApi;
import org.kaazing.gateway.server.config.june2016.LoginModuleOptionsType;

public class ConfigurationObserver
implements ConfigurationExtensionApi {
    private final List<ConfigurationExtensionApi> configurationListenerSpi;

    private ConfigurationObserver(Set<ConfigurationExtensionApi> configurationListenerSpis) {
        ArrayList<ConfigurationExtensionApi> list = new ArrayList<ConfigurationExtensionApi>(configurationListenerSpis);
        this.configurationListenerSpi = Collections.unmodifiableList(list);
    }

    public static ConfigurationObserver newInstance() {
        return ConfigurationObserver.newInstance(ServiceLoader.load(ConfigurationExtensionApi.class));
    }

    public static ConfigurationObserver newInstance(ClassLoader loader) {
        return ConfigurationObserver.newInstance(ServiceLoader.load(ConfigurationExtensionApi.class, loader));
    }

    private static ConfigurationObserver newInstance(ServiceLoader<ConfigurationExtensionApi> configurationListenerSpis) {
        Set<ConfigurationExtensionApi> configurationListenerSpiList = Collections.synchronizedSet(new HashSet());
        for (ConfigurationExtensionApi configurationListenerSpi : configurationListenerSpis) {
            configurationListenerSpiList.add(configurationListenerSpi);
        }
        return new ConfigurationObserver(configurationListenerSpiList);
    }

    @Override
    public void parseCustomOptions(Map<String, Object> options, LoginModuleOptionsType rawOptions) {
        for (ConfigurationExtensionApi configurationListener : this.configurationListenerSpi) {
            configurationListener.parseCustomOptions(options, rawOptions);
        }
    }
}

