/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.kaazing.gateway.service.cluster.ClusterConnectOptionsContext;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.service.cluster.MemberId;
import org.kaazing.gateway.service.cluster.MembershipEventListener;
import org.kaazing.gateway.service.collections.CollectionsFactory;
import org.kaazing.gateway.service.collections.MemoryCollectionsFactory;
import org.kaazing.gateway.util.Utils;

public class StandaloneClusterContext
implements ClusterContext {
    private final CollectionsFactory collectionsFactory;
    private final ConcurrentMap<String, Lock> locks;
    private final String localInstanceKey = Utils.randomHexString((int)16);

    public StandaloneClusterContext() {
        this.collectionsFactory = new MemoryCollectionsFactory();
        this.locks = new ConcurrentHashMap<String, Lock>();
    }

    public void addMembershipEventListener(MembershipEventListener eventListener) {
    }

    public void removeMembershipEventListener(MembershipEventListener eventListener) {
    }

    public String getClusterName() {
        return this.getLocalMember().toString();
    }

    public List<MemberId> getMemberIds() {
        ArrayList<MemberId> list = new ArrayList<MemberId>();
        list.add(this.getLocalMember());
        return list;
    }

    public List<MemberId> getAccepts() {
        return null;
    }

    public List<MemberId> getConnects() {
        return null;
    }

    public ClusterConnectOptionsContext getConnectOptions() {
        return null;
    }

    public MemberId getLocalMember() {
        return new MemberId("tcp", "standalone", 0);
    }

    public String getInstanceKey(MemberId memberId) {
        return this.localInstanceKey;
    }

    public Lock getLock(String name) {
        Lock oldLock;
        Lock lock = (Lock)this.locks.get(name);
        if (lock == null && (oldLock = this.locks.putIfAbsent(name, lock = new ReentrantLock())) != null) {
            lock = oldLock;
        }
        return lock;
    }

    public void start() {
    }

    public void dispose() {
    }

    public CollectionsFactory getCollectionsFactory() {
        return this.collectionsFactory;
    }

    public void logClusterState() {
    }

    public void logClusterStateAtInfoLevel() {
    }
}

