/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.config.parse.translate;

import java.util.ServiceLoader;
import org.kaazing.gateway.server.config.parse.GatewayConfigNamespace;
import org.kaazing.gateway.server.config.parse.translate.GatewayConfigTranslator;
import org.kaazing.gateway.server.config.parse.translate.spi.GatewayConfigTranslatorFactorySpi;

public class GatewayConfigTranslatorFactory {
    private final ServiceLoader<GatewayConfigTranslatorFactorySpi> services;

    public GatewayConfigTranslatorFactory(ServiceLoader<GatewayConfigTranslatorFactorySpi> services) {
        this.services = services;
    }

    public static GatewayConfigTranslatorFactory newInstance() {
        ServiceLoader<GatewayConfigTranslatorFactorySpi> services = ServiceLoader.load(GatewayConfigTranslatorFactorySpi.class);
        return GatewayConfigTranslatorFactory.newInstance(services);
    }

    public static GatewayConfigTranslatorFactory newInstance(ClassLoader cl) {
        ServiceLoader<GatewayConfigTranslatorFactorySpi> services = ServiceLoader.load(GatewayConfigTranslatorFactorySpi.class, cl);
        return GatewayConfigTranslatorFactory.newInstance(services);
    }

    private static GatewayConfigTranslatorFactory newInstance(ServiceLoader<GatewayConfigTranslatorFactorySpi> services) {
        return new GatewayConfigTranslatorFactory(services);
    }

    public GatewayConfigTranslator getTranslator(GatewayConfigNamespace namespace) throws Exception {
        for (GatewayConfigTranslatorFactorySpi factory : this.services) {
            GatewayConfigTranslator result = factory.getTranslator(namespace);
            if (result == null) continue;
            return result;
        }
        throw new Exception("Unrecognized gateway configuration namespace " + (Object)((Object)namespace));
    }
}

