/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleNetworkConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class NetworkConfiguration
implements Configuration<SuppressibleNetworkConfiguration> {
    private final SuppressibleNetworkConfiguration _configuration;
    private final Map<String, Suppressible<String[]>> mappings = new HashMap<String, Suppressible<String[]>>();
    private final Map<String, String[]> unsuppressibleMappings = Suppressibles.unsuppressibleMap(this.mappings);

    public NetworkConfiguration() {
        this._configuration = new SuppressibleNetworkConfigurationImpl();
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SuppressibleNetworkConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    public Map<String, String[]> getMappings() {
        return this.unsuppressibleMappings;
    }

    public void addMapping(String internalAddress, String[] externalAddresses) {
        this.unsuppressibleMappings.put(internalAddress, externalAddresses);
    }

    private class SuppressibleNetworkConfigurationImpl
    extends SuppressibleNetworkConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        private SuppressibleNetworkConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }

        @Override
        public Map<String, Suppressible<String[]>> getMappings() {
            return NetworkConfiguration.this.mappings;
        }

        @Override
        public void addMapping(String internalAddress, Suppressible<String[]> externalAddresses) {
            NetworkConfiguration.this.mappings.put(internalAddress, externalAddresses);
        }
    }
}

