/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleNestedServicePropertiesConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class NestedServicePropertiesConfiguration
implements Configuration<SuppressibleNestedServicePropertiesConfiguration> {
    private String configElementName;
    private final SuppressibleNestedServicePropertiesConfiguration _configuration;
    private final Map<String, Suppressible<List<String>>> suppressibleSimpleProperties = new HashMap<String, Suppressible<List<String>>>();
    private final Map<String, List<String>> simpleProperties = Suppressibles.unsuppressibleMap(this.suppressibleSimpleProperties);
    private final List<NestedServicePropertiesConfiguration> nestedServiceProperties = new ArrayList<NestedServicePropertiesConfiguration>();

    public NestedServicePropertiesConfiguration(String configElementName) {
        this.configElementName = configElementName;
        this._configuration = new SuppressibleNestedServicePropertiesConfigurationImpl();
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
    }

    public Map<String, List<String>> getSimpleProperties() {
        return this.simpleProperties;
    }

    public void addSimpleProperty(String key, String value) {
        if (this.simpleProperties.containsKey(key)) {
            this.simpleProperties.get(key).add(value);
        } else {
            ArrayList<String> newValue = new ArrayList<String>(Arrays.asList(value));
            this.simpleProperties.put(key, newValue);
        }
    }

    public Collection<NestedServicePropertiesConfiguration> getNestedProperties() {
        return this.nestedServiceProperties;
    }

    public void addNestedProperties(NestedServicePropertiesConfiguration configuration) {
        this.nestedServiceProperties.add(configuration);
    }

    public String getConfigElementName() {
        return this.configElementName;
    }

    public void setConfigElementName(String configElementName) {
        this.configElementName = configElementName;
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SuppressibleNestedServicePropertiesConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    private class SuppressibleNestedServicePropertiesConfigurationImpl
    extends SuppressibleNestedServicePropertiesConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        private SuppressibleNestedServicePropertiesConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }

        @Override
        public Map<String, Suppressible<List<String>>> getSimpleProperties() {
            return NestedServicePropertiesConfiguration.this.suppressibleSimpleProperties;
        }

        @Override
        public void addSimpleProperty(String key, Suppressible<String> value) {
            String v = value.value();
            if (NestedServicePropertiesConfiguration.this.suppressibleSimpleProperties.containsKey(key)) {
                ((List)((Suppressible)NestedServicePropertiesConfiguration.this.suppressibleSimpleProperties.get(key)).value()).add(v);
            } else {
                ArrayList<String> newValue = new ArrayList<String>(Arrays.asList(v));
                Suppressible<ArrayList<String>> supValue = new Suppressible<ArrayList<String>>(newValue, Suppressibles.getDefaultSuppressions());
                NestedServicePropertiesConfiguration.this.suppressibleSimpleProperties.put(key, supValue);
            }
        }

        @Override
        public String getConfigElementType() {
            return NestedServicePropertiesConfiguration.this.configElementName;
        }
    }
}

