/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config.builder;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Set;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.builder.UnresolvedSuppression;

public abstract class AbstractConfigurationBuilder<C extends Configuration<?>, R> {
    protected final C configuration;
    protected final R result;
    protected final Set<SuppressibleConfiguration.Suppression> defaultSuppressions;
    protected final Deque<Set<SuppressibleConfiguration.Suppression>> currentSuppressions = new ArrayDeque<Set<SuppressibleConfiguration.Suppression>>();

    public R done() {
        return this.result;
    }

    protected AbstractConfigurationBuilder(C configuration, R result, Set<SuppressibleConfiguration.Suppression> defaultSuppressions) {
        this.configuration = configuration;
        this.result = result;
        this.defaultSuppressions = defaultSuppressions;
        configuration.getSuppressibleConfiguration().setSuppression(defaultSuppressions);
    }

    public Set<SuppressibleConfiguration.Suppression> getCurrentSuppressions() {
        if (this.currentSuppressions.isEmpty()) {
            return this.defaultSuppressions;
        }
        return this.currentSuppressions.peek();
    }

    protected void unresolvedSuppress(Set<UnresolvedSuppression> suppressions) {
        EnumSet<SuppressibleConfiguration.Suppression> newSuppressions = EnumSet.noneOf(SuppressibleConfiguration.Suppression.class);
        for (UnresolvedSuppression suppression : suppressions) {
            switch (suppression) {
                case INHERITED: {
                    this.currentSuppressions.clear();
                    newSuppressions.clear();
                    break;
                }
                case NONE: {
                    newSuppressions.add(SuppressibleConfiguration.Suppression.NONE);
                    break;
                }
                case UNIFIED: {
                    newSuppressions.add(SuppressibleConfiguration.Suppression.UNIFIED);
                }
            }
        }
        if (newSuppressions.isEmpty()) {
            return;
        }
        this.currentSuppressions.push(newSuppressions);
    }

    public abstract AbstractConfigurationBuilder<?, ?> suppress(SuppressibleConfiguration.Suppression ... var1);

    protected void addCurrentSuppressions(SuppressibleConfiguration.Suppression ... suppressions) {
        EnumSet<SuppressibleConfiguration.Suppression> newSuppressions = EnumSet.noneOf(SuppressibleConfiguration.Suppression.class);
        int i = suppressions.length;
        while (i > 0) {
            SuppressibleConfiguration.Suppression currentSuppression;
            if ((currentSuppression = suppressions[--i]) == SuppressibleConfiguration.Suppression.NONE) {
                newSuppressions.add(SuppressibleConfiguration.Suppression.NONE);
                this.currentSuppressions.push(newSuppressions);
                return;
            }
            if (currentSuppression != SuppressibleConfiguration.Suppression.UNIFIED) continue;
            newSuppressions.add(SuppressibleConfiguration.Suppression.UNIFIED);
            this.currentSuppressions.push(newSuppressions);
            return;
        }
    }
}

