/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.windowsservice;

import com.sun.jna.Pointer;
import java.util.Arrays;
import org.kaazing.gateway.server.windowsservice.ExtendedAdvapi32;
import org.kaazing.gateway.server.windowsservice.ISimpleService;
import org.kaazing.gateway.server.windowsservice.SERVICE_MAIN_FUNCTION;
import org.kaazing.gateway.server.windowsservice.SimpleServiceControlHandler;

class SimpleServiceMain
implements SERVICE_MAIN_FUNCTION {
    private final ISimpleService simpleService;
    private final SimpleServiceControlHandler handler;
    private ExtendedAdvapi32.SERVICE_STATUS_HANDLE serviceStatusHandle;

    public SimpleServiceMain(ISimpleService simpleService, SimpleServiceControlHandler handler) {
        this.simpleService = simpleService;
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ServiceMain(int argc, Pointer argv) {
        if (argc < 1 || argv == null) {
            return;
        }
        try {
            String[] args = argv.getStringArray(0L, argc, true);
            String serviceName = args[0];
            String[] startParameters = Arrays.copyOfRange(args, 1, args.length);
            this.serviceStatusHandle = ExtendedAdvapi32.INSTANCE.RegisterServiceCtrlHandlerEx(serviceName, this.handler, null);
            this.setServiceStatus(4, 5);
            this.simpleService.run(startParameters);
        }
        finally {
            this.setServiceStatus(1, 0);
        }
    }

    private void setServiceStatus(int currentState, int controlsAccepted) {
        ExtendedAdvapi32.SERVICE_STATUS serviceStatus = new ExtendedAdvapi32.SERVICE_STATUS();
        serviceStatus.currentState = currentState;
        serviceStatus.controlsAccepted = controlsAccepted;
        ExtendedAdvapi32.INSTANCE.SetServiceStatus(this.serviceStatusHandle, serviceStatus);
    }
}

