/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.util.collection;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Predicate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.kaazing.gateway.server.util.collection.IMapProxy;
import org.kaazing.gateway.service.cluster.EntryListenerSupport;

public class ReplicatedIMap<K, V>
extends IMapProxy<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IMap<K, V> delegate;
    private transient EntryListenerSupport<K, V> listenerSupport;
    private transient Map<K, V> localCache;
    private transient Lock localCacheLock;

    public ReplicatedIMap(IMap<K, V> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.delegate = delegate;
        this.init();
    }

    @Override
    public void addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        this.listenerSupport.addEntryListener(listener, includeValue);
    }

    @Override
    public void addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        this.listenerSupport.addEntryListener(listener, key, includeValue);
    }

    @Override
    public void removeEntryListener(EntryListener<K, V> listener, K key) {
        this.listenerSupport.removeEntryListener(listener, key);
    }

    @Override
    public void removeEntryListener(EntryListener<K, V> listener) {
        this.listenerSupport.removeEntryListener(listener);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V oldValue = super.putIfAbsent(key, value);
        if (oldValue == null) {
            this.localCache.put(key, value);
            return null;
        }
        return this.localCache.get(key);
    }

    @Override
    public V get(Object key) {
        return this.localCache.get(key);
    }

    @Override
    protected IMap<K, V> getDelegate() {
        return this.delegate;
    }

    private void init() {
        this.listenerSupport = new EntryListenerSupport();
        this.localCache = new HashMap<K, V>(this.delegate);
        this.localCacheLock = new ReentrantLock();
        this.delegate.addEntryListener(new EntryListener<K, V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void entryAdded(EntryEvent<K, V> event) {
                Object key = event.getKey();
                Object newValue = event.getValue();
                EntryEvent localEvent = event;
                try {
                    ReplicatedIMap.this.localCacheLock.lock();
                    Object value = ReplicatedIMap.this.localCache.get(key);
                    if (value == null) {
                        ReplicatedIMap.this.localCache.put(key, newValue);
                    } else {
                        localEvent = new EntryEvent((Object)event.getName(), null, EntryEvent.TYPE_ADDED, key, value);
                    }
                }
                finally {
                    ReplicatedIMap.this.localCacheLock.unlock();
                }
                ReplicatedIMap.this.listenerSupport.entryAdded(localEvent);
            }

            public void entryEvicted(EntryEvent<K, V> event) {
            }

            public void entryRemoved(EntryEvent<K, V> event) {
                Object key = event.getKey();
                Object oldValue = ReplicatedIMap.this.localCache.remove(key);
                EntryEvent localEvent = new EntryEvent((Object)event.getName(), null, EntryEvent.TYPE_REMOVED, key, oldValue);
                ReplicatedIMap.this.listenerSupport.entryRemoved(localEvent);
            }

            public void entryUpdated(EntryEvent<K, V> event) {
                Object key = event.getKey();
                Object newValue = event.getValue();
                ReplicatedIMap.this.localCache.put(key, newValue);
                ReplicatedIMap.this.listenerSupport.entryUpdated(event);
            }
        }, true);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.init();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.localCache.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.localCache.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.localCache.values();
    }

    public String toString() {
        return this.localCache.toString();
    }

    public void addIndex(String attribute, boolean ordered) {
        throw new UnsupportedOperationException("addIndex");
    }

    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        throw new UnsupportedOperationException("entrySet");
    }

    public boolean evict(Object key) {
        if (this.localCache.containsKey(key)) {
            this.localCache.remove(key);
            return true;
        }
        return false;
    }

    public LocalMapStats getLocalMapStats() {
        throw new UnsupportedOperationException("getLocalMapStats");
    }

    public Set<K> keySet(Predicate predicate) {
        throw new UnsupportedOperationException("keySet");
    }

    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("localKeySet");
    }

    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException("localKeySet");
    }

    public boolean lockMap(long time, TimeUnit timeunit) {
        throw new UnsupportedOperationException("lockMap");
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        throw new UnsupportedOperationException("put");
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        throw new UnsupportedOperationException("putIfAbsent");
    }

    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        throw new UnsupportedOperationException("tryPut");
    }

    public void unlockMap() {
        throw new UnsupportedOperationException("unlockMap");
    }

    public Collection<V> values(Predicate predicate) {
        throw new UnsupportedOperationException("values");
    }

    public Future<V> getAsync(K key) {
        throw new UnsupportedOperationException("getAsync");
    }

    public Future<V> putAsync(K key, V value) {
        throw new UnsupportedOperationException("putAsync");
    }

    public void addIndex(Expression<?> arg0, boolean arg1) {
        throw new UnsupportedOperationException("addIndex");
    }

    public void addLocalEntryListener(EntryListener<K, V> arg0) {
        throw new UnsupportedOperationException("addLocalEntryListener");
    }

    public void flush() {
        throw new UnsupportedOperationException("flush");
    }

    public Map<K, V> getAll(Set<K> arg0) {
        throw new UnsupportedOperationException("getAll");
    }

    public void putAndUnlock(K arg0, V arg1) {
        throw new UnsupportedOperationException("putAndUnlock");
    }

    public void putTransient(K arg0, V arg1, long arg2, TimeUnit arg3) {
        throw new UnsupportedOperationException("putTransient");
    }

    public Future<V> removeAsync(K arg0) {
        throw new UnsupportedOperationException("removeAsync");
    }

    public V tryLockAndGet(K arg0, long arg1, TimeUnit arg2) throws TimeoutException {
        throw new UnsupportedOperationException("tryLockAndGet");
    }

    public Object tryRemove(K arg0, long arg1, TimeUnit arg2) throws TimeoutException {
        throw new UnsupportedOperationException("tryRemove");
    }
}

