/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kaazing.gateway.server.test.config.AuthorizationConstraintConfiguration;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.CrossOriginConstraintConfiguration;
import org.kaazing.gateway.server.test.config.NestedServicePropertiesConfiguration;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleServiceConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class ServiceConfiguration
implements Configuration<SuppressibleServiceConfiguration> {
    private final SuppressibleServiceConfigurationImpl _configuration = new SuppressibleServiceConfigurationImpl();
    private final List<AuthorizationConstraintConfiguration> authorizationConstraints;
    private final List<CrossOriginConstraintConfiguration> crossOriginConstraints;
    private Suppressible<String> _name;
    private Suppressible<String> _type;
    private Suppressible<String> _realmName;
    private Suppressible<String> _description;
    private final Set<Suppressible<URI>> balances;
    private final Set<Suppressible<URI>> accepts;
    private final Map<String, Suppressible<String>> acceptOptions;
    private final Set<Suppressible<URI>> connects;
    private final Map<String, Suppressible<String>> connectOptions;
    private final Map<String, Suppressible<String>> mimeMappings;
    private final Set<URI> unsuppressibleAccepts;
    private final Set<URI> unsuppressibleBalances;
    private final Map<String, String> unsuppressibleAcceptOptions;
    private final Set<URI> unsuppressibleConnects;
    private final Map<String, String> unsuppressibleConnectOptions;
    private final Map<String, String> unsuppressibleMimeMappings;
    private final Map<String, Suppressible<String>> properties;
    private final Map<String, String> unsuppressibleProperties;
    private final List<NestedServicePropertiesConfiguration> nestedProperties;

    public ServiceConfiguration() {
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
        this.balances = new HashSet<Suppressible<URI>>();
        this.unsuppressibleBalances = Suppressibles.unsuppressibleSet(this.balances);
        this.accepts = new HashSet<Suppressible<URI>>();
        this.unsuppressibleAccepts = Suppressibles.unsuppressibleSet(this.accepts);
        this.acceptOptions = new HashMap<String, Suppressible<String>>();
        this.unsuppressibleAcceptOptions = Suppressibles.unsuppressibleMap(this.acceptOptions);
        this.connects = new HashSet<Suppressible<URI>>();
        this.unsuppressibleConnects = Suppressibles.unsuppressibleSet(this.connects);
        this.connectOptions = new HashMap<String, Suppressible<String>>();
        this.unsuppressibleConnectOptions = Suppressibles.unsuppressibleMap(this.connectOptions);
        this.mimeMappings = new HashMap<String, Suppressible<String>>();
        this.unsuppressibleMimeMappings = Suppressibles.unsuppressibleMap(this.mimeMappings);
        this.properties = new HashMap<String, Suppressible<String>>();
        this.unsuppressibleProperties = Suppressibles.unsuppressibleMap(this.properties);
        this.authorizationConstraints = new LinkedList<AuthorizationConstraintConfiguration>();
        this.crossOriginConstraints = new LinkedList<CrossOriginConstraintConfiguration>();
        this.nestedProperties = new LinkedList<NestedServicePropertiesConfiguration>();
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SuppressibleServiceConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    public List<AuthorizationConstraintConfiguration> getAuthorizationConstraints() {
        return this.authorizationConstraints;
    }

    public List<CrossOriginConstraintConfiguration> getCrossOriginConstraints() {
        return this.crossOriginConstraints;
    }

    public void addAccept(URI acceptURI) {
        this.unsuppressibleBalances.add(acceptURI);
    }

    public Set<URI> getAccepts() {
        return this.unsuppressibleAccepts;
    }

    public void addBalance(URI balanceURI) {
        this.unsuppressibleBalances.add(balanceURI);
    }

    public Set<URI> getBalances() {
        return this.unsuppressibleBalances;
    }

    public void addConnect(URI connectURI) {
        this.unsuppressibleConnects.add(connectURI);
    }

    public Set<URI> getConnects() {
        return this.unsuppressibleConnects;
    }

    public void addConnectOption(String key, String value) {
        this.unsuppressibleMimeMappings.put(key, value);
    }

    public Map<String, String> getConnectOptions() {
        return this.unsuppressibleConnectOptions;
    }

    public void addMimeMapping(String key, String value) {
        this.unsuppressibleMimeMappings.put(key, value);
    }

    public Map<String, String> getMimeMappings() {
        return this.unsuppressibleMimeMappings;
    }

    public void addAcceptOption(String key, String value) {
        this.unsuppressibleAcceptOptions.put(key, value);
    }

    public Map<String, String> getAcceptOptions() {
        return this.unsuppressibleAcceptOptions;
    }

    public void setDescription(String description) {
        this._description = new Suppressible<String>(description, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getDescription() {
        if (this._description == null) {
            return null;
        }
        return this._description.value();
    }

    public void setName(String name) {
        this._name = new Suppressible<String>(name, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getName() {
        if (this._name == null) {
            return null;
        }
        return this._name.value();
    }

    public void setRealmName(String realmName) {
        this._realmName = new Suppressible<String>(realmName, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getRealmName() {
        if (this._realmName == null) {
            return null;
        }
        return this._realmName.value();
    }

    public void setType(String type) {
        this._type = new Suppressible<String>(type, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getType() {
        if (this._type == null) {
            return null;
        }
        return this._type.value();
    }

    public List<NestedServicePropertiesConfiguration> getNestedProperties() {
        return this.nestedProperties;
    }

    public void addNestedProperties(NestedServicePropertiesConfiguration configuration) {
        this.nestedProperties.add(configuration);
    }

    public Map<String, String> getProperties() {
        return this.unsuppressibleProperties;
    }

    public void addProperty(String key, String value) {
        this.unsuppressibleProperties.put(key, value);
    }

    protected class SuppressibleServiceConfigurationImpl
    extends SuppressibleServiceConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        protected SuppressibleServiceConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }

        @Override
        public Set<Suppressible<URI>> getAccepts() {
            return ServiceConfiguration.this.accepts;
        }

        @Override
        public void addAccept(Suppressible<URI> acceptURI) {
            ServiceConfiguration.this.accepts.add(acceptURI);
        }

        @Override
        public Map<String, Suppressible<String>> getProperties() {
            return ServiceConfiguration.this.properties;
        }

        @Override
        public void addProperty(String key, Suppressible<String> value) {
            ServiceConfiguration.this.properties.put(key, value);
        }

        @Override
        public Suppressible<String> getType() {
            return ServiceConfiguration.this._type;
        }

        @Override
        public void setType(Suppressible<String> type) {
            ServiceConfiguration.this._type = type;
        }

        @Override
        public Suppressible<String> getDescription() {
            return ServiceConfiguration.this._description;
        }

        @Override
        public void setDescription(Suppressible<String> description) {
            ServiceConfiguration.this._description = description;
        }

        @Override
        public Suppressible<String> getName() {
            return ServiceConfiguration.this._name;
        }

        @Override
        public void setName(Suppressible<String> name) {
            ServiceConfiguration.this._name = name;
        }

        @Override
        public Suppressible<String> getRealmName() {
            return ServiceConfiguration.this._realmName;
        }

        @Override
        public void setRealmName(Suppressible<String> realmName) {
            ServiceConfiguration.this._realmName = realmName;
        }

        @Override
        public Map<String, Suppressible<String>> getAcceptOptions() {
            return ServiceConfiguration.this.acceptOptions;
        }

        @Override
        public void addAcceptOption(String key, Suppressible<String> value) {
            ServiceConfiguration.this.acceptOptions.put(key, value);
        }

        @Override
        public Set<Suppressible<URI>> getBalances() {
            return ServiceConfiguration.this.balances;
        }

        @Override
        public void addBalance(Suppressible<URI> balanceURI) {
            ServiceConfiguration.this.balances.add(balanceURI);
        }

        @Override
        public Set<Suppressible<URI>> getConnects() {
            return ServiceConfiguration.this.connects;
        }

        @Override
        public void addConnect(Suppressible<URI> acceptURI) {
            ServiceConfiguration.this.connects.add(acceptURI);
        }

        @Override
        public Map<String, Suppressible<String>> getConnectOptions() {
            return ServiceConfiguration.this.connectOptions;
        }

        @Override
        public void addConnectOption(String key, Suppressible<String> value) {
            ServiceConfiguration.this.connectOptions.put(key, value);
        }

        @Override
        public Map<String, Suppressible<String>> getMimeMappings() {
            return ServiceConfiguration.this.mimeMappings;
        }

        @Override
        public void addMimeMapping(String key, Suppressible<String> value) {
            ServiceConfiguration.this.mimeMappings.put(key, value);
        }
    }
}

