/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.RealmConfiguration;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleSecurityConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class SecurityConfiguration
implements Configuration<SuppressibleSecurityConfiguration> {
    private final SuppressibleSecurityConfiguration _configuration;
    private final List<RealmConfiguration> realms = new ArrayList<RealmConfiguration>();
    private Suppressible<KeyStore> _keyStore;
    private Suppressible<char[]> _keyStorePassword;
    private Suppressible<char[]> _trustStorePassword;
    private Suppressible<KeyStore> _trustStore;
    private String keyStoreFile;
    private String trustStoreFile;
    private String trustStorePasswordFile;
    private String keyStorePasswordFile;

    public SecurityConfiguration() {
        this._configuration = new SuppressibleSecurityConfigurationImpl();
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SuppressibleSecurityConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    public List<RealmConfiguration> getRealms() {
        return this.realms;
    }

    public void setRealms(List<RealmConfiguration> newRealms) {
        this.realms.clear();
        this.realms.addAll(newRealms);
    }

    public KeyStore getKeyStore() {
        if (this._keyStore == null) {
            return null;
        }
        return this._keyStore.value();
    }

    public void setKeyStore(KeyStore keyStore) {
        this._keyStore = new Suppressible<KeyStore>(keyStore, new SuppressibleConfiguration.Suppression[0]);
    }

    public char[] getKeyStorePassword() {
        if (this._keyStorePassword == null) {
            return null;
        }
        return this._keyStorePassword.value();
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this._keyStorePassword = new Suppressible<char[]>(keyStorePassword, new SuppressibleConfiguration.Suppression[0]);
    }

    public KeyStore getTrustStore() {
        if (this._trustStore == null) {
            return null;
        }
        return this._trustStore.value();
    }

    public void setTrustStore(KeyStore trustStore) {
        this._trustStore = new Suppressible<KeyStore>(trustStore, new SuppressibleConfiguration.Suppression[0]);
    }

    @Deprecated
    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    @Deprecated
    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    @Deprecated
    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    @Deprecated
    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public char[] getTrustStorePassword() {
        if (this._trustStorePassword == null) {
            return null;
        }
        return this._trustStorePassword.value();
    }

    public void setTrustStorePassword(char[] trustStorePassword) {
        this._trustStorePassword = new Suppressible<char[]>(trustStorePassword, new SuppressibleConfiguration.Suppression[0]);
    }

    @Deprecated
    public String getTrustStorePasswordFile() {
        return this.trustStorePasswordFile;
    }

    @Deprecated
    public void setTrustStorePasswordFile(String trustStorePasswordFile) {
        this.trustStorePasswordFile = trustStorePasswordFile;
    }

    @Deprecated
    public String getKeyStorePasswordFile() {
        return this.keyStorePasswordFile;
    }

    @Deprecated
    public void setKeyStorePasswordFile(String keyStorePasswordFile) {
        this.keyStorePasswordFile = keyStorePasswordFile;
    }

    protected class SuppressibleSecurityConfigurationImpl
    extends SuppressibleSecurityConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        protected SuppressibleSecurityConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }

        @Override
        public Suppressible<KeyStore> getKeyStore() {
            return SecurityConfiguration.this._keyStore;
        }

        @Override
        public void setKeyStore(Suppressible<KeyStore> keyStore) {
            SecurityConfiguration.this._keyStore = keyStore;
        }

        @Override
        public Suppressible<char[]> getKeyStorePassword() {
            return SecurityConfiguration.this._keyStorePassword;
        }

        @Override
        public void setKeyStorePassword(Suppressible<char[]> keyStorePassword) {
            SecurityConfiguration.this._keyStorePassword = keyStorePassword;
        }

        @Override
        public Suppressible<KeyStore> getTrustStore() {
            return SecurityConfiguration.this._trustStore;
        }

        @Override
        public void setTrustStore(Suppressible<KeyStore> trustStore) {
            SecurityConfiguration.this._trustStore = trustStore;
        }
    }
}

