/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleClusterConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class ClusterConfiguration
implements Configuration<SuppressibleClusterConfiguration> {
    private final SuppressibleClusterConfiguration _configuration = new SuppressibleClusterConfigurationImpl();
    private final Set<Suppressible<URI>> accepts;
    private final Set<URI> unsurpressibleAccepts;
    private final Set<Suppressible<URI>> connects;
    private final Set<URI> unsurpressibleConnects;
    private Suppressible<String> _name;
    private Suppressible<String> _awsAccessKeyId;
    private Suppressible<String> _awsSecretKeyId;

    public ClusterConfiguration() {
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
        this.accepts = new HashSet<Suppressible<URI>>();
        this.unsurpressibleAccepts = Suppressibles.unsuppressibleSet(this.accepts);
        this.connects = new HashSet<Suppressible<URI>>();
        this.unsurpressibleConnects = Suppressibles.unsuppressibleSet(this.connects);
    }

    @Override
    public SuppressibleClusterConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    public void addAccept(URI acceptURI) {
        this.unsurpressibleAccepts.add(acceptURI);
    }

    public Set<URI> getAccepts() {
        return this.unsurpressibleAccepts;
    }

    public void addConnect(URI connectURI) {
        this.unsurpressibleAccepts.add(connectURI);
    }

    public Set<URI> getConnects() {
        return this.unsurpressibleConnects;
    }

    public String getAwsAccessKeyId() {
        if (this._awsAccessKeyId == null) {
            return null;
        }
        return this._awsAccessKeyId.value();
    }

    public void setAwsAccessKeyId(String awsAccessKeyId) {
        this._awsAccessKeyId = new Suppressible<String>(awsAccessKeyId, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getAwsSecretKeyId() {
        if (this._awsSecretKeyId == null) {
            return null;
        }
        return this._awsSecretKeyId.value();
    }

    public void setAwsSecretKeyId(String awsSecretKeyId) {
        this._awsSecretKeyId = new Suppressible<String>(awsSecretKeyId, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getName() {
        if (this._name == null) {
            return null;
        }
        return this._name.value();
    }

    public void setName(String name) {
        this._name = new Suppressible<String>(name, new SuppressibleConfiguration.Suppression[0]);
    }

    private class SuppressibleClusterConfigurationImpl
    extends SuppressibleClusterConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        private SuppressibleClusterConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }

        @Override
        public Suppressible<String> getAwsSecretKeyId() {
            return ClusterConfiguration.this._awsSecretKeyId;
        }

        @Override
        public void setAwsSecretKeyId(Suppressible<String> awsSecretKeyId) {
            ClusterConfiguration.this._awsSecretKeyId = awsSecretKeyId;
        }

        @Override
        public Suppressible<String> getAwsAccessKeyId() {
            return ClusterConfiguration.this._awsAccessKeyId;
        }

        @Override
        public void setAwsAccessKeyId(Suppressible<String> awsAccessKeyId) {
            ClusterConfiguration.this._awsAccessKeyId = awsAccessKeyId;
        }

        @Override
        public Suppressible<String> getName() {
            return ClusterConfiguration.this._name;
        }

        @Override
        public void setName(Suppressible<String> name) {
            ClusterConfiguration.this._name = name;
        }

        @Override
        public Set<Suppressible<URI>> getConnects() {
            return ClusterConfiguration.this.connects;
        }

        @Override
        public void addConnect(Suppressible<URI> connect) {
            ClusterConfiguration.this.connects.add(connect);
        }

        @Override
        public Set<Suppressible<URI>> getAccepts() {
            return ClusterConfiguration.this.accepts;
        }

        @Override
        public void addAccept(Suppressible<URI> accept) {
            ClusterConfiguration.this.accepts.add(accept);
        }
    }
}

