/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kaazing.gateway.server.config.sep2014.ServiceConnectOptionsType;
import org.kaazing.gateway.service.ConnectOptionsContext;
import org.kaazing.gateway.util.Utils;
import org.kaazing.gateway.util.ssl.SslCipherSuites;
import org.kaazing.gateway.util.ws.WebSocketWireProtocol;

public class DefaultConnectOptionsContext
implements ConnectOptionsContext {
    private static final long DEFAULT_WS_INACTIVITY_TIMEOUT_MILLIS = 0L;
    private WebSocketWireProtocol webSocketWireProtocol = WebSocketWireProtocol.RFC_6455;
    private String[] sslCiphers;
    private String[] sslProtocols;
    private long wsInactivityTimeoutMillis;
    private String wsVersion;
    private URI pipeTransportURI;
    private URI tcpTransportURI;
    private URI sslTransportURI;
    private URI httpTransportURI;
    private boolean sslEncryptionEnabled = true;
    private String udpInterface;

    public DefaultConnectOptionsContext() {
        this(ServiceConnectOptionsType.Factory.newInstance());
    }

    public DefaultConnectOptionsContext(ServiceConnectOptionsType connectOptions) {
        if (connectOptions != null) {
            ServiceConnectOptionsType.SslEncryption.Enum encrypted;
            long val;
            String value;
            String httpTransport;
            String sslTransport;
            String pipeTransport;
            this.wsVersion = connectOptions.getWsVersion();
            if ("rfc6455".equals(this.wsVersion)) {
                this.webSocketWireProtocol = WebSocketWireProtocol.RFC_6455;
            } else if ("draft-75".equals(this.wsVersion)) {
                this.webSocketWireProtocol = WebSocketWireProtocol.HIXIE_75;
            }
            this.udpInterface = connectOptions.getUdpInterface();
            String sslCiphersStr = connectOptions.getSslCiphers();
            this.sslCiphers = sslCiphersStr != null ? SslCipherSuites.resolveCSV((String)sslCiphersStr) : null;
            String sslProtocolsStr = connectOptions.getSslProtocols();
            this.sslProtocols = sslProtocolsStr != null ? DefaultConnectOptionsContext.resolveProtocols(sslProtocolsStr) : null;
            String tcpTransport = connectOptions.getTcpTransport();
            if (tcpTransport != null) {
                this.tcpTransportURI = URI.create(tcpTransport);
                if (!this.tcpTransportURI.isAbsolute()) {
                    throw new IllegalArgumentException(String.format("tcp.transport must contain an absolute URI, not \"%s\"", tcpTransport));
                }
            }
            if ((pipeTransport = connectOptions.getPipeTransport()) != null) {
                this.pipeTransportURI = URI.create(pipeTransport);
                if (!this.pipeTransportURI.isAbsolute()) {
                    throw new IllegalArgumentException(String.format("pipe.transport must contain an absolute URI, not \"%s\"", pipeTransport));
                }
            }
            if ((sslTransport = connectOptions.getSslTransport()) != null) {
                this.sslTransportURI = URI.create(sslTransport);
                if (!this.sslTransportURI.isAbsolute()) {
                    throw new IllegalArgumentException(String.format("ssl.transport must contain an absolute URI, not \"%s\"", sslTransport));
                }
            }
            if ((httpTransport = connectOptions.getHttpTransport()) != null) {
                this.httpTransportURI = URI.create(httpTransport);
                if (!this.httpTransportURI.isAbsolute()) {
                    throw new IllegalArgumentException(String.format("http.transport must contain an absolute URI, not \"%s\"", httpTransport));
                }
            }
            Long wsInactivityTimeout = null;
            if (connectOptions != null && (value = connectOptions.getWsInactivityTimeout()) != null && (val = Utils.parseTimeInterval((String)value, (TimeUnit)TimeUnit.MILLISECONDS)) > 0L) {
                wsInactivityTimeout = val;
            }
            this.wsInactivityTimeoutMillis = wsInactivityTimeout == null ? 0L : wsInactivityTimeout;
            Boolean sslEncryptionEnabled = null;
            if (connectOptions != null && (encrypted = connectOptions.getSslEncryption()) != null) {
                sslEncryptionEnabled = encrypted != ServiceConnectOptionsType.SslEncryption.DISABLED;
            }
            this.sslEncryptionEnabled = sslEncryptionEnabled == null ? true : sslEncryptionEnabled;
        }
    }

    public WebSocketWireProtocol getWebSocketWireProtocol() {
        return this.webSocketWireProtocol;
    }

    public String[] getSslCiphers() {
        return this.sslCiphers;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public String getWsVersion() {
        return this.wsVersion;
    }

    public URI getPipeTransport() {
        return this.pipeTransportURI;
    }

    public URI getTcpTransport() {
        return this.tcpTransportURI;
    }

    public URI getSslTransport() {
        return this.sslTransportURI;
    }

    public URI getHttpTransport() {
        return this.httpTransportURI;
    }

    public long getWsInactivityTimeout() {
        return this.wsInactivityTimeoutMillis;
    }

    public boolean isSslEncryptionEnabled() {
        return this.sslEncryptionEnabled;
    }

    public Map<String, Object> asOptionsMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("ssl.ciphers", this.getSslCiphers());
        result.put("ssl.protocols", this.getSslProtocols());
        result.put("protocolVersion", this.webSocketWireProtocol);
        result.put("inactivityTimeout", this.getWsInactivityTimeout());
        result.put("pipe.transport", this.getPipeTransport());
        result.put("tcp.transport", this.getTcpTransport());
        result.put("ssl.transport", this.getSslTransport());
        result.put("http[http/1.1].transport", this.getHttpTransport());
        result.put("ssl.encryptionEnabled", this.isSslEncryptionEnabled());
        result.put("udp.interface", this.getUdpInterface());
        return result;
    }

    public String getUdpInterface() {
        return this.udpInterface;
    }

    public static String[] resolveProtocols(String csv) {
        if (csv != null && !csv.equals("")) {
            return csv.split(",");
        }
        return null;
    }
}

