/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.config.parse.translate.sep2014;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.kaazing.gateway.server.config.parse.translate.AbstractVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptUriComparedToBalanceUriVisitor
extends AbstractVisitor {
    private static final Logger logger = LoggerFactory.getLogger(AcceptUriComparedToBalanceUriVisitor.class);
    private static final String SERVICE_ELEMENT = "service";
    private static final String ACCEPT_URI_ELEMENT = "accept";
    private static final String BALANCE_URI_ELEMENT = "balance";
    private static final String URI_REGEX = "^(([^:/?#]+):(//))?([^/?#:]*)?(:)?([^/]+)([^?#]*)(\\?([^#]*))?(#(.*))?";
    private Pattern uriPattern = Pattern.compile("^(([^:/?#]+):(//))?([^/?#:]*)?(:)?([^/]+)([^?#]*)(\\?([^#]*))?(#(.*))?");

    @Override
    public void visit(Element element) throws Exception {
        List balanceElements = element.getChildren(BALANCE_URI_ELEMENT, element.getNamespace());
        if (balanceElements == null || balanceElements.isEmpty()) {
            return;
        }
        HashMap<String, LinkedList<ParameterizedURI>> processedBalanceElements = new HashMap<String, LinkedList<ParameterizedURI>>();
        for (Element balanceElement : balanceElements) {
            String balanceURIString = balanceElement.getValue();
            Matcher balanceMatcher = this.uriPattern.matcher(balanceURIString);
            if (balanceMatcher.matches()) {
                String balanceScheme = balanceMatcher.group(2);
                String balanceHost = balanceMatcher.group(4);
                String balancePort = balanceMatcher.group(6);
                String balancePath = balanceMatcher.group(7);
                ParameterizedURI pURI = new ParameterizedURI(balanceURIString, balanceScheme, balanceHost, balancePort, balancePath);
                LinkedList<ParameterizedURI> pURIsForScheme = (LinkedList<ParameterizedURI>)processedBalanceElements.get(balanceScheme);
                if (pURIsForScheme == null) {
                    pURIsForScheme = new LinkedList<ParameterizedURI>();
                    processedBalanceElements.put(balanceScheme, pURIsForScheme);
                }
                pURIsForScheme.add(pURI);
                continue;
            }
            throw new RuntimeException(String.format("Unable to parse balance URI: %s", balanceURIString));
        }
        List acceptElements = element.getChildren(ACCEPT_URI_ELEMENT, element.getNamespace());
        HashMap<String, LinkedList<ParameterizedURI>> processedAcceptElements = new HashMap<String, LinkedList<ParameterizedURI>>();
        for (Element acceptElement : acceptElements) {
            String acceptURIString = acceptElement.getValue();
            Matcher acceptMatcher = this.uriPattern.matcher(acceptURIString);
            if (acceptMatcher.matches()) {
                String acceptScheme = acceptMatcher.group(2);
                String acceptHost = acceptMatcher.group(4);
                String acceptPort = acceptMatcher.group(6);
                String acceptPath = acceptMatcher.group(7);
                ParameterizedURI pURI = new ParameterizedURI(acceptURIString, acceptScheme, acceptHost, acceptPort, acceptPath);
                LinkedList<ParameterizedURI> pURIsForScheme = (LinkedList<ParameterizedURI>)processedAcceptElements.get(acceptScheme);
                if (pURIsForScheme == null) {
                    pURIsForScheme = new LinkedList<ParameterizedURI>();
                    processedAcceptElements.put(acceptScheme, pURIsForScheme);
                }
                pURIsForScheme.add(pURI);
                continue;
            }
            throw new RuntimeException(String.format("Unable to parse accept URI: %s", acceptURIString));
        }
        for (String balanceScheme : processedBalanceElements.keySet()) {
            List balanceURIs = (List)processedBalanceElements.get(balanceScheme);
            List acceptURIs = (List)processedAcceptElements.get(balanceScheme);
            if (acceptURIs == null) {
                throw new RuntimeException(String.format("No accept URIs match balance scheme %s for balance URI %s", balanceScheme, ((ParameterizedURI)balanceURIs.iterator().next()).getOriginalURI()));
            }
            for (ParameterizedURI acceptURI : acceptURIs) {
                for (ParameterizedURI balanceURI : balanceURIs) {
                    if (balanceURI.isValidBalanceTarget(acceptURI)) {
                        if (!logger.isDebugEnabled()) continue;
                        String relationshipStr = balanceURI.getRelationshipWith(acceptURI);
                        String msg = String.format("Found relationship %s between balance URI: %s and accept URI: %s", relationshipStr, balanceURI.getOriginalURI(), acceptURI.getOriginalURI());
                        logger.debug(msg);
                        continue;
                    }
                    throw new RuntimeException(String.format("Accept URI: %s does not match balance URI %s in all but hostname.  Unable to launch Gateway.", acceptURI.getOriginalURI(), balanceURI.getOriginalURI()));
                }
            }
        }
        for (String acceptScheme : processedAcceptElements.keySet()) {
            List acceptURIs = (List)processedAcceptElements.get(acceptScheme);
            List balanceURIs = (List)processedBalanceElements.get(acceptScheme);
            if (balanceURIs != null) continue;
            throw new RuntimeException(String.format("No balance URIs match accept scheme %s for accept URI %s", acceptScheme, ((ParameterizedURI)acceptURIs.iterator().next()).getOriginalURI()));
        }
    }

    @Override
    public void translate(Document dom) throws Exception {
        Element root = dom.getRootElement();
        ElementFilter nameFilter = new ElementFilter(SERVICE_ELEMENT);
        Iterator iter = root.getDescendants((Filter)nameFilter);
        while (iter.hasNext()) {
            Element clusterElement = (Element)iter.next();
            this.visit(clusterElement);
        }
    }

    private final class ParameterizedURI {
        private final String originalURI;
        private final String scheme;
        private final String host;
        private final String port;
        private final String path;

        private ParameterizedURI(String originalURI, String scheme, String host, String port, String path) {
            this.originalURI = originalURI;
            this.scheme = scheme;
            this.host = host;
            this.port = port;
            this.path = path;
        }

        private String getOriginalURI() {
            return this.originalURI;
        }

        private String getScheme() {
            return this.scheme;
        }

        private String getHost() {
            return this.host;
        }

        private String getPort() {
            return this.port;
        }

        private String getPath() {
            return this.path;
        }

        public boolean isValidBalanceTarget(ParameterizedURI balanceTarget) {
            boolean matches = this.scheme.equals(balanceTarget.getScheme());
            matches = matches && this.port.equals(balanceTarget.getPort());
            matches = matches && this.path.equals(balanceTarget.getPath());
            matches = matches && !this.host.equals(balanceTarget.getHost());
            return matches;
        }

        public String getRelationshipWith(ParameterizedURI otherURI) {
            String otherHost = otherURI.getHost();
            if (!this.host.startsWith("${") && !otherHost.startsWith("${")) {
                String remainingOtherDomain;
                String remainingHostDomain;
                if (otherHost.endsWith("." + this.host)) {
                    return "SUBDOMAIN";
                }
                int firstDotInHost = this.host.indexOf(46);
                int firstDotInOther = otherHost.indexOf(46);
                if (firstDotInHost != -1 && firstDotInOther != -1 && (remainingHostDomain = this.host.substring(firstDotInHost)).equals(remainingOtherDomain = otherHost.substring(firstDotInOther))) {
                    return "PEERDOMAIN";
                }
            }
            return "ANY";
        }
    }
}

