/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUtils {
    private static String productTitle;
    private static String productVersion;
    private static String productEdition;
    private static String productDependencies;
    private static final Logger LOG;
    public static final String KAAZING_PRODUCT = "Kaazing-Product";
    public static final String IMPLEMENTATION_TITLE = "Implementation-Title";
    public static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    public static final String KAAZING_DEPENDENCIES = "Kaazing-Dependencies";

    private VersionUtils() {
    }

    public static String getGatewayProductTitle() {
        VersionUtils.getGatewayProductInfo();
        return productTitle;
    }

    public static String getGatewayProductVersion() {
        VersionUtils.getGatewayProductInfo();
        return productVersion;
    }

    public static String getGatewayProductVersionMajor() {
        String v = VersionUtils.getGatewayProductVersion();
        if (v == null) {
            return null;
        }
        int dotPos = v.indexOf(46);
        return dotPos < 0 ? v : v.substring(0, dotPos);
    }

    public static String getGatewayProductVersionMinor() {
        String v = VersionUtils.getGatewayProductVersion();
        if (v == null || v.length() == 0) {
            return null;
        }
        int dotPos = v.indexOf(46);
        if (dotPos < 0) {
            return v + ".0";
        }
        return (dotPos = v.indexOf(46, dotPos + 1)) < 0 ? v : v.substring(0, dotPos);
    }

    public static String getGatewayProductVersionPatch() {
        String v = VersionUtils.getGatewayProductVersion();
        if ("develop-SNAPSHOT".equals(v)) {
            return "0.0.0";
        }
        if (v == null || v.length() == 0) {
            return null;
        }
        int dotPos = v.indexOf(46);
        if (dotPos < 0) {
            return v + ".0.0";
        }
        if ((dotPos = v.indexOf(46, dotPos + 1)) < 0) {
            return v + ".0";
        }
        return (dotPos = v.indexOf(46, dotPos + 1)) < 0 ? v : v.substring(0, dotPos);
    }

    public static String getGatewayProductVersionBuild() {
        String v = VersionUtils.getGatewayProductVersion();
        if (v == null || v.length() == 0) {
            return null;
        }
        int dotPos = v.indexOf(46);
        if (dotPos < 0) {
            return v + ".0.0.0";
        }
        if ((dotPos = v.indexOf(46, dotPos + 1)) < 0) {
            return v + ".0.0";
        }
        if ((dotPos = v.indexOf(46, dotPos + 1)) < 0) {
            return v + ".0";
        }
        return v;
    }

    public static String getGatewayProductEdition() {
        VersionUtils.getGatewayProductInfo();
        return productEdition;
    }

    public static String getGatewayProductDependencies() {
        VersionUtils.getGatewayProductInfo();
        return productDependencies;
    }

    private static void getGatewayProductInfo() {
        if (productTitle != null) {
            return;
        }
        boolean foundJar = false;
        String[] pathEntries = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        TreeMap<String, Attributes> products = new TreeMap<String, Attributes>(Collections.reverseOrder());
        HashSet<String> removals = new HashSet<String>(7);
        for (String pathEntry : pathEntries) {
            if (!pathEntry.contains("gateway.server")) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Found product entry: %s", pathEntry));
            }
            if (!VersionUtils.getProductInfoFromJar(pathEntry, products, removals)) continue;
            foundJar = true;
        }
        for (String removal : removals) {
            products.remove(removal);
        }
        productTitle = "Kaazing WebSocket Gateway (Development)";
        productVersion = null;
        productEdition = null;
        productDependencies = null;
        if (foundJar && products.size() != 0) {
            Attributes attrs = (Attributes)products.entrySet().iterator().next().getValue();
            productTitle = attrs.getValue(IMPLEMENTATION_TITLE);
            productVersion = attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            productEdition = attrs.getValue(KAAZING_PRODUCT);
            productDependencies = attrs.getValue(KAAZING_DEPENDENCIES);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Elected: %s", productEdition));
            }
        }
    }

    public static void reset() {
        productEdition = null;
        productTitle = null;
        productVersion = null;
        productDependencies = null;
    }

    public static void reset(String edition, String title, String version, String dependencies) {
        productEdition = edition;
        productTitle = title;
        productVersion = version;
        productDependencies = dependencies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean getProductInfoFromJar(String pathEntry, Map<String, Attributes> products, HashSet<String> removals) {
        boolean result = false;
        try (JarFile jar = new JarFile(pathEntry);){
            Manifest mf = jar.getManifest();
            if (mf == null) {
                boolean bl = result;
                return bl;
            }
            Attributes attrs = mf.getMainAttributes();
            if (attrs == null) {
                boolean bl = result;
                return bl;
            }
            String title = attrs.getValue(IMPLEMENTATION_TITLE);
            String version = attrs.getValue(IMPLEMENTATION_VERSION);
            String product = attrs.getValue(KAAZING_PRODUCT);
            if (product == null) return result;
            if (title == null) return result;
            if (version == null) return result;
            result = true;
            String dependencies = attrs.getValue(KAAZING_DEPENDENCIES);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Found: %s [%s]", pathEntry, attrs.getValue(KAAZING_PRODUCT)));
            }
            products.put(product, attrs);
            if (dependencies == null) return result;
            String[] deps = dependencies.split(",");
            Collections.addAll(removals, deps);
            return result;
        }
        catch (IOException e) {
            if (!LOG.isWarnEnabled()) return result;
            LOG.warn("An exception occurred while getting product information", (Throwable)e);
        }
        return result;
    }

    static {
        LOG = LoggerFactory.getLogger(VersionUtils.class);
    }
}

