/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class VersionUtils {
    public static String PRODUCT_TITLE;
    public static String PRODUCT_VERSION;
    public static String PRODUCT_EDITION;
    public static String PRODUCT_DEPENDENCIES;

    private VersionUtils() {
    }

    public static String getGatewayProductTitle() {
        VersionUtils.getGatewayProductInfo();
        return PRODUCT_TITLE;
    }

    public static String getGatewayProductVersion() {
        VersionUtils.getGatewayProductInfo();
        return PRODUCT_VERSION;
    }

    public static String getGatewayProductVersionMajor() {
        String v = VersionUtils.getGatewayProductVersion();
        if (v == null) {
            return null;
        }
        int dotPos = v.indexOf(".");
        return dotPos < 0 ? v : v.substring(0, dotPos);
    }

    public static String getGatewayProductVersionMinor() {
        String v = VersionUtils.getGatewayProductVersion();
        if (v == null || v.length() == 0) {
            return null;
        }
        int dotPos = v.indexOf(".");
        if (dotPos < 0) {
            return v + ".0";
        }
        return (dotPos = v.indexOf(".", dotPos + 1)) < 0 ? v : v.substring(0, dotPos);
    }

    public static String getGatewayProductVersionPatch() {
        String v = VersionUtils.getGatewayProductVersion();
        if ("develop-SNAPSHOT".equals(v)) {
            return "0.0.0";
        }
        if (v == null || v.length() == 0) {
            return null;
        }
        int dotPos = v.indexOf(".");
        if (dotPos < 0) {
            return v + ".0.0";
        }
        if ((dotPos = v.indexOf(".", dotPos + 1)) < 0) {
            return v + ".0";
        }
        return (dotPos = v.indexOf(".", dotPos + 1)) < 0 ? v : v.substring(0, dotPos);
    }

    public static String getGatewayProductVersionBuild() {
        String v = VersionUtils.getGatewayProductVersion();
        if (v == null || v.length() == 0) {
            return null;
        }
        int dotPos = v.indexOf(".");
        if (dotPos < 0) {
            return v + ".0.0.0";
        }
        if ((dotPos = v.indexOf(".", dotPos + 1)) < 0) {
            return v + ".0.0";
        }
        if ((dotPos = v.indexOf(".", dotPos + 1)) < 0) {
            return v + ".0";
        }
        return v;
    }

    public static String getGatewayProductEdition() {
        VersionUtils.getGatewayProductInfo();
        return PRODUCT_EDITION;
    }

    public static String getGatewayProductDependencies() {
        VersionUtils.getGatewayProductInfo();
        return PRODUCT_DEPENDENCIES;
    }

    private static void getGatewayProductInfo() {
        if (PRODUCT_TITLE != null) {
            return;
        }
        boolean foundJar = false;
        String[] pathEntries = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        HashMap<String, Attributes> products = new HashMap<String, Attributes>(7);
        HashSet removals = new HashSet(7);
        for (String pathEntry : pathEntries) {
            if (!pathEntry.contains("gateway.server")) continue;
            try {
                JarFile jar = new JarFile(pathEntry);
                Manifest mf = jar.getManifest();
                Attributes attrs = mf.getMainAttributes();
                if (attrs == null) continue;
                String title = attrs.getValue("Implementation-Title");
                String version = attrs.getValue("Implementation-Version");
                String product = attrs.getValue("Kaazing-Product");
                String dependencies = attrs.getValue("Kaazing-Dependencies");
                if (product == null || title == null || version == null) continue;
                foundJar = true;
                products.put(product != null ? product : title, attrs);
                if (dependencies == null) continue;
                String[] deps = dependencies.split(",");
                Collections.addAll(removals, deps);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        for (String removal : removals) {
            products.remove(removal);
        }
        if (!foundJar || products.size() == 0) {
            PRODUCT_TITLE = "Kaazing WebSocket Gateway (Development)";
            PRODUCT_VERSION = null;
            PRODUCT_EDITION = null;
            PRODUCT_DEPENDENCIES = null;
        } else {
            Attributes attrs = (Attributes)products.values().iterator().next();
            PRODUCT_TITLE = attrs.getValue("Implementation-Title");
            PRODUCT_VERSION = attrs.getValue("Implementation-Version");
            PRODUCT_EDITION = attrs.getValue("Kaazing-Product");
            PRODUCT_DEPENDENCIES = attrs.getValue("Kaazing-Dependencies");
        }
    }
}

