/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.handler;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import stream.app.ComputeGraph;
import stream.app.Reference;
import stream.runtime.DependencyInjection;
import stream.runtime.ElementHandler;
import stream.runtime.LifeCycle;
import stream.runtime.ProcessContainer;
import stream.runtime.setup.factory.ObjectFactory;
import stream.service.Service;
import stream.util.Variables;

public class ServiceElementHandler
implements ElementHandler {
    static Logger log = LoggerFactory.getLogger(ServiceElementHandler.class);
    final ObjectFactory objectFactory;

    public ServiceElementHandler(ObjectFactory factory) {
        this.objectFactory = factory;
    }

    @Override
    public String getKey() {
        return "Service";
    }

    @Override
    public boolean handlesElement(Element element) {
        if (element == null) {
            return false;
        }
        return "service".equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element, Variables variables, DependencyInjection dependencyInjection) throws Exception {
        log.debug("handling element {}...", (Object)element);
        Map<String, String> params = this.objectFactory.getAttributes(element);
        String className = params.get("class");
        if (className == null || "".equals(className.trim())) {
            throw new Exception("No class name provided in 'class' attribute if Service element!");
        }
        String id = params.get("id");
        if (id == null || "".equals(id.trim())) {
            throw new Exception("No valid 'id' attribute provided for Service element!");
        }
        id = id.trim();
        log.debug("Creating new service implementation from class {}", (Object)className);
        try {
            String input;
            Service service = (Service)this.objectFactory.create(className, params, ObjectFactory.createConfigDocument(element), variables);
            service.reset();
            container.getContext().register(id, service);
            if (service instanceof LifeCycle) {
                container.register((LifeCycle)service);
            }
            if ((input = params.get("input")) != null && !input.trim().isEmpty()) {
                ComputeGraph.SourceRef sourceRef = new ComputeGraph.SourceRef((Object)service, "input", input);
                dependencyInjection.add((Reference)sourceRef);
            }
        }
        catch (Exception e) {
            log.error("Failed to create and register service '{}': {}", (Object)id, (Object)e.getMessage());
            throw e;
        }
    }
}

