/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.factory;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.Processor;
import stream.ProcessorList;
import stream.runtime.setup.factory.ObjectFactory;

public class ProcessorFactory {
    static Logger log = LoggerFactory.getLogger(ProcessorFactory.class);
    ObjectFactory objectFactory;
    final List<ProcessorCreationHandler> handlers = new ArrayList<ProcessorCreationHandler>();

    public ProcessorFactory(ObjectFactory of) {
        this.objectFactory = of;
    }

    public void addCreationHandler(ProcessorCreationHandler h) {
        if (!this.handlers.contains(h)) {
            this.handlers.add(h);
        }
    }

    public void removeCreationHandler(ProcessorCreationHandler h) {
        this.handlers.remove(h);
    }

    public List<Processor> createNestedProcessors(Element child) throws Exception {
        ArrayList<Processor> procs = new ArrayList<Processor>();
        NodeList pnodes = child.getChildNodes();
        for (int j = 0; j < pnodes.getLength(); ++j) {
            Processor p;
            Node cnode = pnodes.item(j);
            if (cnode.getNodeType() != 1 || (p = this.createProcessor((Element)cnode)) == null) continue;
            log.debug("Found processor...");
            procs.add(p);
        }
        return procs;
    }

    public Processor createProcessor(Element child) throws Exception {
        Object o = this.objectFactory.create(child);
        if (o instanceof Processor) {
            if (o instanceof ProcessorList) {
                NodeList children = child.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    Processor proc = this.createProcessor(element);
                    if (proc != null) {
                        ((ProcessorList)o).getProcessors().add(proc);
                        continue;
                    }
                    log.warn("Nested element {} is not of type 'stream.data.Processor': ", (Object)node.getNodeName());
                }
            }
            for (ProcessorCreationHandler handler : this.handlers) {
                try {
                    handler.processorCreated((Processor)o, child);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
            }
            return (Processor)o;
        }
        return null;
    }

    public static interface ProcessorCreationHandler {
        public void processorCreated(Processor var1, Element var2) throws Exception;
    }
}

