/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.factory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.CopiesUtils;
import stream.Copy;
import stream.Process;
import stream.Processor;
import stream.ProcessorList;
import stream.app.ComputeGraph;
import stream.app.Reference;
import stream.io.Sink;
import stream.runtime.DependencyInjection;
import stream.runtime.ProcessContainer;
import stream.runtime.ProcessContextImpl;
import stream.runtime.setup.factory.ObjectFactory;
import stream.runtime.setup.factory.ProcessConfiguration;
import stream.runtime.setup.factory.ProcessFactory;
import stream.runtime.setup.handler.ProcessElementHandler;
import stream.service.Service;
import stream.util.Variables;

public class DefaultProcessFactory
implements ProcessFactory {
    static Logger log = LoggerFactory.getLogger(ProcessElementHandler.class);
    private final ProcessContainer processContainer;
    private final ObjectFactory objectFactory;
    private final ComputeGraph computeGraph;
    protected String defaultProcessImplementation = "stream.runtime.DefaultProcess";
    private final DependencyInjection dependencyInjection;
    protected String processType;

    public DefaultProcessFactory(ProcessContainer processContainer, ObjectFactory objectFactory, DependencyInjection dependencyInjection) {
        this.processContainer = processContainer;
        this.objectFactory = objectFactory;
        this.computeGraph = processContainer.computeGraph();
        this.dependencyInjection = dependencyInjection;
        this.processType = "process";
    }

    @Override
    public ProcessConfiguration[] createConfigurations(Element e, Variables v) {
        ProcessConfiguration config = new ProcessConfiguration();
        config.setCopy(new Copy());
        Map<String, String> attr = this.objectFactory.getAttributes(e);
        config.setAttributes(attr);
        config.setElement(e);
        config.setProcessType(this.processType);
        String src = attr.get("source");
        if (src == null) {
            src = attr.get("input");
        }
        String out = attr.get("output");
        config.setOutput(out);
        String processClass = this.defaultProcessImplementation;
        if (attr.containsKey("class")) {
            processClass = attr.get("class");
            log.debug("Using custom process class '{}'", (Object)processClass);
        }
        config.setProcessClass(processClass);
        String id = attr.get("id");
        if (id == null || "".equals(id.trim())) {
            id = "process-" + UUID.randomUUID().toString();
        }
        String copies = attr.get("copies");
        if (attr.containsKey("multiply")) {
            copies = attr.get("multiply");
            log.warn("The attribute 'multiply' is deprecated for element 'Process'");
            log.warn("Please use 'copies' instead of 'multiply'.");
        }
        if (copies != null && !"".equals(copies.trim())) {
            log.debug("Expanding '{}'", (Object)copies);
            copies = v.expand(copies);
            Copy[] ids = CopiesUtils.parse((String)copies);
            log.debug("Creating {} processes due to copies='{}'", (Object)ids.length, (Object)copies);
            ProcessConfiguration[] configs = new ProcessConfiguration[ids.length];
            int i = 0;
            for (Copy copy : ids) {
                ProcessConfiguration configi = null;
                try {
                    configi = (ProcessConfiguration)config.clone();
                }
                catch (CloneNotSupportedException e1) {
                    e1.printStackTrace();
                }
                configs[i] = configi;
                configi.setVariables(v);
                Variables local = configi.getVariables();
                String idpid = id + "-" + copy.getId();
                idpid = local.expand(idpid);
                configi.setId(idpid);
                configi.setCopy(copy);
                String input = local.expand(src);
                log.debug("Setting source for process {} to {}", (Object)idpid, (Object)input);
                configi.setInput(input);
                if (out != null) {
                    String processOut = local.expand(out);
                    log.debug("Setting process output for process {} to {}", (Object)idpid, (Object)processOut);
                    configi.setOutput(processOut);
                } else {
                    log.debug("Process has no output connection...");
                }
                ++i;
            }
            return configs;
        }
        Variables local = new Variables(v);
        config.setVariables(local);
        id = local.expand(id);
        config.setId(id);
        if (src != null) {
            config.setInput(local.expand(src));
        }
        return new ProcessConfiguration[]{config};
    }

    @Override
    public void createAndRegisterProcesses(ProcessConfiguration[] configs) throws Exception {
        for (ProcessConfiguration config : configs) {
            String outputId;
            log.trace("Creating 'process' element, variable context is:");
            for (String key : config.getVariables().keySet()) {
                log.trace("  '{}' = '{}'", (Object)key, (Object)config.getVariables().get(key));
            }
            Process process = (Process)this.objectFactory.create(config.getProcessClass(), config.getAttributes(), config.getElement(), config.getVariables());
            this.processContainer.getProcesses().add(process);
            this.computeGraph.addProcess(config.getId(), process);
            log.debug("Created Process object: {}", (Object)process);
            log.debug("Process input is: '{}'", (Object)config.getInput());
            process.getProperties().putAll(config.getAttributes());
            process.getProperties().putAll(config.getVariables());
            String input = config.getInput();
            if (input != null && !input.trim().isEmpty()) {
                ComputeGraph.SourceRef sourceRef = new ComputeGraph.SourceRef((Object)process, "input", input);
                this.dependencyInjection.add((Reference)sourceRef);
                this.computeGraph.addReference(sourceRef);
            }
            if ((outputId = config.getOutput()) != null && !outputId.trim().isEmpty()) {
                ComputeGraph.SinkRef sinkRef = new ComputeGraph.SinkRef((Object)process, "output", outputId);
                log.debug("Adding output reference for process {} to {}", (Object)process, (Object)outputId);
                this.dependencyInjection.add((Reference)sinkRef);
                this.computeGraph.addReference(sinkRef);
            }
            ProcessContextImpl ctx = new ProcessContextImpl(config.getId(), this.processContainer.getContext());
            for (Map.Entry<String, String> e : config.getAttributes().entrySet()) {
                ctx.set(e.getKey(), e.getValue());
            }
            for (Map.Entry<String, String> e : config.getVariables().entrySet()) {
                ctx.set(e.getKey(), e.getValue());
            }
            this.processContainer.setProcessContext(process, ctx);
            List<Processor> procs = this.createNestedProcessors(config.getElement(), config.getVariables());
            for (Processor p : procs) {
                process.add(p);
                this.processContainer.computeGraph().add((Object)process, (Object)p);
            }
        }
    }

    protected List<Processor> createNestedProcessors(Element child, Variables local) throws Exception {
        ArrayList<Processor> procs = new ArrayList<Processor>();
        NodeList pnodes = child.getChildNodes();
        for (int j = 0; j < pnodes.getLength(); ++j) {
            Processor p;
            Node cnode = pnodes.item(j);
            if (cnode.getNodeType() != 1 || (p = this.createProcessorAndRegisterServices((Element)cnode, local)) == null) continue;
            log.debug("Found processor...");
            procs.add(p);
        }
        return procs;
    }

    protected Processor createProcessorAndRegisterServices(Element child, Variables local) throws Exception {
        Map<String, String> params = this.objectFactory.getAttributes(child);
        Object o = null;
        try {
            o = this.objectFactory.create(child, params, local);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error in:" + child.getNodeName(), e);
        }
        if (o instanceof ProcessorList) {
            NodeList children = child.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                Processor proc = this.createProcessorAndRegisterServices(element, local);
                if (proc != null) {
                    ((ProcessorList)o).getProcessors().add(proc);
                    continue;
                }
                log.warn("Nested element {} is not of type 'stream.data.Processor': ", (Object)node.getNodeName());
            }
        }
        if (o instanceof Processor) {
            if (params.containsKey("id") && !"".equals(params.get("id").trim())) {
                if (o instanceof Service) {
                    String id = params.get("id").trim();
                    id = local.expand(id);
                    log.debug("Registering processor with id '{}' in look-up service", (Object)id);
                    this.processContainer.getContext().register(id, (Service)o);
                } else {
                    log.warn("Processor '{}' specifies an ID attribute '{}' but does not implement a Service interface. Processor will *not* be registered!", (Object)o.getClass().getName(), (Object)params.get("id"));
                }
            }
            Iterator<String> iterator = params.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String k = key = iterator.next();
                if (key.endsWith("-ref")) {
                    throw new Exception("'-ref' attributes are no longer supported!");
                }
                String value = local.expand(params.get(k));
                Class<? extends Sink> sinkClass = DependencyInjection.hasSinkSetter(key, o);
                if (sinkClass != null) {
                    log.debug("Found queue-injection for key '{}' in processor '{}'", (Object)key, o);
                    String[] refs = CopiesUtils.parseIds((String)value);
                    ComputeGraph.SinkRef sinkRefs = new ComputeGraph.SinkRef(o, key, refs);
                    this.computeGraph.addReference(sinkRefs);
                    this.dependencyInjection.add((Reference)sinkRefs);
                    log.debug("Adding QueueRef to '{}' for object {}", (Object)refs, o);
                    continue;
                }
                Class<? extends Service> serviceClass = DependencyInjection.hasServiceSetter(key, o);
                if (serviceClass == null) continue;
                log.debug("Found service setter for key '{}' in processor {}", (Object)key, o);
                String[] refs = CopiesUtils.parseIds((String)value);
                log.debug("Adding ServiceRef to '{}' for object {}", (Object)refs, o);
                ComputeGraph.ServiceRef serviceRef = new ComputeGraph.ServiceRef(o, key, refs, serviceClass);
                this.computeGraph.addReference(serviceRef);
                this.dependencyInjection.add((Reference)serviceRef);
            }
            return (Processor)o;
        }
        return null;
    }
}

