/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.annotations.Parameter;
import stream.runtime.DependencyInjection;
import stream.runtime.setup.ParameterInjection;
import stream.runtime.setup.ParameterValueMapper;
import stream.util.Variables;

public class ParameterMethodInjection
extends ParameterValueMapper {
    static Logger log = LoggerFactory.getLogger(ParameterMethodInjection.class);

    public Set<String> inject(Object o, Map<String, ?> params, Variables context) throws Exception {
        HashSet<String> alreadySet = new HashSet<String>();
        for (Method m : o.getClass().getMethods()) {
            if (DependencyInjection.isServiceSetter(m)) {
                log.debug("Skipping ServiceSetter '{}'", (Object)m.getName());
                continue;
            }
            if (DependencyInjection.isSourceSetter(m)) {
                log.debug("Skipping SourceSetter '{}'", (Object)m.getName());
                continue;
            }
            if (ParameterInjection.isQueueSetter(m)) {
                log.debug("Skipping QueueSetter '{}'", (Object)m.getName());
                continue;
            }
            if (!ParameterMethodInjection.isSetter(m)) continue;
            log.debug("Handling set-method '{}'", (Object)m.getName());
            boolean required = false;
            String key = ParameterMethodInjection.getParameterName(m);
            Parameter p = m.getAnnotation(Parameter.class);
            if (p != null) {
                if (p.name() != null && !p.name().isEmpty()) {
                    key = p.name();
                    log.info("Using parameter name '{}' from annotation", (Object)key);
                }
                if (required = p.required()) {
                    log.debug("Parameter '{}' is annotated as required", (Object)key);
                } else {
                    log.debug("Parameter '{}' is annotated as optional", (Object)key);
                }
            }
            log.debug("Parameter key is '{}'", (Object)key);
            Object value = params.get(key);
            if (value == null) continue;
            Object po = this.createValue(m.getParameterTypes()[0], params.get(key));
            m.invoke(o, po);
            alreadySet.add(key);
        }
        return alreadySet;
    }

    public static boolean isSetter(Method m) {
        if (!m.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] types = m.getParameterTypes();
        return types.length == 1;
    }

    public static String getParameterName(Method m) {
        if (!ParameterMethodInjection.isSetter(m)) {
            return null;
        }
        String key = null;
        Parameter p = m.getAnnotation(Parameter.class);
        if (p != null && p.name() != null && !p.name().isEmpty()) {
            key = p.name();
        } else {
            key = m.getName().substring(3);
            key = Character.toLowerCase(key.charAt(0)) + key.substring(1);
        }
        return key;
    }
}

