/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.rpc;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.rpc.RMIServiceDelegator;
import stream.runtime.rpc.RemoteEndpoint;
import stream.runtime.rpc.ServiceProxy;
import stream.service.Service;

public final class Naming {
    static Logger log = LoggerFactory.getLogger(Naming.class);
    private static Registry registry;
    static final Naming NAMING;

    private Naming() {
        try {
            registry = LocateRegistry.createRegistry(9100);
            log.info("Created registry at port 9100");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean bind(String name, Service service) throws Exception {
        ServiceProxy proxy = new ServiceProxy(service);
        registry.bind(name, proxy);
        return true;
    }

    public static <T extends Service> T lookup(String name, Class<T> serviceClass) throws Exception {
        RemoteEndpoint re = (RemoteEndpoint)registry.lookup(name);
        Service service = (Service)Proxy.newProxyInstance(re.getClass().getClassLoader(), new Class[]{serviceClass}, (InvocationHandler)new ServiceDelegator(re));
        return (T)service;
    }

    static {
        NAMING = new Naming();
    }

    public static final class ServiceDelegator
    implements InvocationHandler {
        Logger log = LoggerFactory.getLogger(ServiceDelegator.class);
        final RemoteEndpoint endpoint;

        public ServiceDelegator(RemoteEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getName().equals("toString") && args == null) {
                    return this.toString();
                }
                ArrayList<Serializable> params = new ArrayList<Serializable>();
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        params.add((Serializable)args[i]);
                    }
                }
                Serializable result = this.endpoint.call(method.getName(), RMIServiceDelegator.computeSignature(method), params);
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

