/*
 * Decompiled with CFR 0.152.
 */
package stream.doc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Processor;
import stream.doc.DocConverter;
import stream.doc.DocTree;
import stream.doc.MarkdownToTexConverter;
import stream.io.Stream;
import stream.runtime.StreamRuntime;
import stream.util.URLUtilities;
import stream.util.Variables;

public class DocGenerator {
    public static final Class<?>[] CLASSES = new Class[]{Processor.class, Stream.class};
    static final DocConverter converter = new MarkdownToTexConverter();
    static Logger log = LoggerFactory.getLogger(DocGenerator.class);
    File outDir;

    public DocGenerator(File outputDirectory) {
        this.outDir = outputDirectory;
    }

    public void generateDocs(List<String> packages) throws Exception {
        this.generateDocs(packages.toArray(new String[packages.size()]));
    }

    public void generateDocs(String[] packages) throws Exception {
        if (!this.outDir.isDirectory()) {
            this.outDir.mkdirs();
        }
        if (!this.outDir.isDirectory()) {
            throw new Exception("Failed to create output directory '" + this.outDir.getAbsolutePath() + "'!");
        }
        log.info("Searching for processors,streams,...");
        DocTree tree = DocTree.findDocs(CLASSES, packages);
        tree.print("  ");
        tree.generateDocs(this.outDir);
        URL packageUrl = DocGenerator.class.getResource("/streams.pkg");
        if (packageUrl != null) {
            File streamsPkg = new File(this.outDir.getAbsolutePath() + File.separator + "streams.pkg");
            log.info("Copying {} to {}", (Object)packageUrl, (Object)streamsPkg);
            URLUtilities.copy((URL)packageUrl, (File)streamsPkg);
        }
    }

    public static void write(URL url, PrintStream out) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        while (line != null) {
            out.println(line);
            line = reader.readLine();
        }
        reader.close();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[8192];
        int read = in.read(buf);
        while (read > 0) {
            out.write(buf, 0, read);
            read = in.read(buf);
        }
    }

    public static void main(String[] args) {
        try {
            StreamRuntime.setupLogging();
            String output = System.getProperty("output");
            if (output == null) {
                output = "/tmp";
            }
            File outDir = new File(output);
            DocTree tree = DocTree.findDocs(CLASSES, args);
            tree.print("  ");
            List<File> indexFiles = tree.generateDocs(outDir);
            String doc = URLUtilities.readContentOrEmpty((URL)DocGenerator.class.getResource("/API.tex"));
            StringBuffer incl = new StringBuffer();
            for (File index : indexFiles) {
                incl.append("\\input{" + index.getName() + "}\n");
            }
            Variables vars = new Variables();
            vars.put("includes", incl.toString());
            doc = vars.expand(doc);
            PrintStream p = new PrintStream(new File(outDir.getCanonicalPath() + File.separator + "API.tex"));
            p.println(doc);
            p.close();
            URLUtilities.copy((URL)DocGenerator.class.getResource("/streams.pkg"), (File)new File(outDir.getCanonicalPath() + File.separator + "streams.pkg"));
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

