/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.http.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.jwall.web.http.HttpHeader;
import org.jwall.web.http.HttpRequest;
import org.jwall.web.http.ProtocolException;
import org.jwall.web.http.nio.HttpMessageChannel;
import org.jwall.web.http.nio.TimeOutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestChannel
extends HttpMessageChannel<HttpRequest> {
    public static final String TIMEOUT_PROPERTY = "org.jwall.web.http.HttpRequestStream.timeout";
    public static Logger log = LoggerFactory.getLogger((String)"HttpRequestStream.class");
    HttpHeader header = null;
    static int id = 0;
    int myId = 0;
    int reqNum = 0;

    public HttpRequestChannel(ReadableByteChannel in) throws IOException {
        super(in);
        this.state = 0;
        this.myId = ++id;
        try {
            this.setTimeout(1000 * Integer.parseInt(System.getProperty(TIMEOUT_PROPERTY)));
        }
        catch (Exception e) {
            int dt = 60;
            this.setTimeout(dt * 1000);
        }
    }

    public HttpRequestChannel(InputStream in) throws IOException {
        this(Channels.newChannel(in));
    }

    @Override
    public HttpRequest readMessage() throws TimeOutException, IOException, ProtocolException {
        return this.readRequest();
    }

    public HttpRequest readRequest() throws TimeOutException, IOException, ProtocolException {
        if (this.header == null) {
            this.header = this.readHeader();
        }
        if (this.header == null) {
            return null;
        }
        if (this.header.getContentLength() > 0 && this.state == 1) {
            ByteBuffer buf = super.readBody(this.header.getContentLength());
            if (buf == null) {
                return null;
            }
            ++this.reqNum;
            return new HttpRequest(this.header, buf.array());
        }
        HttpHeader hd = this.header;
        this.header = null;
        this.state = 0;
        ++this.reqNum;
        return new HttpRequest(hd, new byte[0]);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public int getNumberOfRequests() {
        return this.reqNum;
    }

    public String toString() {
        return "HttpRequestChannel[" + this.myId + " request #" + this.reqNum + "] ";
    }
}

