/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.http.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jwall.web.http.HttpHeader;
import org.jwall.web.http.HttpMessage;
import org.jwall.web.http.ProtocolException;
import org.jwall.web.http.nio.BufferedReadableByteChannel;
import org.jwall.web.http.nio.TimeOutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpMessageChannel<T extends HttpMessage> {
    private static Logger log = LoggerFactory.getLogger((String)"HttpMessageStream.class");
    public static final int STATE_READING_HEADER = 0;
    public static final int STATE_READING_BODY = 1;
    BufferedReadableByteChannel in;
    Integer timeout = 60000;
    long lastData = 0L;
    int state = 0;
    StringBuffer partialHeader = new StringBuffer();
    HttpHeader header = null;
    ByteBuffer body = null;

    protected HttpMessageChannel(ReadableByteChannel inChannel) {
        this.in = new BufferedReadableByteChannel(inChannel, 32768);
        this.touch();
    }

    public HttpHeader readHeader() throws TimeOutException, IOException, ProtocolException {
        log.debug("Entering HttpRequestStream.readHeader()");
        if (this.state == 1) {
            throw new ProtocolException("Last header indicated a message-body - need to read that first!");
        }
        String line = this.in.readLine();
        if (line == null) {
            return null;
        }
        line = line.trim();
        this.touch();
        while (!line.equals("")) {
            this.partialHeader.append(line);
            this.partialHeader.append("\r\n");
            line = this.in.readLine();
            if (line == null) {
                return null;
            }
            line = line.trim();
        }
        this.partialHeader.append("\r\n");
        HttpHeader head = null;
        try {
            head = new HttpHeader(this.partialHeader.toString());
        }
        catch (Exception e) {
            log.error(this + " Exception: " + e.getMessage());
            log.error(this + " PartialHeader: " + this.partialHeader);
        }
        if (head.getContentLength() > 0) {
            this.state = 1;
        }
        this.partialHeader = new StringBuffer();
        log.debug("Completed reading the current header, leaving HttpRequestStream.readHeader()");
        this.touch();
        return head;
    }

    public ByteBuffer readBody(int contentLength) throws IOException, TimeOutException, ProtocolException {
        int bytes;
        if (this.state == 0) {
            throw new ProtocolException("You're trying to read a message body, but should read a header!");
        }
        if (this.body == null) {
            this.body = ByteBuffer.allocate(contentLength);
        }
        if ((bytes = this.in.read(this.body)) > 0) {
            this.touch();
        }
        log.debug(this + " readBody: managed to read {} bytes of data, buffer-limit is {}", (Object)bytes, (Object)this.body.limit());
        if (this.body.remaining() == 0) {
            this.state = 0;
            ByteBuffer buf = this.body;
            buf.flip();
            this.body = null;
            log.debug("readBody: managed to fill the buffer, changing to READ_HEADER state and returning the body");
            return buf;
        }
        log.debug("readBody: there are {} bytes missing for completing the pending message-body", (Object)this.body.remaining());
        return null;
    }

    public int getState() {
        return this.state;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer to) {
        this.timeout = to;
    }

    public boolean timedOut() {
        return System.currentTimeMillis() - this.lastData > this.timeout.longValue();
    }

    public void touch() {
        this.lastData = System.currentTimeMillis();
    }

    public abstract T readMessage() throws TimeOutException, IOException, ProtocolException;
}

