/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class TimeFormat {
    public static final int SHORT_FORMAT = 0;
    public static final int LONG_FORMAT = 1;
    public static final long SEC_MS = 1000L;
    public static final long MIN_MS = 60000L;
    public static final long HOUR_MS = 3600000L;
    public static final long DAY_MS = 86400000L;
    public static final long YEAR_MS = 31536000000L;
    static final NumberFormat fmt = null;
    static final long[] UNITS = new long[]{31536000000L, 86400000L, 3600000L, 60000L};
    static final String[] UNIT_NAME = new String[]{" year", " day", "h", "m"};
    static final String[] UNIT_LONG_NAMES = new String[]{" year", " day", " hour", " minute"};
    private String[] format = UNIT_NAME;
    private int style = 0;
    NumberFormat secondFormat = new DecimalFormat("0.00");

    public TimeFormat() {
        this(0);
    }

    public TimeFormat(int style) {
        this.style = style;
        this.format = UNIT_NAME;
        if (style == 1) {
            this.format = UNIT_LONG_NAMES;
            this.secondFormat = new DecimalFormat("0");
        }
    }

    public String format(long timeInMilliseconds) {
        long ms;
        long left = ms = timeInMilliseconds;
        long units = 0L;
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < UNITS.length; ++i) {
            long unit = UNITS[i];
            if (ms <= unit) continue;
            left = timeInMilliseconds % unit;
            units = (ms - left) / unit;
            s.append(units);
            if (this.style == 1) {
                s.append(" ");
            }
            s.append(this.format[i]);
            if (units > 1L && i > 0) {
                s.append("s");
            }
            s.append(" ");
            ms = left;
        }
        double sec = (double)ms / 1000.0;
        if (s.length() == 0 || sec > 0.0) {
            s.append(this.secondFormat.format(sec));
            if (this.style == 1) {
                s.append(" sec");
            } else {
                s.append("s");
            }
        }
        return s.toString();
    }

    public static String formatLong(long timeInMillis) {
        TimeFormat fmt = new TimeFormat(1);
        return fmt.format(timeInMillis);
    }
}

